/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ProxyUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseableDelegateInvocationHandler
implements InvocationHandler {
    private final Object proxyTarget;
    private final AutoCloseable delegate;
    private final Object[] closers;

    public AutoCloseableDelegateInvocationHandler(Object object, AutoCloseable autoCloseable) {
        this.proxyTarget = Objects.requireNonNull(object, "No proxy target to wrap");
        this.delegate = Objects.requireNonNull(autoCloseable, "No delegate to auto-close");
        this.closers = new Object[]{object, autoCloseable};
    }

    public Object getProxyTarget() {
        return this.proxyTarget;
    }

    public AutoCloseable getAutoCloseableDelegate() {
        return this.delegate;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (!AutoCloseableDelegateInvocationHandler.isCloseMethodInvocation(method, objectArray)) {
            Object object2 = this.getProxyTarget();
            try {
                return method.invoke(object2, objectArray);
            }
            catch (Throwable throwable) {
                Class<?> clazz = object2.getClass();
                Logger logger = LoggerFactory.getLogger(clazz);
                LoggingUtils.debug(logger, "invoke({}#{}) failed ({}) to execute: {}", clazz.getSimpleName(), method.getName(), throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
                throw ProxyUtils.unwrapInvocationThrowable(throwable);
            }
        }
        Throwable throwable = null;
        for (Object object3 : this.closers) {
            if (!(object3 instanceof AutoCloseable)) continue;
            try {
                method.invoke(object3, objectArray);
            }
            catch (Throwable throwable2) {
                Class<?> clazz = object3.getClass();
                Logger logger = LoggerFactory.getLogger(clazz);
                LoggingUtils.debug(logger, "invoke({}#{}) failed ({}) to execute: {}", clazz.getSimpleName(), method.getName(), throwable2.getClass().getSimpleName(), throwable2.getMessage(), throwable2);
                throwable = ExceptionUtils.accumulateException(throwable, throwable2);
            }
        }
        if (throwable != null) {
            throw ProxyUtils.unwrapInvocationThrowable(throwable);
        }
        return null;
    }

    public static AutoCloseable wrapDelegateCloseable(Object object, Class clazz, AutoCloseable autoCloseable) {
        return (AutoCloseable)ProxyUtils.newProxyInstance(clazz, new AutoCloseableDelegateInvocationHandler(object, autoCloseable));
    }

    public static boolean isCloseMethodInvocation(Method method, Object[] objectArray) {
        return AutoCloseableDelegateInvocationHandler.isCloseMethod(method) && GenericUtils.isEmpty(objectArray);
    }

    public static boolean isCloseMethod(Method method) {
        int n2 = method == null ? 0 : method.getModifiers();
        return method != null && "close".equals(method.getName()) && Modifier.isPublic(n2) && !Modifier.isStatic(n2) && Void.TYPE == method.getReturnType() && GenericUtils.isEmpty(method.getParameterTypes());
    }
}

