/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.AbstractCloseable$State;
import org.apache.sshd.common.util.closeable.Builder;
import org.apache.sshd.common.util.closeable.IoBaseCloseable;

public abstract class AbstractCloseable
extends IoBaseCloseable {
    protected final Object futureLock = new Object();
    protected final AtomicReference state = new AtomicReference<AbstractCloseable$State>(AbstractCloseable$State.Opened);
    protected final CloseFuture closeFuture;

    protected AbstractCloseable() {
        this("");
    }

    protected AbstractCloseable(String string) {
        super(string);
        this.closeFuture = new DefaultCloseFuture(string, this.futureLock);
    }

    public Object getFutureLock() {
        return this.futureLock;
    }

    @Override
    public void addCloseFutureListener(SshFutureListener sshFutureListener) {
        this.closeFuture.addListener(sshFutureListener);
    }

    @Override
    public void removeCloseFutureListener(SshFutureListener sshFutureListener) {
        this.closeFuture.removeListener(sshFutureListener);
    }

    @Override
    public final CloseFuture close(boolean bl2) {
        boolean bl3 = this.log.isDebugEnabled();
        if (bl2) {
            if (this.state.compareAndSet(AbstractCloseable$State.Opened, AbstractCloseable$State.Immediate) || this.state.compareAndSet(AbstractCloseable$State.Graceful, AbstractCloseable$State.Immediate)) {
                if (bl3) {
                    this.log.debug("close({}) Closing immediately", (Object)this);
                }
                this.preClose();
                this.doCloseImmediately();
                if (bl3) {
                    this.log.debug("close({})[Immediately] closed", (Object)this);
                }
            } else if (bl3) {
                this.log.debug("close({})[Immediately] state already {}", (Object)this, (Object)this.state);
            }
        } else if (this.state.compareAndSet(AbstractCloseable$State.Opened, AbstractCloseable$State.Graceful)) {
            if (bl3) {
                this.log.debug("close({}) Closing gracefully", (Object)this);
            }
            this.preClose();
            CloseFuture closeFuture2 = this.doCloseGracefully();
            if (closeFuture2 != null) {
                closeFuture2.addListener(closeFuture -> {
                    if (this.state.compareAndSet(AbstractCloseable$State.Graceful, AbstractCloseable$State.Immediate)) {
                        this.doCloseImmediately();
                        if (bl3) {
                            this.log.debug("close({}][Graceful] - operationComplete() closed", (Object)this);
                        }
                    }
                });
            } else if (this.state.compareAndSet(AbstractCloseable$State.Graceful, AbstractCloseable$State.Immediate)) {
                this.doCloseImmediately();
                if (bl3) {
                    this.log.debug("close({})[Graceful] closed", (Object)this);
                }
            }
        } else if (bl3) {
            this.log.debug("close({})[Graceful] state already {}", (Object)this, (Object)this.state);
        }
        return this.closeFuture;
    }

    @Override
    public final boolean isClosed() {
        return this.state.get() == AbstractCloseable$State.Closed;
    }

    @Override
    public final boolean isClosing() {
        return this.state.get() != AbstractCloseable$State.Opened;
    }

    protected void preClose() {
    }

    protected CloseFuture doCloseGracefully() {
        return null;
    }

    protected void doCloseImmediately() {
        this.closeFuture.setClosed();
        this.state.set(AbstractCloseable$State.Closed);
    }

    protected Builder builder() {
        return new Builder(this.futureLock);
    }
}

