/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.security.PublicKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.apache.sshd.common.config.keys.u2f.SkED25519PublicKey;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;
import org.apache.sshd.common.util.buffer.keys.ED25519BufferPublicKeyParser;

public class SkED25519BufferPublicKeyParser
extends AbstractBufferPublicKeyParser {
    public static final SkED25519BufferPublicKeyParser INSTANCE = new SkED25519BufferPublicKeyParser();

    public SkED25519BufferPublicKeyParser() {
        super(SkED25519PublicKey.class, "sk-ssh-ed25519@openssh.com");
    }

    @Override
    public SkED25519PublicKey getRawPublicKey(String string, Buffer buffer) {
        PublicKey publicKey = ED25519BufferPublicKeyParser.INSTANCE.getRawPublicKey("ssh-ed25519", buffer);
        String string2 = buffer.getString();
        return new SkED25519PublicKey(string2, false, (EdDSAPublicKey)publicKey);
    }
}

