/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;

public class RSABufferPublicKeyParser
extends AbstractBufferPublicKeyParser {
    public static final RSABufferPublicKeyParser INSTANCE = new RSABufferPublicKeyParser();

    public RSABufferPublicKeyParser() {
        super(RSAPublicKey.class, "ssh-rsa");
    }

    @Override
    public RSAPublicKey getRawPublicKey(String string, Buffer buffer) {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(string), "Unsupported key type: %s", (Object)string);
        BigInteger bigInteger = buffer.getMPInt();
        BigInteger bigInteger2 = buffer.getMPInt();
        return (RSAPublicKey)this.generatePublicKey("RSA", new RSAPublicKeySpec(bigInteger2, bigInteger));
    }
}

