/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificate$Type;
import org.apache.sshd.common.config.keys.OpenSshCertificateImpl;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;

public class OpenSSHCertPublicKeyParser
extends AbstractBufferPublicKeyParser {
    public static final List KEY_TYPES = Collections.unmodifiableList(Arrays.asList("ssh-rsa-cert-v01@openssh.com", "ssh-dss-cert-v01@openssh.com", "ecdsa-sha2-nistp256-cert-v01@openssh.com", "ecdsa-sha2-nistp384-cert-v01@openssh.com", "ecdsa-sha2-nistp521-cert-v01@openssh.com", "ssh-ed25519-cert-v01@openssh.com"));
    public static final OpenSSHCertPublicKeyParser INSTANCE = new OpenSSHCertPublicKeyParser();

    public OpenSSHCertPublicKeyParser() {
        super(OpenSshCertificate.class, KEY_TYPES);
    }

    @Override
    public OpenSshCertificate getRawPublicKey(String string, Buffer buffer) {
        OpenSshCertificateImpl openSshCertificateImpl = new OpenSshCertificateImpl();
        openSshCertificateImpl.setKeyType(string);
        openSshCertificateImpl.setNonce(buffer.getBytes());
        String string2 = openSshCertificateImpl.getRawKeyType();
        PublicKey publicKey = DEFAULT.getRawPublicKey(string2, buffer);
        openSshCertificateImpl.setCertPubKey(publicKey);
        openSshCertificateImpl.setSerial(buffer.getLong());
        openSshCertificateImpl.setType(OpenSshCertificate$Type.fromCode(buffer.getInt()));
        openSshCertificateImpl.setId(buffer.getString());
        Collection collection = new ByteArrayBuffer(buffer.getBytes()).getStringList(false);
        openSshCertificateImpl.setPrincipals(collection);
        openSshCertificateImpl.setValidAfter(buffer.getLong());
        openSshCertificateImpl.setValidBefore(buffer.getLong());
        openSshCertificateImpl.setCriticalOptions(buffer.getCertificateOptions());
        openSshCertificateImpl.setExtensions(buffer.getCertificateOptions());
        String string3 = GenericUtils.trimToEmpty(buffer.getString());
        openSshCertificateImpl.setReserved(string3.isEmpty() ? null : string3);
        try {
            openSshCertificateImpl.setCaPubKey(buffer.getPublicKey());
        }
        catch (SshException sshException) {
            throw new InvalidKeyException("Could not parse public CA key with ID: " + openSshCertificateImpl.getId(), sshException);
        }
        openSshCertificateImpl.setMessage(buffer.getBytesConsumed());
        openSshCertificateImpl.setSignature(buffer.getBytes());
        if (buffer.rpos() != buffer.wpos()) {
            throw new InvalidKeyException("Cannot read OpenSSH certificate, got more data than expected: " + buffer.rpos() + ", actual: " + buffer.wpos() + ". ID of the ca certificate: " + openSshCertificateImpl.getId());
        }
        return openSshCertificateImpl;
    }
}

