/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.security.PublicKey;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;
import org.apache.sshd.common.util.security.SecurityUtils;

public class ED25519BufferPublicKeyParser
extends AbstractBufferPublicKeyParser {
    public static final ED25519BufferPublicKeyParser INSTANCE = new ED25519BufferPublicKeyParser();

    public ED25519BufferPublicKeyParser() {
        super(PublicKey.class, "ssh-ed25519");
    }

    @Override
    public PublicKey getRawPublicKey(String string, Buffer buffer) {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(string), "Unsupported key type: %s", (Object)string);
        byte[] byArray = buffer.getBytes();
        return SecurityUtils.generateEDDSAPublicKey(string, byArray);
    }
}

