/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;

public class ECBufferPublicKeyParser
extends AbstractBufferPublicKeyParser {
    public static final ECBufferPublicKeyParser INSTANCE = new ECBufferPublicKeyParser();

    public ECBufferPublicKeyParser() {
        super(ECPublicKey.class, ECCurves.KEY_TYPES);
    }

    @Override
    public ECPublicKey getRawPublicKey(String string, Buffer buffer) {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(string), "Unsupported key type: %s", (Object)string);
        ECCurves eCCurves = ECCurves.fromKeyType(string);
        if (eCCurves == null) {
            throw new NoSuchAlgorithmException("Unsupported raw public algorithm: " + string);
        }
        String string2 = eCCurves.getName();
        ECParameterSpec eCParameterSpec = eCCurves.getParameters();
        return this.getRawECKey(string2, eCParameterSpec, buffer);
    }

    protected ECPublicKey getRawECKey(String string, ECParameterSpec eCParameterSpec, Buffer buffer) {
        ECPoint eCPoint;
        String string2 = buffer.getString();
        if (!string.equals(string2)) {
            throw new InvalidKeySpecException("getRawECKey(" + string + ") curve name does not match expected: " + string2);
        }
        if (eCParameterSpec == null) {
            throw new InvalidKeySpecException("getRawECKey(" + string + ") missing curve parameters");
        }
        byte[] byArray = buffer.getBytes();
        try {
            eCPoint = ECCurves.octetStringToEcPoint(byArray);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidKeySpecException("getRawECKey(" + string + ") cannot (" + runtimeException.getClass().getSimpleName() + ") retrieve W value: " + runtimeException.getMessage(), runtimeException);
        }
        return (ECPublicKey)this.generatePublicKey("EC", new ECPublicKeySpec(eCPoint, eCParameterSpec));
    }
}

