/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.math.BigInteger;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;

public class DSSBufferPublicKeyParser
extends AbstractBufferPublicKeyParser {
    public static final DSSBufferPublicKeyParser INSTANCE = new DSSBufferPublicKeyParser();

    public DSSBufferPublicKeyParser() {
        super(DSAPublicKey.class, "ssh-dss");
    }

    @Override
    public DSAPublicKey getRawPublicKey(String string, Buffer buffer) {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(string), "Unsupported key type: %s", (Object)string);
        BigInteger bigInteger = buffer.getMPInt();
        BigInteger bigInteger2 = buffer.getMPInt();
        BigInteger bigInteger3 = buffer.getMPInt();
        BigInteger bigInteger4 = buffer.getMPInt();
        return (DSAPublicKey)this.generatePublicKey("DSA", new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3));
    }
}

