/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser$1;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser$2;
import org.apache.sshd.common.util.buffer.keys.DSSBufferPublicKeyParser;
import org.apache.sshd.common.util.buffer.keys.ECBufferPublicKeyParser;
import org.apache.sshd.common.util.buffer.keys.ED25519BufferPublicKeyParser;
import org.apache.sshd.common.util.buffer.keys.OpenSSHCertPublicKeyParser;
import org.apache.sshd.common.util.buffer.keys.RSABufferPublicKeyParser;
import org.apache.sshd.common.util.buffer.keys.SkECBufferPublicKeyParser;
import org.apache.sshd.common.util.buffer.keys.SkED25519BufferPublicKeyParser;

public interface BufferPublicKeyParser {
    public static final BufferPublicKeyParser EMPTY = new BufferPublicKeyParser$1();
    public static final BufferPublicKeyParser DEFAULT = BufferPublicKeyParser.aggregate(Arrays.asList(RSABufferPublicKeyParser.INSTANCE, DSSBufferPublicKeyParser.INSTANCE, ECBufferPublicKeyParser.INSTANCE, SkECBufferPublicKeyParser.INSTANCE, ED25519BufferPublicKeyParser.INSTANCE, OpenSSHCertPublicKeyParser.INSTANCE, SkED25519BufferPublicKeyParser.INSTANCE));

    public boolean isKeyTypeSupported(String var1);

    public PublicKey getRawPublicKey(String var1, Buffer var2);

    public static BufferPublicKeyParser aggregate(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return EMPTY;
        }
        return new BufferPublicKeyParser$2(collection);
    }
}

