/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractBufferPublicKeyParser
implements BufferPublicKeyParser {
    private final Class keyClass;
    private final Collection supported;

    protected AbstractBufferPublicKeyParser(Class clazz, String ... stringArray) {
        this(clazz, GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    protected AbstractBufferPublicKeyParser(Class clazz, Collection collection) {
        this.keyClass = Objects.requireNonNull(clazz, "No key class");
        this.supported = ValidateUtils.checkNotNullAndNotEmpty(collection, "No supported types for %s", clazz.getSimpleName());
    }

    public Collection getSupportedKeyTypes() {
        return this.supported;
    }

    public final Class getKeyClass() {
        return this.keyClass;
    }

    @Override
    public boolean isKeyTypeSupported(String string) {
        Collection collection = this.getSupportedKeyTypes();
        return GenericUtils.length(string) > 0 && GenericUtils.size(collection) > 0 && collection.contains(string);
    }

    protected PublicKey generatePublicKey(String string, KeySpec keySpec) {
        KeyFactory keyFactory = this.getKeyFactory(string);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        Class clazz = this.getKeyClass();
        if (!clazz.isInstance(publicKey)) {
            throw new InvalidKeySpecException("Mismatched generated key types: expected=" + clazz.getSimpleName() + ", actual=" + publicKey);
        }
        return (PublicKey)clazz.cast(publicKey);
    }

    protected KeyFactory getKeyFactory(String string) {
        return SecurityUtils.getKeyFactory(string);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - supported=" + this.getSupportedKeyTypes();
    }
}

