/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class ByteArrayBuffer
extends Buffer {
    public static final int DEFAULT_SIZE = 256;
    private byte[] data;
    private int rpos;
    private int wpos;

    public ByteArrayBuffer() {
        this(256, false);
    }

    public ByteArrayBuffer(int n2) {
        this(n2, true);
    }

    public ByteArrayBuffer(int n2, boolean bl2) {
        this(new byte[bl2 ? BufferUtils.getNextPowerOf2(n2) : n2], false);
    }

    public ByteArrayBuffer(byte[] byArray) {
        this(byArray, 0, byArray.length, true);
    }

    public ByteArrayBuffer(byte[] byArray, boolean bl2) {
        this(byArray, 0, byArray.length, bl2);
    }

    public ByteArrayBuffer(byte[] byArray, int n2, int n3) {
        this(byArray, n2, n3, true);
    }

    public ByteArrayBuffer(byte[] byArray, int n2, int n3, boolean bl2) {
        if (n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException("Invalid offset(" + n2 + ")/length(" + n3 + ")");
        }
        this.data = byArray;
        this.rpos = n2;
        this.wpos = (bl2 ? n3 : 0) + n2;
    }

    @Override
    public int rpos() {
        return this.rpos;
    }

    @Override
    public void rpos(int n2) {
        this.rpos = n2;
    }

    @Override
    public int wpos() {
        return this.wpos;
    }

    @Override
    public void wpos(int n2) {
        if (n2 > this.wpos) {
            this.ensureCapacity(n2 - this.wpos);
        }
        this.wpos = n2;
    }

    @Override
    public int available() {
        return this.wpos - this.rpos;
    }

    @Override
    public int capacity() {
        return this.data.length - this.wpos;
    }

    @Override
    public byte[] array() {
        return this.data;
    }

    @Override
    public byte[] getBytesConsumed() {
        byte[] byArray = new byte[this.rpos];
        System.arraycopy(this.data, 0, byArray, 0, this.rpos);
        return byArray;
    }

    @Override
    public byte rawByte(int n2) {
        return this.data[n2];
    }

    @Override
    public long rawUInt(int n2) {
        return BufferUtils.getUInt(this.data, n2, 4);
    }

    @Override
    public void compact() {
        int n2 = this.available();
        if (n2 > 0) {
            System.arraycopy(this.data, this.rpos, this.data, 0, n2);
        }
        this.wpos -= this.rpos;
        this.rpos = 0;
    }

    @Override
    public Buffer clear(boolean bl2) {
        this.rpos = 0;
        this.wpos = 0;
        if (bl2) {
            Arrays.fill(this.data, (byte)0);
        }
        return this;
    }

    @Override
    public byte getByte() {
        this.ensureAvailable(1);
        return this.data[this.rpos++];
    }

    @Override
    public void putByte(byte by) {
        this.ensureCapacity(1);
        this.data[this.wpos++] = by;
    }

    @Override
    public int putBuffer(Readable readable, boolean bl2) {
        int n2 = bl2 ? readable.available() : Math.min(readable.available(), this.capacity());
        this.ensureCapacity(n2);
        readable.getRawBytes(this.data, this.wpos, n2);
        this.wpos += n2;
        return n2;
    }

    @Override
    public void putBuffer(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.ensureCapacity(n2 + 32);
        this.putUInt(n2);
        byteBuffer.get(this.data, this.wpos, n2);
        this.wpos += n2;
    }

    @Override
    public void putRawBytes(byte[] byArray, int n2, int n3) {
        ValidateUtils.checkTrue(n3 >= 0, "Negative raw bytes length: %d", n3);
        this.ensureCapacity(n3);
        System.arraycopy(byArray, n2, this.data, this.wpos, n3);
        this.wpos += n3;
    }

    @Override
    public String getString(Charset charset) {
        Objects.requireNonNull(charset, "No charset specified");
        int n2 = this.getInt();
        int n3 = this.ensureAvailable(n2);
        String string = new String(this.data, this.rpos, n3, charset);
        this.rpos += n3;
        return string;
    }

    @Override
    public void getRawBytes(byte[] byArray, int n2, int n3) {
        this.ensureAvailable(n3);
        this.copyRawBytes(0, byArray, n2, n3);
        this.rpos += n3;
    }

    @Override
    protected void copyRawBytes(int n2, byte[] byArray, int n3, int n4) {
        if (n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IndexOutOfBoundsException("Invalid offset(" + n2 + ")/position(" + n3 + ")/length(" + n4 + ") required");
        }
        System.arraycopy(this.data, this.rpos + n2, byArray, n3, n4);
    }

    @Override
    public Buffer ensureCapacity(int n2, IntUnaryOperator intUnaryOperator) {
        ValidateUtils.checkTrue(n2 >= 0, "Negative capacity requested: %d", n2);
        int n3 = this.size();
        int n4 = this.wpos();
        int n5 = n3 - n4;
        if (n5 < n2) {
            int n6 = n4 + n2;
            int n7 = intUnaryOperator.applyAsInt(n6);
            if (n7 < n6) {
                throw new IllegalStateException("ensureCapacity(" + n2 + ") actual (" + n7 + ") below min. (" + n6 + ")");
            }
            byte[] byArray = new byte[n7];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            this.data = byArray;
        }
        return this;
    }

    @Override
    protected int size() {
        return this.data.length;
    }

    public static ByteArrayBuffer getCompactClone(byte[] byArray) {
        return ByteArrayBuffer.getCompactClone(byArray, 0, NumberUtils.length(byArray));
    }

    public static ByteArrayBuffer getCompactClone(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        byte[] byArray3 = byArray2 = n3 > 0 ? new byte[n3] : GenericUtils.EMPTY_BYTE_ARRAY;
        if (n3 > 0) {
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        }
        return new ByteArrayBuffer(byArray2, true);
    }
}

