/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.function.IntUnaryOperator;
import java.util.logging.Level;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;

public final class BufferUtils {
    public static final char DEFAULT_HEX_SEPARATOR = ' ';
    public static final char EMPTY_HEX_SEPARATOR = '\u0000';
    public static final String HEX_DIGITS = "0123456789abcdef";
    public static final Level DEFAULT_HEXDUMP_LEVEL = Level.FINEST;
    public static final IntUnaryOperator DEFAULT_BUFFER_GROWTH_FACTOR = BufferUtils::getNextPowerOf2;
    public static final long MAX_UINT32_VALUE = 0xFFFFFFFFL;
    public static final int MAX_UINT8_VALUE = 255;

    private BufferUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static int indexOf(byte[] byArray, byte by, int n2, int n3) {
        if (byArray == null) {
            return -1;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (by == byArray[n4]) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public static void dumpHex(SimplifiedLog simplifiedLog, Level level, String string, PropertyResolver propertyResolver, char c2, byte ... byArray) {
        BufferUtils.dumpHex(simplifiedLog, level, string, propertyResolver, c2, byArray, 0, NumberUtils.length(byArray));
    }

    public static void dumpHex(SimplifiedLog simplifiedLog, Level level, String string, PropertyResolver propertyResolver, char c2, byte[] byArray, int n2, int n3) {
        BufferUtils.dumpHex(simplifiedLog, level, string, c2, (int)((Integer)CommonModuleProperties.HEXDUMP_CHUNK_SIZE.getRequired(propertyResolver)), byArray, n2, n3);
    }

    public static void dumpHex(SimplifiedLog simplifiedLog, Level level, String string, char c2, int n2, byte ... byArray) {
        BufferUtils.dumpHex(simplifiedLog, level, string, c2, n2, byArray, 0, NumberUtils.length(byArray));
    }

    public static void dumpHex(SimplifiedLog simplifiedLog, Level level, String string, char c2, int n2, byte[] byArray, int n3, int n4) {
        if (simplifiedLog == null || level == null || !simplifiedLog.isEnabledLevel(level)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 * 3 + string.length() + 64);
        stringBuilder.append(string);
        int n5 = n4;
        int n6 = 1;
        int n7 = n3;
        int n8 = 0;
        while (n5 > 0) {
            int n9;
            stringBuilder.setLength(string.length());
            stringBuilder.append(" [chunk #").append(n6).append(']');
            int n10 = Math.min(n2, n5);
            stringBuilder.append('(').append(n8 += n10).append('/').append(n4).append(')');
            try {
                BufferUtils.appendHex((Appendable)stringBuilder.append(' '), byArray, n7, n10, c2);
            }
            catch (IOException iOException) {
                stringBuilder.append(iOException.getClass().getSimpleName()).append(": ").append(iOException.getMessage());
            }
            for (n9 = n10; n9 < n2; ++n9) {
                if (c2 != '\u0000') {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("  ");
            }
            stringBuilder.append("    ");
            n9 = n7;
            for (int i2 = 0; i2 < n10; ++i2) {
                int n11 = byArray[n9] & 0xFF;
                if (n11 > 32 && n11 < 126) {
                    stringBuilder.append((char)n11);
                } else {
                    stringBuilder.append('.');
                }
                ++n9;
            }
            simplifiedLog.log(level, stringBuilder.toString());
            n5 -= n10;
            n7 += n10;
            ++n6;
        }
    }

    public static String toHex(byte ... byArray) {
        return BufferUtils.toHex(byArray, 0, NumberUtils.length(byArray));
    }

    public static String toHex(char c2, byte ... byArray) {
        return BufferUtils.toHex(byArray, 0, NumberUtils.length(byArray), c2);
    }

    public static String toHex(byte[] byArray, int n2, int n3) {
        return BufferUtils.toHex(byArray, n2, n3, ' ');
    }

    public static String toHex(byte[] byArray, int n2, int n3, char c2) {
        if (n3 <= 0) {
            return "";
        }
        try {
            return ((StringBuilder)BufferUtils.appendHex((Appendable)new StringBuilder(n3 * 3), byArray, n2, n3, c2)).toString();
        }
        catch (IOException iOException) {
            return iOException.getClass().getSimpleName() + ": " + iOException.getMessage();
        }
    }

    public static Appendable appendHex(Appendable appendable, char c2, byte ... byArray) {
        return BufferUtils.appendHex(appendable, byArray, 0, NumberUtils.length(byArray), c2);
    }

    public static Appendable appendHex(Appendable appendable, byte[] byArray, int n2, int n3, char c2) {
        if (n3 <= 0) {
            return appendable;
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            byte by = byArray[i2];
            if (i2 > n2 && c2 != '\u0000') {
                appendable.append(c2);
            }
            appendable.append(HEX_DIGITS.charAt(by >> 4 & 0xF));
            appendable.append(HEX_DIGITS.charAt(by & 0xF));
        }
        return appendable;
    }

    public static byte[] decodeHex(char c2, CharSequence charSequence) {
        return BufferUtils.decodeHex(c2, charSequence, 0, GenericUtils.length(charSequence));
    }

    public static byte[] decodeHex(char c2, CharSequence charSequence, int n2, int n3) {
        byte[] byArray;
        int n4 = n3 - n2;
        ValidateUtils.checkTrue(n4 >= 0, "Bad HEX sequence length: %d", n4);
        if (n4 == 0) {
            return GenericUtils.EMPTY_BYTE_ARRAY;
        }
        int n5 = 2;
        if (c2 != '\u0000') {
            ValidateUtils.checkTrue(n4 % 3 == 2, "Invalid separated HEX sequence length: %d", n4);
            byArray = new byte[(n4 + 1) / 3];
            ++n5;
        } else {
            ValidateUtils.checkTrue((n4 & 1) == 0, "Invalid contiguous HEX sequence length: %d", n4);
            byArray = new byte[n4 >>> 1];
        }
        int n6 = 0;
        int n7 = n2;
        while (n7 < n3) {
            byArray[n6] = BufferUtils.fromHex(charSequence.charAt(n7), charSequence.charAt(n7 + 1));
            n7 += n5;
            ++n6;
        }
        assert (n6 == byArray.length);
        return byArray;
    }

    public static int decodeHex(OutputStream outputStream, char c2, CharSequence charSequence) {
        return BufferUtils.decodeHex(outputStream, c2, charSequence, 0, GenericUtils.length(charSequence));
    }

    public static int decodeHex(OutputStream outputStream, char c2, CharSequence charSequence, int n2, int n3) {
        int n4 = n3 - n2;
        ValidateUtils.checkTrue(n4 >= 0, "Bad HEX sequence length: %d", n4);
        int n5 = 2;
        if (c2 != '\u0000') {
            ValidateUtils.checkTrue(n4 % 3 == 2, "Invalid separated HEX sequence length: %d", n4);
            ++n5;
        } else {
            ValidateUtils.checkTrue((n4 & 1) == 0, "Invalid contiguous HEX sequence length: %d", n4);
        }
        int n6 = 0;
        int n7 = n2;
        while (n7 < n3) {
            outputStream.write(BufferUtils.fromHex(charSequence.charAt(n7), charSequence.charAt(n7 + 1)) & 0xFF);
            n7 += n5;
            ++n6;
        }
        return n6;
    }

    public static byte fromHex(char n2, char n3) {
        int n4 = HEX_DIGITS.indexOf(n2 >= 65 && n2 <= 70 ? 97 + (n2 - 65) : n2);
        int n5 = HEX_DIGITS.indexOf(n3 >= 65 && n3 <= 70 ? 97 + (n3 - 65) : n3);
        if (n4 < 0 || n5 < 0) {
            throw new NumberFormatException("fromHex(" + new String(new char[]{n2, n3}) + ") non-HEX characters");
        }
        return (byte)((n4 << 4) + n5);
    }

    public static int readInt(InputStream inputStream, byte[] byArray) {
        return BufferUtils.readInt(inputStream, byArray, 0, NumberUtils.length(byArray));
    }

    public static int readInt(InputStream inputStream, byte[] byArray, int n2, int n3) {
        return (int)BufferUtils.readUInt(inputStream, byArray, n2, n3);
    }

    public static long readUInt(InputStream inputStream, byte[] byArray) {
        return BufferUtils.readUInt(inputStream, byArray, 0, NumberUtils.length(byArray));
    }

    public static long readUInt(InputStream inputStream, byte[] byArray, int n2, int n3) {
        try {
            if (n3 < 4) {
                throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + n3);
            }
            IoUtils.readFully(inputStream, byArray, n2, 4);
            return BufferUtils.getUInt(byArray, n2, n3);
        }
        catch (Error | RuntimeException throwable) {
            throw new StreamCorruptedException("Failed (" + throwable.getClass().getSimpleName() + ") to read UINT value: " + throwable.getMessage());
        }
    }

    public static long getUInt(byte ... byArray) {
        return BufferUtils.getUInt(byArray, 0, NumberUtils.length(byArray));
    }

    public static long getUInt(byte[] byArray, int n2, int n3) {
        if (n3 < 4) {
            throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + n3);
        }
        long l2 = (long)(byArray[n2] << 24) & 0xFF000000L;
        l2 |= (long)(byArray[n2 + 1] << 16) & 0xFF0000L;
        l2 |= (long)(byArray[n2 + 2] << 8) & 0xFF00L;
        return l2 |= (long)byArray[n2 + 3] & 0xFFL;
    }

    public static long getLong(byte[] byArray, int n2, int n3) {
        if (n3 < 8) {
            throw new IllegalArgumentException("Not enough data for a long: required=8, available=" + n3);
        }
        long l2 = (long)byArray[n2] << 56;
        l2 |= ((long)byArray[n2 + 1] & 0xFFL) << 48;
        l2 |= ((long)byArray[n2 + 2] & 0xFFL) << 40;
        l2 |= ((long)byArray[n2 + 3] & 0xFFL) << 32;
        l2 |= ((long)byArray[n2 + 4] & 0xFFL) << 24;
        l2 |= ((long)byArray[n2 + 5] & 0xFFL) << 16;
        l2 |= ((long)byArray[n2 + 6] & 0xFFL) << 8;
        return l2 |= (long)byArray[n2 + 7] & 0xFFL;
    }

    public static BigInteger fromMPIntBytes(byte[] byArray) {
        if (NumberUtils.isEmpty(byArray)) {
            return null;
        }
        if ((byArray[0] & 0x80) != 0) {
            return new BigInteger(1, byArray);
        }
        return new BigInteger(byArray);
    }

    public static void writeInt(OutputStream outputStream, int n2, byte[] byArray) {
        BufferUtils.writeUInt(outputStream, n2, byArray, 0, NumberUtils.length(byArray));
    }

    public static void writeInt(OutputStream outputStream, int n2, byte[] byArray, int n3, int n4) {
        BufferUtils.writeUInt(outputStream, (long)n2 & 0xFFFFFFFFL, byArray, n3, n4);
    }

    public static void writeUInt(OutputStream outputStream, long l2, byte[] byArray) {
        BufferUtils.writeUInt(outputStream, l2, byArray, 0, NumberUtils.length(byArray));
    }

    public static void writeUInt(OutputStream outputStream, long l2, byte[] byArray, int n2, int n3) {
        try {
            int n4 = BufferUtils.putUInt(l2, byArray, n2, n3);
            outputStream.write(byArray, n2, n4);
        }
        catch (Error | RuntimeException throwable) {
            throw new StreamCorruptedException("Failed (" + throwable.getClass().getSimpleName() + ") to write UINT value=" + l2 + ": " + throwable.getMessage());
        }
    }

    public static int putUInt(long l2, byte[] byArray) {
        return BufferUtils.putUInt(l2, byArray, 0, NumberUtils.length(byArray));
    }

    public static int putUInt(long l2, byte[] byArray, int n2, int n3) {
        if (n3 < 4) {
            throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + n3);
        }
        byArray[n2] = (byte)(l2 >> 24 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 & 0xFFL);
        return 4;
    }

    public static int putLong(long l2, byte[] byArray, int n2, int n3) {
        if (n3 < 8) {
            throw new IllegalArgumentException("Not enough data for a long: required=8, available=" + n3);
        }
        byArray[n2] = (byte)(l2 >> 56);
        byArray[n2 + 1] = (byte)(l2 >> 48);
        byArray[n2 + 2] = (byte)(l2 >> 40);
        byArray[n2 + 3] = (byte)(l2 >> 32);
        byArray[n2 + 4] = (byte)(l2 >> 24);
        byArray[n2 + 5] = (byte)(l2 >> 16);
        byArray[n2 + 6] = (byte)(l2 >> 8);
        byArray[n2 + 7] = (byte)l2;
        return 8;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        int n2;
        int n3 = NumberUtils.length(byArray);
        if (n3 != (n2 = NumberUtils.length(byArray2))) {
            return false;
        }
        return BufferUtils.equals(byArray, 0, byArray2, 0, n3);
    }

    public static boolean equals(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = NumberUtils.length(byArray);
        int n6 = NumberUtils.length(byArray2);
        if (n5 < n2 + n4 || n6 < n3 + n4) {
            return false;
        }
        while (n4-- > 0) {
            if (byArray[n2++] == byArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public static int getNextPowerOf2(int n2) {
        return n2 < 8 ? 8 : (n2 > 0x40000000 ? n2 : NumberUtils.getNextPowerOf2(n2));
    }

    public static int updateLengthPlaceholder(Buffer buffer, int n2) {
        int n3 = n2 + 4;
        int n4 = buffer.wpos();
        int n5 = n4 - n3;
        ValidateUtils.checkTrue(n5 >= 0, "Illegal data length: %d", n5);
        buffer.wpos(n2);
        buffer.putUInt(n5);
        buffer.wpos(n4);
        return n5;
    }

    public static void updateLengthPlaceholder(Buffer buffer, int n2, long l2) {
        int n3 = buffer.wpos();
        buffer.wpos(n2);
        buffer.putUInt(l2);
        buffer.wpos(n3);
    }

    public static Buffer clear(Buffer buffer) {
        if (buffer != null) {
            buffer.clear();
        }
        return buffer;
    }

    public static long validateInt32Value(long l2, String string) {
        ValidateUtils.checkTrue(BufferUtils.isValidInt32Value(l2), string, l2);
        return l2;
    }

    public static long validateInt32Value(long l2, String string, Object object) {
        ValidateUtils.checkTrue(BufferUtils.isValidInt32Value(l2), string, object);
        return l2;
    }

    public static long validateInt32Value(long l2, String string, Object ... objectArray) {
        ValidateUtils.checkTrue(BufferUtils.isValidInt32Value(l2), string, objectArray);
        return l2;
    }

    public static boolean isValidInt32Value(long l2) {
        return l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE;
    }

    public static long validateUint32Value(long l2, String string) {
        ValidateUtils.checkTrue(BufferUtils.isValidUint32Value(l2), string, l2);
        return l2;
    }

    public static long validateUint32Value(long l2, String string, Object object) {
        ValidateUtils.checkTrue(BufferUtils.isValidUint32Value(l2), string, object);
        return l2;
    }

    public static long validateUint32Value(long l2, String string, Object ... objectArray) {
        ValidateUtils.checkTrue(BufferUtils.isValidUint32Value(l2), string, objectArray);
        return l2;
    }

    public static boolean isValidUint32Value(long l2) {
        return l2 >= 0L && l2 <= 0xFFFFFFFFL;
    }
}

