/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import java.util.logging.Level;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificate$CertificateOption;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.BufferException;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class Buffer
implements Readable {
    protected final byte[] workBuf = new byte[8];

    protected Buffer() {
    }

    public abstract int rpos();

    public abstract void rpos(int var1);

    public abstract int wpos();

    public abstract void wpos(int var1);

    public abstract int capacity();

    public abstract byte[] array();

    public abstract byte[] getBytesConsumed();

    public byte rawByte(int n2) {
        byte[] byArray = this.array();
        return byArray[n2];
    }

    public long rawUInt(int n2) {
        byte[] byArray = this.array();
        return BufferUtils.getUInt(byArray, n2, 4);
    }

    public abstract void compact();

    public byte[] getCompactData() {
        int n2 = this.available();
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.array(), this.rpos(), byArray, 0, n2);
            return byArray;
        }
        return GenericUtils.EMPTY_BYTE_ARRAY;
    }

    public Buffer clear() {
        return this.clear(true);
    }

    public abstract Buffer clear(boolean var1);

    public boolean isValidMessageStructure(Class ... classArray) {
        return this.isValidMessageStructure(GenericUtils.isEmpty(classArray) ? Collections.emptyList() : Arrays.asList(classArray));
    }

    public boolean isValidMessageStructure(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return true;
        }
        int n2 = this.available();
        int n3 = 0;
        for (Class clazz : collection) {
            if (clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class) {
                if (n2 < 1) {
                    return false;
                }
                --n2;
                ++n3;
                continue;
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                if (n2 < 2) {
                    return false;
                }
                n2 -= 2;
                n3 += 2;
                continue;
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                if (n2 < 4) {
                    return false;
                }
                n2 -= 4;
                n3 += 4;
                continue;
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                if (n2 < 8) {
                    return false;
                }
                n2 -= 8;
                n3 += 8;
                continue;
            }
            if (clazz != byte[].class && clazz != String.class) continue;
            if (n2 < 4) {
                return false;
            }
            this.copyRawBytes(n3, this.workBuf, 0, 4);
            n3 += 4;
            long l2 = BufferUtils.getUInt(this.workBuf, 0, 4);
            if (l2 > (long)(n2 -= 4)) {
                return false;
            }
            n2 -= (int)l2;
            n3 += (int)l2;
        }
        return true;
    }

    protected abstract void copyRawBytes(int var1, byte[] var2, int var3, int var4);

    public String toHex() {
        return BufferUtils.toHex(this.array(), this.rpos(), this.available());
    }

    public void dumpHex(SimplifiedLog simplifiedLog, String string, PropertyResolver propertyResolver) {
        this.dumpHex(simplifiedLog, BufferUtils.DEFAULT_HEXDUMP_LEVEL, string, propertyResolver);
    }

    public void dumpHex(SimplifiedLog simplifiedLog, Level level, String string, PropertyResolver propertyResolver) {
        int n2;
        byte[] byArray = this.array();
        int n3 = this.rpos();
        int n4 = this.available();
        if (n4 > 0 && Buffer.isSensitiveData(n2 = byArray[n3] & 0xFF)) {
            return;
        }
        BufferUtils.dumpHex(simplifiedLog, level, string, propertyResolver, ' ', byArray, n3, n4);
    }

    private static boolean isSensitiveData(int n2) {
        switch (n2) {
            case 50: 
            case 61: {
                return true;
            }
        }
        return false;
    }

    public int getUByte() {
        return this.getByte() & 0xFF;
    }

    public byte getByte() {
        this.ensureAvailable(1);
        this.getRawBytes(this.workBuf, 0, 1);
        return this.workBuf[0];
    }

    public short getShort() {
        this.ensureAvailable(2);
        this.getRawBytes(this.workBuf, 0, 2);
        short s2 = (short)(this.workBuf[0] << 8 & 0xFF00);
        s2 = (short)(s2 | (short)(this.workBuf[1] & 0xFF));
        return s2;
    }

    public int getUShort() {
        return this.getShort() & 0xFFFF;
    }

    public int getInt() {
        return (int)this.getUInt();
    }

    public long getUInt() {
        this.ensureAvailable(4);
        this.getRawBytes(this.workBuf, 0, 4);
        return BufferUtils.getUInt(this.workBuf, 0, 4);
    }

    public long getLong() {
        this.ensureAvailable(8);
        this.getRawBytes(this.workBuf, 0, 8);
        long l2 = (long)this.workBuf[0] << 56 & 0xFF00000000000000L;
        l2 |= (long)this.workBuf[1] << 48 & 0xFF000000000000L;
        l2 |= (long)this.workBuf[2] << 40 & 0xFF0000000000L;
        l2 |= (long)this.workBuf[3] << 32 & 0xFF00000000L;
        l2 |= (long)this.workBuf[4] << 24 & 0xFF000000L;
        l2 |= (long)this.workBuf[5] << 16 & 0xFF0000L;
        l2 |= (long)this.workBuf[6] << 8 & 0xFF00L;
        return l2 |= (long)this.workBuf[7] & 0xFFL;
    }

    public boolean getBoolean() {
        return this.getByte() != 0;
    }

    public String getString() {
        return this.getString(StandardCharsets.UTF_8);
    }

    public List getNameList() {
        return this.getNameList(StandardCharsets.UTF_8);
    }

    public List getNameList(Charset charset) {
        return this.getNameList(charset, ',');
    }

    public List getNameList(char c2) {
        return this.getNameList(StandardCharsets.UTF_8, c2);
    }

    public List getNameList(Charset charset, char c2) {
        String string = this.getString(charset);
        Object[] objectArray = GenericUtils.split(string, c2);
        return GenericUtils.isEmpty(objectArray) ? Collections.emptyList() : Arrays.asList(objectArray);
    }

    public List getCertificateOptions() {
        return this.getCertificateOptions(StandardCharsets.UTF_8);
    }

    public List getCertificateOptions(Charset charset) {
        ArrayList<OpenSshCertificate$CertificateOption> arrayList = new ArrayList<OpenSshCertificate$CertificateOption>();
        if (this.available() > 0) {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(this.getBytes());
            while (byteArrayBuffer.available() > 0) {
                String string = ((Buffer)byteArrayBuffer).getString(charset);
                String string2 = null;
                ByteArrayBuffer byteArrayBuffer2 = new ByteArrayBuffer(byteArrayBuffer.getBytes());
                if (byteArrayBuffer2.available() > 0) {
                    string2 = GenericUtils.trimToEmpty(((Buffer)byteArrayBuffer2).getString(charset));
                    string2 = string2.length() > 0 ? string2 : null;
                }
                arrayList.add(new OpenSshCertificate$CertificateOption(string, string2));
            }
        }
        return arrayList;
    }

    public Collection getStringList(boolean bl2) {
        return this.getStringList(bl2, StandardCharsets.UTF_8);
    }

    public Collection getStringList(boolean bl2, Charset charset) {
        if (bl2) {
            int n2 = this.getInt();
            return this.getStringList(n2, charset);
        }
        return this.getAvailableStrings(charset);
    }

    public Collection getAvailableStrings() {
        return this.getAvailableStrings(StandardCharsets.UTF_8);
    }

    public Collection getAvailableStrings(Charset charset) {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (this.available() > 0) {
            String string = this.getString(charset);
            linkedList.add(string);
        }
        return linkedList;
    }

    public List getStringList(int n2) {
        return this.getStringList(n2, StandardCharsets.UTF_8);
    }

    public List getStringList(int n2, Charset charset) {
        if (n2 < 0 || n2 > 32768) {
            throw new IndexOutOfBoundsException("Illogical string list length: " + n2);
        }
        if (n2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 1; i2 <= n2; ++i2) {
            String string = this.getString(charset);
            arrayList.add(string);
        }
        return arrayList;
    }

    public abstract String getString(Charset var1);

    public BigInteger getMPInt() {
        return new BigInteger(this.getMPIntAsBytes());
    }

    public byte[] getMPIntAsBytes() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        int n2 = this.getInt();
        int n3 = this.ensureAvailable(n2);
        byte[] byArray = new byte[n3];
        this.getRawBytes(byArray);
        return byArray;
    }

    public void getRawBytes(byte[] byArray) {
        this.getRawBytes(byArray, 0, byArray.length);
    }

    public PublicKey getPublicKey() {
        return this.getPublicKey(BufferPublicKeyParser.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey getPublicKey(BufferPublicKeyParser bufferPublicKeyParser) {
        int n2 = this.wpos();
        int n3 = this.ensureAvailable(this.getInt());
        int n4 = this.rpos() + n3;
        this.wpos(n4);
        try {
            PublicKey publicKey = this.getRawPublicKey(bufferPublicKeyParser);
            return publicKey;
        }
        finally {
            this.wpos(n2);
            this.rpos(n4);
        }
    }

    public PublicKey getRawPublicKey() {
        return this.getRawPublicKey(BufferPublicKeyParser.DEFAULT);
    }

    public PublicKey getRawPublicKey(BufferPublicKeyParser bufferPublicKeyParser) {
        Objects.requireNonNull(bufferPublicKeyParser, "No key data parser");
        try {
            String string = this.getString();
            if (!bufferPublicKeyParser.isKeyTypeSupported(string)) {
                throw new NoSuchAlgorithmException("Key type=" + string + ") not supported by parser=" + bufferPublicKeyParser);
            }
            return bufferPublicKeyParser.getRawPublicKey(string, this);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SshException(generalSecurityException);
        }
    }

    public KeyPair getKeyPair() {
        try {
            PrivateKey privateKey;
            PublicKey publicKey;
            String string = this.getString();
            if ("ssh-rsa".equals(string)) {
                BigInteger bigInteger = this.getMPInt();
                BigInteger bigInteger2 = this.getMPInt();
                BigInteger bigInteger3 = this.getMPInt();
                BigInteger bigInteger4 = this.getMPInt();
                BigInteger bigInteger5 = this.getMPInt();
                BigInteger bigInteger6 = this.getMPInt();
                BigInteger bigInteger7 = bigInteger3.remainder(bigInteger6.subtract(BigInteger.valueOf(1L)));
                BigInteger bigInteger8 = bigInteger3.remainder(bigInteger5.subtract(BigInteger.valueOf(1L)));
                KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
                publicKey = keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger2, bigInteger));
                privateKey = keyFactory.generatePrivate(new RSAPrivateCrtKeySpec(bigInteger2, bigInteger, bigInteger3, bigInteger6, bigInteger5, bigInteger7, bigInteger8, bigInteger4));
            } else if ("ssh-dss".equals(string)) {
                BigInteger bigInteger = this.getMPInt();
                BigInteger bigInteger9 = this.getMPInt();
                BigInteger bigInteger10 = this.getMPInt();
                BigInteger bigInteger11 = this.getMPInt();
                BigInteger bigInteger12 = this.getMPInt();
                KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
                publicKey = keyFactory.generatePublic(new DSAPublicKeySpec(bigInteger11, bigInteger, bigInteger9, bigInteger10));
                privateKey = keyFactory.generatePrivate(new DSAPrivateKeySpec(bigInteger12, bigInteger, bigInteger9, bigInteger10));
            } else {
                if ("ssh-ed25519".equals(string)) {
                    return SecurityUtils.extractEDDSAKeyPair(this, string);
                }
                ECCurves eCCurves = ECCurves.fromKeyType(string);
                if (eCCurves == null) {
                    throw new NoSuchAlgorithmException("Unsupported key pair algorithm: " + string);
                }
                String string2 = eCCurves.getName();
                ECParameterSpec eCParameterSpec = eCCurves.getParameters();
                return this.extractEC(string2, eCParameterSpec);
            }
            return new KeyPair(publicKey, privateKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SshException(generalSecurityException);
        }
    }

    protected KeyPair extractEC(String string, ECParameterSpec eCParameterSpec) {
        ECPoint eCPoint;
        String string2 = this.getString();
        if (!string.equals(string2)) {
            throw new InvalidKeySpecException("extractEC(" + string + ") mismatched curve name: " + string2);
        }
        byte[] byArray = this.getBytes();
        BigInteger bigInteger = this.getMPInt();
        if (eCParameterSpec == null) {
            throw new InvalidKeySpecException("extractEC(" + string + ") missing parameters for curve");
        }
        try {
            eCPoint = ECCurves.octetStringToEcPoint(byArray);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidKeySpecException("extractEC(" + string + ") failed (" + runtimeException.getClass().getSimpleName() + ") to decode EC group for curve: " + runtimeException.getMessage(), runtimeException);
        }
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EC");
        PublicKey publicKey = keyFactory.generatePublic(new ECPublicKeySpec(eCPoint, eCParameterSpec));
        PrivateKey privateKey = keyFactory.generatePrivate(new ECPrivateKeySpec(bigInteger, eCParameterSpec));
        return new KeyPair(publicKey, privateKey);
    }

    public int ensureAvailable(int n2) {
        if (n2 < 0) {
            throw new BufferException("Bad item length: " + n2);
        }
        int n3 = this.available();
        if (n3 < n2) {
            throw new BufferException("Underflow: requested=" + n2 + ", available=" + n3);
        }
        return n2;
    }

    public void putByte(byte by) {
        this.ensureCapacity(1);
        this.workBuf[0] = by;
        this.putRawBytes(this.workBuf, 0, 1);
    }

    public void putOptionalBufferedData(Object object) {
        if (object == null) {
            this.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
        } else {
            this.putBufferedData(object);
        }
    }

    public void putBufferedData(Object object) {
        Objects.requireNonNull(object, "No buffered data to encode");
        if (object instanceof byte[]) {
            this.putBytes((byte[])object);
        } else if (object instanceof Readable) {
            this.putBuffer((Readable)object);
        } else if (object instanceof ByteBuffer) {
            this.putBuffer((ByteBuffer)object);
        } else {
            throw new IllegalArgumentException("No buffered overload found for " + (object == null ? null : object.getClass().getName()));
        }
    }

    public void putBuffer(Readable readable) {
        this.putBuffer(readable, true);
    }

    public abstract int putBuffer(Readable var1, boolean var2);

    public abstract void putBuffer(ByteBuffer var1);

    public void putShort(int n2) {
        this.ensureCapacity(2);
        this.workBuf[0] = (byte)(n2 >> 8);
        this.workBuf[1] = (byte)n2;
        this.putRawBytes(this.workBuf, 0, 2);
    }

    public void putInt(long l2) {
        BufferUtils.validateInt32Value(l2, "Invalid INT32 value: %d");
        this.ensureCapacity(4);
        BufferUtils.putUInt(l2, this.workBuf, 0, 4);
        this.putRawBytes(this.workBuf, 0, 4);
    }

    public void putUInt(long l2) {
        BufferUtils.validateUint32Value(l2, "Invalid UINT32 value: %d");
        this.ensureCapacity(4);
        BufferUtils.putUInt(l2, this.workBuf, 0, 4);
        this.putRawBytes(this.workBuf, 0, 4);
    }

    public void putLong(long l2) {
        this.ensureCapacity(8);
        this.workBuf[0] = (byte)(l2 >> 56);
        this.workBuf[1] = (byte)(l2 >> 48);
        this.workBuf[2] = (byte)(l2 >> 40);
        this.workBuf[3] = (byte)(l2 >> 32);
        this.workBuf[4] = (byte)(l2 >> 24);
        this.workBuf[5] = (byte)(l2 >> 16);
        this.workBuf[6] = (byte)(l2 >> 8);
        this.workBuf[7] = (byte)l2;
        this.putRawBytes(this.workBuf, 0, 8);
    }

    public void putBoolean(boolean bl2) {
        this.putByte(bl2 ? (byte)1 : 0);
    }

    public void putAndWipeBytes(byte[] byArray) {
        this.putAndWipeBytes(byArray, 0, NumberUtils.length(byArray));
    }

    public void putAndWipeBytes(byte[] byArray, int n2, int n3) {
        this.putBytes(byArray, n2, n3);
        int n4 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n4] = 0;
            ++n4;
        }
    }

    public void putBytes(byte[] byArray) {
        this.putBytes(byArray, 0, NumberUtils.length(byArray));
    }

    public void putBytes(byte[] byArray, int n2, int n3) {
        this.putUInt(n3);
        this.putRawBytes(byArray, n2, n3);
    }

    public void putStringList(Collection collection, boolean bl2) {
        this.putStringList(collection, StandardCharsets.UTF_8, bl2);
    }

    public void putStringList(Collection collection, Charset charset, boolean bl2) {
        int n2 = GenericUtils.size(collection);
        if (bl2) {
            this.putUInt(n2);
        }
        if (n2 <= 0) {
            return;
        }
        for (Object e2 : collection) {
            String string = Objects.toString(e2, null);
            this.putString(string, charset);
        }
    }

    public void putCertificateOptions(List list) {
        this.putCertificateOptions(list, StandardCharsets.UTF_8);
    }

    public void putCertificateOptions(List list, Charset charset) {
        int n2 = GenericUtils.size(list);
        if (n2 <= 0) {
            this.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
            return;
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        for (OpenSshCertificate$CertificateOption openSshCertificate$CertificateOption : list) {
            byteArrayBuffer.putString(openSshCertificate$CertificateOption.getName(), charset);
            if (GenericUtils.isEmpty(openSshCertificate$CertificateOption.getData())) {
                byteArrayBuffer.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
                continue;
            }
            ByteArrayBuffer byteArrayBuffer2 = new ByteArrayBuffer();
            byteArrayBuffer2.putString(openSshCertificate$CertificateOption.getData(), charset);
            byteArrayBuffer.putBytes(byteArrayBuffer2.getCompactData());
        }
        this.putBytes(byteArrayBuffer.getCompactData());
    }

    public void putNameList(Collection collection) {
        this.putNameList(collection, StandardCharsets.UTF_8);
    }

    public void putNameList(Collection collection, Charset charset) {
        this.putNameList(collection, charset, ',');
    }

    public void putNameList(Collection collection, char c2) {
        this.putNameList(collection, StandardCharsets.UTF_8, c2);
    }

    public void putNameList(Collection collection, Charset charset, char c2) {
        String string = GenericUtils.join((Iterable)collection, c2);
        this.putString(string, charset);
    }

    public void putString(String string) {
        this.putString(string, StandardCharsets.UTF_8);
    }

    public void putString(String string, Charset charset) {
        if (GenericUtils.isEmpty(string)) {
            this.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
        } else {
            byte[] byArray = string.getBytes(charset);
            this.putBytes(byArray);
        }
    }

    public void putAndWipeChars(char[] cArray) {
        this.putAndWipeChars(cArray, 0, GenericUtils.length(cArray));
    }

    public void putAndWipeChars(char[] cArray, int n2, int n3) {
        this.putAndWipeChars(cArray, n2, n3, StandardCharsets.UTF_8);
    }

    public void putAndWipeChars(char[] cArray, Charset charset) {
        this.putAndWipeChars(cArray, 0, GenericUtils.length(cArray), charset);
    }

    public void putAndWipeChars(char[] cArray, int n2, int n3, Charset charset) {
        this.putChars(cArray, n2, n3, charset);
        int n4 = n2;
        int n5 = 0;
        while (n5 < n3) {
            cArray[n4] = '\u0000';
            ++n5;
            ++n4;
        }
    }

    public void putChars(char[] cArray) {
        this.putChars(cArray, 0, GenericUtils.length(cArray));
    }

    public void putChars(char[] cArray, int n2, int n3) {
        this.putChars(cArray, n2, n3, StandardCharsets.UTF_8);
    }

    public void putChars(char[] cArray, Charset charset) {
        this.putChars(cArray, 0, GenericUtils.length(cArray), charset);
    }

    public void putChars(char[] cArray, int n2, int n3, Charset charset) {
        if (n3 <= 0) {
            this.putBytes(GenericUtils.EMPTY_BYTE_ARRAY);
        } else {
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3);
            ByteBuffer byteBuffer = charset.encode(charBuffer);
            this.putBuffer(byteBuffer);
        }
    }

    public void putMPInt(BigInteger bigInteger) {
        this.putMPInt(bigInteger.toByteArray());
    }

    public void putMPInt(byte[] byArray) {
        if ((byArray[0] & 0x80) != 0) {
            this.putUInt(byArray.length + 1);
            this.putByte((byte)0);
        } else {
            this.putUInt(byArray.length);
        }
        this.putRawBytes(byArray);
    }

    public void putRawBytes(byte[] byArray) {
        this.putRawBytes(byArray, 0, byArray.length);
    }

    public abstract void putRawBytes(byte[] var1, int var2, int var3);

    public void putPublicKey(PublicKey publicKey) {
        int n2 = this.wpos();
        this.putUInt(0L);
        int n3 = this.wpos();
        this.putRawPublicKey(publicKey);
        int n4 = this.wpos();
        this.wpos(n2);
        this.putUInt(n4 - n3);
        this.wpos(n4);
    }

    public void putRawPublicKey(PublicKey publicKey) {
        this.putString(KeyUtils.getKeyType(publicKey));
        this.putRawPublicKeyBytes(publicKey);
    }

    public void putRawPublicKeyBytes(PublicKey publicKey) {
        Objects.requireNonNull(publicKey, "No key");
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            this.putMPInt(rSAPublicKey.getPublicExponent());
            this.putMPInt(rSAPublicKey.getModulus());
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            this.putMPInt(dSAParams.getP());
            this.putMPInt(dSAParams.getQ());
            this.putMPInt(dSAParams.getG());
            this.putMPInt(dSAPublicKey.getY());
        } else if (publicKey instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
            ECCurves eCCurves = ECCurves.fromCurveParameters(eCParameterSpec);
            if (eCCurves == null) {
                throw new BufferException("Unsupported EC curve parameters");
            }
            byte[] byArray = ECCurves.encodeECPoint(eCPublicKey.getW(), eCParameterSpec);
            this.putString(eCCurves.getName());
            this.putBytes(byArray);
        } else if ("EdDSA".equals(publicKey.getAlgorithm())) {
            SecurityUtils.putRawEDDSAPublicKey(this, publicKey);
        } else if (publicKey instanceof SecurityKeyPublicKey) {
            this.putRawPublicKeyBytes(((SecurityKeyPublicKey)publicKey).getDelegatePublicKey());
            this.putString(((SecurityKeyPublicKey)publicKey).getAppName());
        } else if (publicKey instanceof OpenSshCertificate) {
            OpenSshCertificate openSshCertificate = (OpenSshCertificate)publicKey;
            this.putBytes(openSshCertificate.getNonce());
            this.putRawPublicKeyBytes(openSshCertificate.getCertPubKey());
            this.putLong(openSshCertificate.getSerial());
            this.putUInt(openSshCertificate.getType().getCode());
            this.putString(openSshCertificate.getId());
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            byteArrayBuffer.putStringList(openSshCertificate.getPrincipals(), false);
            this.putBytes(byteArrayBuffer.getCompactData());
            this.putLong(openSshCertificate.getValidAfter());
            this.putLong(openSshCertificate.getValidBefore());
            this.putCertificateOptions(openSshCertificate.getCriticalOptions());
            this.putCertificateOptions(openSshCertificate.getExtensions());
            this.putString(openSshCertificate.getReserved());
            byteArrayBuffer = new ByteArrayBuffer();
            byteArrayBuffer.putRawPublicKey(openSshCertificate.getCaPubKey());
            this.putBytes(byteArrayBuffer.getCompactData());
            if (openSshCertificate.getSignature() != null) {
                this.putBytes(openSshCertificate.getSignature());
            }
        } else {
            throw new BufferException("Unsupported raw public key algorithm: " + publicKey.getAlgorithm());
        }
    }

    public void putKeyPair(KeyPair keyPair) {
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            this.putString("ssh-rsa");
            this.putMPInt(rSAPublicKey.getPublicExponent());
            this.putMPInt(rSAPublicKey.getModulus());
            this.putMPInt(rSAPrivateCrtKey.getPrivateExponent());
            this.putMPInt(rSAPrivateCrtKey.getCrtCoefficient());
            this.putMPInt(rSAPrivateCrtKey.getPrimeQ());
            this.putMPInt(rSAPrivateCrtKey.getPrimeP());
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
            this.putString("ssh-dss");
            this.putMPInt(dSAParams.getP());
            this.putMPInt(dSAParams.getQ());
            this.putMPInt(dSAParams.getG());
            this.putMPInt(dSAPublicKey.getY());
            this.putMPInt(dSAPrivateKey.getX());
        } else if (publicKey instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
            ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
            ECCurves eCCurves = ECCurves.fromCurveParameters(eCParameterSpec);
            if (eCCurves == null) {
                throw new BufferException("Unsupported EC curve parameters");
            }
            byte[] byArray = ECCurves.encodeECPoint(eCPublicKey.getW(), eCParameterSpec);
            this.putString(eCCurves.getKeyType());
            this.putString(eCCurves.getName());
            this.putBytes(byArray);
            this.putMPInt(eCPrivateKey.getS());
        } else if ("EdDSA".equals(publicKey.getAlgorithm())) {
            SecurityUtils.putEDDSAKeyPair(this, publicKey, privateKey);
        } else {
            throw new BufferException("Unsupported key pair algorithm: " + publicKey.getAlgorithm());
        }
    }

    public Buffer ensureCapacity(int n2) {
        return this.ensureCapacity(n2, BufferUtils.DEFAULT_BUFFER_GROWTH_FACTOR);
    }

    public abstract Buffer ensureCapacity(int var1, IntUnaryOperator var2);

    protected abstract int size();

    public String toString() {
        return this.getClass().getSimpleName() + "[rpos=" + this.rpos() + ", wpos=" + this.wpos() + ", size=" + this.size() + "]";
    }
}

