/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.Serializable;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class VersionInfo
implements Serializable,
Comparable {
    private static final long serialVersionUID = -9127482432228413836L;
    private final int majorVersion;
    private final int minorVersion;
    private final int release;
    private final int buildNumber;

    public VersionInfo(int n2, int n3) {
        this(n2, n3, 0, 0);
    }

    public VersionInfo(int n2, int n3, int n4, int n5) {
        this.majorVersion = n2;
        this.minorVersion = n3;
        this.release = n4;
        this.buildNumber = n5;
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public final int getRelease() {
        return this.release;
    }

    public final int getBuildNumber() {
        return this.buildNumber;
    }

    public int hashCode() {
        return NumberUtils.hashCode(this.getMajorVersion(), this.getMinorVersion(), this.getRelease(), this.getBuildNumber());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.compareTo((VersionInfo)object) == 0;
    }

    public int compareTo(VersionInfo versionInfo) {
        if (versionInfo == null) {
            return -1;
        }
        if (versionInfo == this) {
            return 0;
        }
        int n2 = Integer.compare(this.getMajorVersion(), versionInfo.getMajorVersion());
        if (n2 == 0) {
            n2 = Integer.compare(this.getMinorVersion(), versionInfo.getMinorVersion());
        }
        if (n2 == 0) {
            n2 = Integer.compare(this.getRelease(), versionInfo.getRelease());
        }
        if (n2 == 0) {
            n2 = Integer.compare(this.getBuildNumber(), versionInfo.getBuildNumber());
        }
        return n2;
    }

    public String toString() {
        return NumberUtils.join('.', this.getMajorVersion(), this.getMinorVersion(), this.getRelease(), this.getBuildNumber());
    }

    public static VersionInfo parse(String string) {
        Object[] objectArray = GenericUtils.split(string, '.');
        if (GenericUtils.isEmpty(objectArray)) {
            return null;
        }
        int[] nArray = new int[4];
        int n2 = Math.min(objectArray.length, nArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            int n3 = Integer.parseInt((String)object);
            ValidateUtils.checkTrue(n3 >= 0, "Invalid version component in %s", (Object)string);
            nArray[i2] = n3;
        }
        return new VersionInfo(nArray[0], nArray[1], nArray[2], nArray[3]);
    }
}

