/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.NumberUtils;

public final class ValidateUtils {
    private ValidateUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Object checkNotNull(Object object, String string) {
        ValidateUtils.checkTrue(object != null, string);
        return object;
    }

    public static Object checkNotNull(Object object, String string, Object object2) {
        ValidateUtils.checkTrue(object != null, string, object2);
        return object;
    }

    public static Object checkNotNull(Object object, String string, long l2) {
        ValidateUtils.checkTrue(object != null, string, l2);
        return object;
    }

    public static Object checkNotNull(Object object, String string, Object ... objectArray) {
        ValidateUtils.checkTrue(object != null, string, objectArray);
        return object;
    }

    public static String checkNotNullAndNotEmpty(String string, String string2) {
        ValidateUtils.checkTrue(GenericUtils.length(string = ((String)ValidateUtils.checkNotNull(string, string2)).trim()) > 0, string2);
        return string;
    }

    public static String checkNotNullAndNotEmpty(String string, String string2, Object object) {
        ValidateUtils.checkTrue(GenericUtils.length(string = ((String)ValidateUtils.checkNotNull((Object)string, string2, object)).trim()) > 0, string2, object);
        return string;
    }

    public static String checkNotNullAndNotEmpty(String string, String string2, Object ... objectArray) {
        ValidateUtils.checkTrue(GenericUtils.length(string = ((String)ValidateUtils.checkNotNull((Object)string, string2, objectArray)).trim()) > 0, string2, objectArray);
        return string;
    }

    public static Map checkNotNullAndNotEmpty(Map map, String string, Object ... objectArray) {
        ValidateUtils.checkNotNull((Object)map, string, objectArray);
        ValidateUtils.checkTrue(MapEntryUtils.size(map) > 0, string, objectArray);
        return map;
    }

    public static Collection checkNotNullAndNotEmpty(Collection collection, String string, Object ... objectArray) {
        ValidateUtils.checkNotNull((Object)collection, string, objectArray);
        ValidateUtils.checkTrue(GenericUtils.size(collection) > 0, string, objectArray);
        return collection;
    }

    public static Iterable checkNotNullAndNotEmpty(Iterable iterable, String string, Object ... objectArray) {
        ValidateUtils.checkNotNull((Object)iterable, string, objectArray);
        ValidateUtils.checkTrue(GenericUtils.isNotEmpty(iterable), string, objectArray);
        return iterable;
    }

    public static byte[] checkNotNullAndNotEmpty(byte[] byArray, String string) {
        ValidateUtils.checkNotNull(byArray, string);
        ValidateUtils.checkTrue(NumberUtils.length(byArray) > 0, string);
        return byArray;
    }

    public static byte[] checkNotNullAndNotEmpty(byte[] byArray, String string, Object ... objectArray) {
        ValidateUtils.checkNotNull((Object)byArray, string, objectArray);
        ValidateUtils.checkTrue(NumberUtils.length(byArray) > 0, string, objectArray);
        return byArray;
    }

    public static char[] checkNotNullAndNotEmpty(char[] cArray, String string) {
        ValidateUtils.checkNotNull(cArray, string);
        ValidateUtils.checkTrue(GenericUtils.length(cArray) > 0, string);
        return cArray;
    }

    public static char[] checkNotNullAndNotEmpty(char[] cArray, String string, Object ... objectArray) {
        ValidateUtils.checkNotNull((Object)cArray, string, objectArray);
        ValidateUtils.checkTrue(GenericUtils.length(cArray) > 0, string, objectArray);
        return cArray;
    }

    public static int[] checkNotNullAndNotEmpty(int[] nArray, String string) {
        ValidateUtils.checkNotNull(nArray, string);
        ValidateUtils.checkTrue(NumberUtils.length(nArray) > 0, string);
        return nArray;
    }

    public static int[] checkNotNullAndNotEmpty(int[] nArray, String string, Object ... objectArray) {
        ValidateUtils.checkNotNull((Object)nArray, string, objectArray);
        ValidateUtils.checkTrue(NumberUtils.length(nArray) > 0, string, objectArray);
        return nArray;
    }

    public static Object[] checkNotNullAndNotEmpty(Object[] objectArray, String string, Object ... objectArray2) {
        ValidateUtils.checkNotNull((Object)objectArray, string, objectArray2);
        ValidateUtils.checkTrue(GenericUtils.length(objectArray) > 0, string, objectArray2);
        return objectArray;
    }

    public static Object checkInstanceOf(Object object, Class clazz, String string, long l2) {
        Class<?> clazz2 = ValidateUtils.checkNotNull(object, string, l2).getClass();
        ValidateUtils.checkTrue(clazz.isAssignableFrom(clazz2), string, l2);
        return clazz.cast(object);
    }

    public static Object checkInstanceOf(Object object, Class clazz, String string) {
        return ValidateUtils.checkInstanceOf(object, clazz, string, GenericUtils.EMPTY_OBJECT_ARRAY);
    }

    public static Object checkInstanceOf(Object object, Class clazz, String string, Object object2) {
        Class<?> clazz2 = ValidateUtils.checkNotNull(object, string, object2).getClass();
        ValidateUtils.checkTrue(clazz.isAssignableFrom(clazz2), string, object2);
        return clazz.cast(object);
    }

    public static Object checkInstanceOf(Object object, Class clazz, String string, Object ... objectArray) {
        Class<?> clazz2 = ValidateUtils.checkNotNull(object, string, objectArray).getClass();
        ValidateUtils.checkTrue(clazz.isAssignableFrom(clazz2), string, objectArray);
        return clazz.cast(object);
    }

    public static void checkTrue(boolean bl2, String string) {
        if (!bl2) {
            ValidateUtils.throwIllegalArgumentException(string, GenericUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    public static void checkTrue(boolean bl2, String string, long l2) {
        if (!bl2) {
            ValidateUtils.throwIllegalArgumentException(string, l2);
        }
    }

    public static void checkTrue(boolean bl2, String string, Object object) {
        if (!bl2) {
            ValidateUtils.throwIllegalArgumentException(string, object);
        }
    }

    public static void checkTrue(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            ValidateUtils.throwIllegalArgumentException(string, objectArray);
        }
    }

    public static void throwIllegalArgumentException(String string, Object ... objectArray) {
        throw (IllegalArgumentException)ValidateUtils.createFormattedException(IllegalArgumentException::new, string, objectArray);
    }

    public static void checkState(boolean bl2, String string) {
        if (!bl2) {
            ValidateUtils.throwIllegalStateException(string, GenericUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    public static void checkState(boolean bl2, String string, long l2) {
        if (!bl2) {
            ValidateUtils.throwIllegalStateException(string, l2);
        }
    }

    public static void checkState(boolean bl2, String string, Object object) {
        if (!bl2) {
            ValidateUtils.throwIllegalStateException(string, object);
        }
    }

    public static void checkState(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            ValidateUtils.throwIllegalStateException(string, objectArray);
        }
    }

    public static void throwIllegalStateException(String string, Object ... objectArray) {
        throw (IllegalStateException)ValidateUtils.createFormattedException(IllegalStateException::new, string, objectArray);
    }

    public static Throwable createFormattedException(Function function, String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        return (Throwable)function.apply(string2);
    }

    public static Throwable initializeExceptionCause(Throwable throwable, Throwable throwable2) {
        if (throwable2 == null) {
            return throwable;
        }
        if (throwable.getCause() != null) {
            return throwable;
        }
        throwable.initCause(throwable2);
        return throwable;
    }
}

