/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.File;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class SelectorUtils {
    public static final String PATTERN_HANDLER_PREFIX = "[";
    public static final String PATTERN_HANDLER_SUFFIX = "]";
    public static final String REGEX_HANDLER_PREFIX = "%regex[";
    public static final String ANT_HANDLER_PREFIX = "%ant[";

    private SelectorUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean matchPatternStart(String string, String string2) {
        return SelectorUtils.matchPatternStart(string, string2, true);
    }

    public static boolean matchPatternStart(String string, String string2, boolean bl2) {
        return SelectorUtils.matchPath(string, string2, File.separator, bl2);
    }

    public static boolean matchPatternStart(String string, String string2, String string3, boolean bl2) {
        if (string.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && string.startsWith(REGEX_HANDLER_PREFIX) && string.endsWith(PATTERN_HANDLER_SUFFIX)) {
            return true;
        }
        if (string.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && string.startsWith(ANT_HANDLER_PREFIX) && string.endsWith(PATTERN_HANDLER_SUFFIX)) {
            string = string.substring(ANT_HANDLER_PREFIX.length(), string.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        if (SelectorUtils.matchAntPathPatternStart(string, string2, string3, bl2)) {
            return true;
        }
        return SelectorUtils.matchAntPathPatternStart(string, string2.replace('\\', '/'), "/", bl2);
    }

    public static boolean matchAntPathPatternStart(String string, String string2, String string3, boolean bl2) {
        String string4;
        int n2;
        if (string2.startsWith(string3) != string.startsWith(string3)) {
            return false;
        }
        List list = SelectorUtils.tokenizePath(string, string3);
        List list2 = SelectorUtils.tokenizePath(string2, string3);
        int n3 = 0;
        int n4 = list.size() - 1;
        int n5 = list2.size() - 1;
        for (n2 = 0; n3 <= n4 && n2 <= n5 && !(string4 = (String)list.get(n3)).equals("**"); ++n3, ++n2) {
            if (SelectorUtils.match(string4, (String)list2.get(n2), bl2)) continue;
            return false;
        }
        if (n2 > n5) {
            return true;
        }
        return n3 <= n4;
    }

    public static boolean matchPath(String string, String string2) {
        return SelectorUtils.matchPath(string, string2, true);
    }

    public static boolean matchPath(String string, String string2, boolean bl2) {
        return SelectorUtils.matchPath(string, string2, File.separator, bl2);
    }

    public static boolean matchPath(String string, String string2, String string3, boolean bl2) {
        if (string.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && string.startsWith(REGEX_HANDLER_PREFIX) && string.endsWith(PATTERN_HANDLER_SUFFIX)) {
            string = string.substring(REGEX_HANDLER_PREFIX.length(), string.length() - PATTERN_HANDLER_SUFFIX.length());
            return string2.matches(string);
        }
        if (string.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && string.startsWith(ANT_HANDLER_PREFIX) && string.endsWith(PATTERN_HANDLER_SUFFIX)) {
            string = string.substring(ANT_HANDLER_PREFIX.length(), string.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        return SelectorUtils.matchAntPathPattern(string, string2, string3, bl2);
    }

    public static boolean matchAntPathPattern(String string, String string2, boolean bl2) {
        return SelectorUtils.matchAntPathPattern(string, string2, File.separator, bl2);
    }

    public static boolean matchAntPathPattern(String string, String string2, String string3, boolean bl2) {
        String string4;
        String string5;
        int n2;
        if (string2.startsWith(string3) != string.startsWith(string3)) {
            return false;
        }
        List list = SelectorUtils.tokenizePath(string, string3);
        List list2 = SelectorUtils.tokenizePath(string2, string3);
        int n3 = 0;
        int n4 = list.size() - 1;
        int n5 = list2.size() - 1;
        for (n2 = 0; n3 <= n4 && n2 <= n5 && !(string5 = (String)list.get(n3)).equals("**"); ++n3, ++n2) {
            string4 = (String)list2.get(n2);
            if (SelectorUtils.match(string5, string4, bl2)) continue;
            return false;
        }
        if (n2 > n5) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                string4 = (String)list.get(i2);
                if (string4.equals("**")) continue;
                return false;
            }
            return true;
        }
        if (n3 > n4) {
            return false;
        }
        while (n3 <= n4 && n2 <= n5 && !(string5 = (String)list.get(n4)).equals("**")) {
            string4 = (String)list2.get(n5);
            if (!SelectorUtils.match(string5, string4, bl2)) {
                return false;
            }
            --n4;
            --n5;
        }
        if (n2 > n5) {
            for (int i3 = n3; i3 <= n4; ++i3) {
                string4 = (String)list.get(i3);
                if (string4.equals("**")) continue;
                return false;
            }
            return true;
        }
        while (n3 != n4 && n2 <= n5) {
            int n6;
            int n7 = -1;
            for (n6 = n3 + 1; n6 <= n4; ++n6) {
                String string6 = (String)list.get(n6);
                if (!string6.equals("**")) continue;
                n7 = n6;
                break;
            }
            if (n7 == n3 + 1) {
                ++n3;
                continue;
            }
            n6 = n7 - n3 - 1;
            int n8 = n5 - n2 + 1;
            int n9 = -1;
            block6: for (int i4 = 0; i4 <= n8 - n6; ++i4) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    String string7;
                    String string8 = (String)list.get(n3 + i5 + 1);
                    if (!SelectorUtils.match(string8, string7 = (String)list2.get(n2 + i4 + i5), bl2)) continue block6;
                }
                n9 = n2 + i4;
                break;
            }
            if (n9 == -1) {
                return false;
            }
            n3 = n7;
            n2 = n9 + n6;
        }
        for (int i6 = n3; i6 <= n4; ++i6) {
            String string9 = (String)list.get(i6);
            if (string9.equals("**")) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String string, String string2) {
        return SelectorUtils.match(string, string2, true);
    }

    public static boolean match(String string, String string2, boolean bl2) {
        char c2;
        int n2;
        int n3;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n4 = 0;
        int n5 = cArray.length - 1;
        int n6 = 0;
        int n7 = cArray2.length - 1;
        boolean bl3 = false;
        char[] cArray3 = cArray;
        int n8 = cArray3.length;
        for (n3 = 0; n3 < n8; ++n3) {
            n2 = cArray3[n3];
            if (n2 != 42) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            if (n5 != n7) {
                return false;
            }
            for (int i2 = 0; i2 <= n5; ++i2) {
                char c3 = cArray[i2];
                if (c3 == '?' || SelectorUtils.equals(c3, cArray2[i2], bl2)) continue;
                return false;
            }
            return true;
        }
        if (n5 == 0) {
            return true;
        }
        while ((c2 = cArray[n4]) != '*' && n6 <= n7) {
            if (c2 != '?' && !SelectorUtils.equals(c2, cArray2[n6], bl2)) {
                return false;
            }
            ++n4;
            ++n6;
        }
        if (n6 > n7) {
            for (int i3 = n4; i3 <= n5; ++i3) {
                if (cArray[i3] == '*') continue;
                return false;
            }
            return true;
        }
        while ((c2 = cArray[n5]) != '*' && n6 <= n7) {
            if (c2 != '?' && !SelectorUtils.equals(c2, cArray2[n7], bl2)) {
                return false;
            }
            --n5;
            --n7;
        }
        if (n6 > n7) {
            for (int i4 = n4; i4 <= n5; ++i4) {
                if (cArray[i4] == '*') continue;
                return false;
            }
            return true;
        }
        while (n4 != n5 && n6 <= n7) {
            int n9 = -1;
            for (n8 = n4 + 1; n8 <= n5; ++n8) {
                if (cArray[n8] != '*') continue;
                n9 = n8;
                break;
            }
            if (n9 == n4 + 1) {
                ++n4;
                continue;
            }
            n8 = n9 - n4 - 1;
            n3 = n7 - n6 + 1;
            n2 = -1;
            block8: for (int i5 = 0; i5 <= n3 - n8; ++i5) {
                for (int i6 = 0; i6 < n8; ++i6) {
                    c2 = cArray[n4 + i6 + 1];
                    if (c2 != '?' && !SelectorUtils.equals(c2, cArray2[n6 + i5 + i6], bl2)) continue block8;
                }
                n2 = n6 + i5;
                break;
            }
            if (n2 == -1) {
                return false;
            }
            n4 = n9;
            n6 = n2 + n8;
        }
        for (int i7 = n4; i7 <= n5; ++i7) {
            if (cArray[i7] == '*') continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char c2, char c3, boolean bl2) {
        if (c2 == c3) {
            return true;
        }
        return !bl2 && (Character.toUpperCase(c2) == Character.toUpperCase(c3) || Character.toLowerCase(c2) == Character.toLowerCase(c3));
    }

    public static List tokenizePath(String string) {
        return SelectorUtils.tokenizePath(string, File.separator);
    }

    public static List tokenizePath(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static String translateToLocalFileSystemPath(String string, char c2, FileSystem fileSystem) {
        return SelectorUtils.translateToLocalFileSystemPath(string, c2, Objects.requireNonNull(fileSystem, "No target file system").getSeparator());
    }

    public static String translateToLocalFileSystemPath(String string, char c2, String string2) {
        String string3 = SelectorUtils.applySlashifyRules(string, c2);
        String string4 = SelectorUtils.translateToLocalPath(string3);
        return SelectorUtils.translateToFileSystemPath(string4, File.separator, string2);
    }

    public static String applySlashifyRules(String string, char c2) {
        if (GenericUtils.isEmpty(string)) {
            return string;
        }
        int n2 = string.indexOf(c2);
        if (n2 < 0) {
            return string;
        }
        int n3 = 0;
        StringBuilder stringBuilder = null;
        while (n2 < string.length()) {
            int n4;
            for (n4 = ++n2; n4 < string.length() && string.charAt(n4) == c2; ++n4) {
            }
            int n5 = n4 - n2;
            if (n5 > 0) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.length() - n5);
                }
                if (n3 < n2) {
                    String string2 = string.substring(n3, n2);
                    stringBuilder.append(string2);
                }
                n3 = n4;
            }
            if (n4 < string.length() && (n2 = string.indexOf(c2, n4)) >= n4) continue;
            break;
        }
        if (stringBuilder != null) {
            if (n3 < string.length()) {
                String string3 = string.substring(n3);
                stringBuilder.append(string3);
            }
            string = stringBuilder.toString();
        }
        if (string.length() > 1 && string.charAt(string.length() - 1) == c2) {
            return string + ".";
        }
        return string;
    }

    public static String translateToLocalPath(String string) {
        if (GenericUtils.isEmpty(string) || File.separatorChar == '/') {
            return string;
        }
        String string2 = string.replace('/', File.separatorChar);
        if (string2.charAt(0) == File.separatorChar && SelectorUtils.isWindowsDriveSpecified(string2, 1, string2.length() - 1)) {
            string2 = string2.substring(1);
        }
        if (!SelectorUtils.isWindowsDriveSpecified(string2)) {
            return string2;
        }
        if (string2.length() == 2) {
            return string2 + File.separator;
        }
        if (string2.charAt(2) != File.separatorChar) {
            return string2.substring(0, 2) + File.separator + string2.substring(2);
        }
        return string2;
    }

    public static boolean isWindowsDriveSpecified(CharSequence charSequence) {
        return SelectorUtils.isWindowsDriveSpecified(charSequence, 0, GenericUtils.length(charSequence));
    }

    public static boolean isWindowsDriveSpecified(CharSequence charSequence, int n2, int n3) {
        if (n3 < 2 || charSequence.charAt(n2 + 1) != ':') {
            return false;
        }
        char c2 = charSequence.charAt(n2);
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
    }

    public static String translateToFileSystemPath(String string, String string2, FileSystem fileSystem) {
        return SelectorUtils.translateToFileSystemPath(string, string2, Objects.requireNonNull(fileSystem, "No target file system").getSeparator());
    }

    public static String translateToFileSystemPath(String string, String string2, String string3) {
        ValidateUtils.checkNotNullAndNotEmpty(string2, "Missing path separator");
        ValidateUtils.checkNotNullAndNotEmpty(string3, "Missing file-system separator");
        if (GenericUtils.isEmpty(string) || Objects.equals(string2, string3)) {
            return string;
        }
        if (string.contains(string3)) {
            ValidateUtils.throwIllegalArgumentException("File system replacement may yield ambiguous result for %s with separator=%s", string, string3);
        }
        if (string2.length() == 1 && string3.length() == 1) {
            return string.replace(string2.charAt(0), string3.charAt(0));
        }
        return string.replace(string2, string3);
    }

    public static String concatPaths(String string, String string2, char c2) {
        if (GenericUtils.isEmpty(string)) {
            return string2;
        }
        if (GenericUtils.isEmpty(string2)) {
            return string;
        }
        if (string.charAt(string.length() - 1) == c2) {
            if (string2.charAt(0) == c2) {
                return string2.length() == 1 ? string : string + string2.substring(1);
            }
            return string + string2;
        }
        if (string2.charAt(0) == c2) {
            return string2.length() == 1 ? string : string + string2;
        }
        return string + Character.toString(c2) + string2;
    }

    public static String removeWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append(stringTokenizer.nextToken());
            }
        }
        return stringBuilder.toString();
    }
}

