/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sshd.common.util.GenericUtils;

public final class ReflectionUtils {
    public static final Function FIELD_NAME_EXTRACTOR = field -> field == null ? null : field.getName();

    private ReflectionUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Collection getMatchingFields(Class clazz, Predicate predicate) {
        return GenericUtils.selectMatchingMembers(predicate, clazz.getFields());
    }

    public static Collection getMatchingDeclaredFields(Class clazz, Predicate predicate) {
        return GenericUtils.selectMatchingMembers(predicate, clazz.getDeclaredFields());
    }

    @Deprecated
    public static boolean isClassAvailable(ClassLoader classLoader, String string) {
        try {
            classLoader.loadClass(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Object newInstance(Class clazz) {
        return ReflectionUtils.newInstance(clazz, Object.class);
    }

    public static Object newInstance(Class clazz, Class clazz2) {
        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
        Object t2 = constructor.newInstance(new Object[0]);
        return clazz2.cast(t2);
    }
}

