/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.VersionInfo;

public final class OsUtils {
    public static final String CURRENT_USER_OVERRIDE_PROP = "org.apache.sshd.currentUser";
    public static final String JAVA_VERSION_OVERRIDE_PROP = "org.apache.sshd.javaVersion";
    public static final String OS_TYPE_OVERRIDE_PROP = "org.apache.sshd.osType";
    public static final String ANDROID_MODE_OVERRIDE_PROP = "org.apache.sshd.androidMode";
    public static final String DALVIK_MACHINE_OVERRIDE_PROP = "org.apache.sshd.dalvikMachine";
    public static final String WINDOWS_SHELL_COMMAND_NAME = "cmd.exe";
    public static final String LINUX_SHELL_COMMAND_NAME = "/bin/sh";
    public static final String ROOT_USER = "root";
    public static final List LINUX_COMMAND = Collections.unmodifiableList(Arrays.asList("/bin/sh", "-i", "-l"));
    public static final List WINDOWS_COMMAND = Collections.unmodifiableList(Collections.singletonList("cmd.exe"));
    public static final List ANDROID_DETECTION_PROPERTIES = Collections.unmodifiableList(Arrays.asList("java.vendor", "java.specification.vendor", "java.vm.vendor", "java.vm.specification.vendor"));
    public static final Predicate ANDROID_PROPERTY_VALUE_MATCHER = string -> GenericUtils.trimToEmpty(string).toLowerCase().contains("android");
    public static final List DALVIK_DETECTION_PROPERTIES = Collections.unmodifiableList(Arrays.asList("java.specification.name", "java.vm.name", "java.vm.specification.name"));
    public static final Predicate DALVIK_PROPERTY_VALUE_MATCHER = string -> GenericUtils.trimToEmpty(string).toLowerCase().contains("dalvik");
    private static final AtomicReference CURRENT_USER_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference JAVA_VERSION_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference OS_TYPE_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference ANDROID_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference DALVIK_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference CWD_PROVIDER_HOLDER = new AtomicReference();

    private OsUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean isAndroid() {
        return OsUtils.resolveAndroidSettingFlag(ANDROID_HOLDER, ANDROID_MODE_OVERRIDE_PROP, ANDROID_DETECTION_PROPERTIES, ANDROID_PROPERTY_VALUE_MATCHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAndroid(Boolean bl2) {
        AtomicReference atomicReference = ANDROID_HOLDER;
        synchronized (atomicReference) {
            ANDROID_HOLDER.set(bl2);
        }
    }

    public static boolean isDalvikMachine() {
        return OsUtils.resolveAndroidSettingFlag(DALVIK_HOLDER, DALVIK_MACHINE_OVERRIDE_PROP, DALVIK_DETECTION_PROPERTIES, DALVIK_PROPERTY_VALUE_MATCHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDalvikMachine(Boolean bl2) {
        AtomicReference atomicReference = DALVIK_HOLDER;
        synchronized (atomicReference) {
            DALVIK_HOLDER.set(bl2);
        }
    }

    public static boolean isUNIX() {
        return !OsUtils.isWin32() && !OsUtils.isOSX();
    }

    public static boolean isOSX() {
        return OsUtils.getOS().contains("mac");
    }

    public static boolean isWin32() {
        return OsUtils.getOS().contains("windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOS(String string) {
        AtomicReference atomicReference = OS_TYPE_HOLDER;
        synchronized (atomicReference) {
            OS_TYPE_HOLDER.set(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean resolveAndroidSettingFlag(AtomicReference atomicReference, String string, Collection collection, Predicate predicate) {
        AtomicReference atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            Boolean bl2 = (Boolean)atomicReference.get();
            if (bl2 != null) {
                return bl2;
            }
            String string2 = System.getProperty(string);
            if (predicate.test(string2)) {
                atomicReference.set(Boolean.TRUE);
                return true;
            }
            for (String string3 : collection) {
                String string4 = System.getProperty(string3);
                if (!predicate.test(string4)) continue;
                atomicReference.set(Boolean.TRUE);
                return true;
            }
            atomicReference.set(Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOS() {
        String string;
        AtomicReference atomicReference = OS_TYPE_HOLDER;
        synchronized (atomicReference) {
            string = (String)OS_TYPE_HOLDER.get();
            if (string != null) {
                return string;
            }
            String string2 = System.getProperty(OS_TYPE_OVERRIDE_PROP, System.getProperty("os.name"));
            string = GenericUtils.trimToEmpty(string2).toLowerCase();
            OS_TYPE_HOLDER.set(string);
        }
        return string;
    }

    public static String resolveDefaultInteractiveShellCommand() {
        return OsUtils.resolveDefaultInteractiveShellCommand(OsUtils.isWin32());
    }

    public static String resolveDefaultInteractiveShellCommand(boolean bl2) {
        return bl2 ? WINDOWS_SHELL_COMMAND_NAME : "/bin/sh -i -l";
    }

    public static List resolveDefaultInteractiveCommandElements() {
        return OsUtils.resolveDefaultInteractiveCommandElements(OsUtils.isWin32());
    }

    public static List resolveDefaultInteractiveCommandElements(boolean bl2) {
        if (bl2) {
            return WINDOWS_COMMAND;
        }
        return LINUX_COMMAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getCurrentWorkingDirectory() {
        Supplier supplier;
        Object object = CWD_PROVIDER_HOLDER;
        synchronized (object) {
            supplier = (Supplier)CWD_PROVIDER_HOLDER.get();
        }
        if (supplier != null) {
            return (Path)supplier.get();
        }
        object = System.getProperty("user.dir");
        return GenericUtils.isBlank((CharSequence)object) ? null : Paths.get((String)object, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentWorkingDirectoryResolver(Supplier supplier) {
        AtomicReference atomicReference = CWD_PROVIDER_HOLDER;
        synchronized (atomicReference) {
            CWD_PROVIDER_HOLDER.set(supplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentUser() {
        String string;
        AtomicReference atomicReference = CURRENT_USER_HOLDER;
        synchronized (atomicReference) {
            string = (String)CURRENT_USER_HOLDER.get();
            if (string != null) {
                return string;
            }
            string = OsUtils.getCanonicalUser(System.getProperty(CURRENT_USER_OVERRIDE_PROP, System.getProperty("user.name")));
            ValidateUtils.checkNotNullAndNotEmpty(string, "No username available");
            CURRENT_USER_HOLDER.set(string);
        }
        return string;
    }

    public static String getCanonicalUser(String string) {
        if (GenericUtils.isEmpty(string)) {
            return string;
        }
        if (OsUtils.isWin32()) {
            int n2 = string.lastIndexOf(92);
            if (n2 > 0) {
                string = string.substring(n2 + 1);
            }
            if ((n2 = string.indexOf(32)) > 0) {
                string = string.substring(0, n2).trim();
            }
        }
        return string;
    }

    public static String resolveCanonicalGroup(String string, String string2) {
        if (OsUtils.isUNIX()) {
            return string;
        }
        if (GenericUtils.isEmpty(string)) {
            int n2 = GenericUtils.isEmpty(string2) ? -1 : string2.lastIndexOf(92);
            return n2 > 0 ? string2.substring(0, n2) : string;
        }
        int n3 = string.indexOf(32);
        return n3 < 0 ? string : string.substring(0, n3).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentUser(String string) {
        AtomicReference atomicReference = CURRENT_USER_HOLDER;
        synchronized (atomicReference) {
            CURRENT_USER_HOLDER.set(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionInfo getJavaVersion() {
        VersionInfo versionInfo;
        AtomicReference atomicReference = JAVA_VERSION_HOLDER;
        synchronized (atomicReference) {
            versionInfo = (VersionInfo)JAVA_VERSION_HOLDER.get();
            if (versionInfo != null) {
                return versionInfo;
            }
            String string = System.getProperty(JAVA_VERSION_OVERRIDE_PROP, System.getProperty("java.version"));
            string = ValidateUtils.checkNotNullAndNotEmpty(string, "No configured Java version value").replace('_', '.');
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '.' || c2 >= '0' && c2 <= '9') continue;
                string = string.substring(0, i2);
                break;
            }
            versionInfo = (VersionInfo)ValidateUtils.checkNotNull((Object)VersionInfo.parse(string), "No version parsed for %s", (Object)string);
            JAVA_VERSION_HOLDER.set(versionInfo);
        }
        return versionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJavaVersion(VersionInfo versionInfo) {
        AtomicReference atomicReference = JAVA_VERSION_HOLDER;
        synchronized (atomicReference) {
            JAVA_VERSION_HOLDER.set(versionInfo);
        }
    }

    public static String getComparablePath(String string) {
        String string2 = string == null ? "" : string;
        return OsUtils.isWin32() ? string2.toLowerCase() : string2;
    }
}

