/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;

public final class NumberUtils {
    public static final List NUMERIC_PRIMITIVE_CLASSES = GenericUtils.unmodifiableList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);

    private NumberUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static int getNextPowerOf2(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative value N/A: " + n2);
        }
        int n3 = 1;
        while (n3 < n2) {
            if ((n3 <<= 1) > 0) continue;
            return n2;
        }
        return n3;
    }

    public static int hashCode(long ... lArray) {
        return Arrays.hashCode(lArray);
    }

    public static int hashCode(int ... nArray) {
        return Arrays.hashCode(nArray);
    }

    public static int hashCode(byte ... byArray) {
        return Arrays.hashCode(byArray);
    }

    public static int hashCode(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        int n4 = 1;
        int n5 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = byArray[n5];
            n4 = 31 * n4 + by;
            ++n5;
        }
        return n4;
    }

    public static int diffOffset(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n2;
        int n6 = n3;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by = byArray[n5];
            byte by2 = byArray2[n6];
            if (by != by2) {
                return i2;
            }
            ++n5;
            ++n6;
        }
        return -1;
    }

    public static boolean isNumericClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        return NUMERIC_PRIMITIVE_CLASSES.indexOf(clazz) >= 0;
    }

    public static Integer toInteger(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public static String join(CharSequence charSequence, long ... lArray) {
        if (NumberUtils.isEmpty(lArray)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(lArray.length * 8);
        for (long l2 : lArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(l2);
        }
        return stringBuilder.toString();
    }

    public static String join(char c2, long ... lArray) {
        if (NumberUtils.isEmpty(lArray)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(lArray.length * 8);
        for (long l2 : lArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(l2);
        }
        return stringBuilder.toString();
    }

    public static String join(CharSequence charSequence, boolean bl2, byte ... byArray) {
        if (NumberUtils.isEmpty(byArray)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 8);
        for (int n2 : byArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(bl2 ? n2 & 0xFF : n2);
        }
        return stringBuilder.toString();
    }

    public static String join(char c2, boolean bl2, byte ... byArray) {
        if (NumberUtils.isEmpty(byArray)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 8);
        for (int n2 : byArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(bl2 ? n2 & 0xFF : n2);
        }
        return stringBuilder.toString();
    }

    public static String join(CharSequence charSequence, int ... nArray) {
        if (NumberUtils.isEmpty(nArray)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 8);
        for (int n2 : nArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    public static String join(char c2, int ... nArray) {
        if (NumberUtils.isEmpty(nArray)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 8);
        for (int n2 : nArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    public static byte[] emptyIfNull(byte[] byArray) {
        return byArray == null ? GenericUtils.EMPTY_BYTE_ARRAY : byArray;
    }

    public static boolean isEmpty(byte[] byArray) {
        return NumberUtils.length(byArray) <= 0;
    }

    public static boolean isEmpty(int[] nArray) {
        return NumberUtils.length(nArray) <= 0;
    }

    public static boolean isEmpty(long[] lArray) {
        return NumberUtils.length(lArray) <= 0;
    }

    public static int length(byte ... byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    public static int length(int ... nArray) {
        return nArray == null ? 0 : nArray.length;
    }

    public static int length(long ... lArray) {
        return lArray == null ? 0 : lArray.length;
    }

    public static List asList(int ... nArray) {
        int n2 = NumberUtils.length(nArray);
        if (n2 <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
        for (int n3 : nArray) {
            arrayList.add(n3);
        }
        return arrayList;
    }

    public static boolean isIntegerNumber(CharSequence charSequence) {
        if (GenericUtils.isEmpty(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || (c2 == '+' || c2 == '-') && i2 == 0) continue;
            return false;
        }
        return true;
    }
}

