/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class MapEntryUtils {
    private static final Comparator BY_KEY_COMPARATOR = (entry, entry2) -> {
        Comparable comparable = (Comparable)entry.getKey();
        Comparable comparable2 = (Comparable)entry2.getKey();
        return comparable.compareTo(comparable2);
    };
    private static final Supplier CASE_INSENSITIVE_MAP_FACTORY = () -> new TreeMap(String.CASE_INSENSITIVE_ORDER);

    private MapEntryUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Comparator byKeyEntryComparator() {
        return BY_KEY_COMPARATOR;
    }

    public static int size(Map map) {
        return map == null ? 0 : map.size();
    }

    public static boolean isEmpty(Map map) {
        return MapEntryUtils.size(map) <= 0;
    }

    public static boolean isNotEmpty(Map map) {
        return !MapEntryUtils.isEmpty(map);
    }

    public static Supplier caseInsensitiveMap() {
        return CASE_INSENSITIVE_MAP_FACTORY;
    }

    public static Map flipMap(Map map, Supplier supplier, boolean bl2) {
        Map map2 = (Map)Objects.requireNonNull(supplier.get(), "No map created");
        map.forEach((object, object2) -> {
            Object object3 = map2.put(object2, object);
            if (object3 != null && !bl2) {
                ValidateUtils.throwIllegalArgumentException("Multiple values for key=%s: current=%s, previous=%s", object2, object, object3);
            }
        });
        return map2;
    }

    @SafeVarargs
    public static Map mapValues(Function function, Supplier supplier, Object ... objectArray) {
        return MapEntryUtils.mapValues(function, supplier, GenericUtils.isEmpty(objectArray) ? Collections.emptyList() : Arrays.asList(objectArray));
    }

    public static Map mapValues(Function function, Supplier supplier, Collection collection) {
        Map map = (Map)supplier.get();
        for (Object e2 : collection) {
            Object r2 = function.apply(e2);
            if (r2 == null) continue;
            map.put(r2, e2);
        }
        return map;
    }

    public static NavigableMap toSortedMap(Iterable iterable, Function function, Function function2, Comparator comparator) {
        return (NavigableMap)GenericUtils.stream(iterable).collect(MapEntryUtils.toSortedMap(function, function2, comparator));
    }

    public static Collector toSortedMap(Function function, Function function2, Comparator comparator) {
        return Collectors.toMap(function, function2, MapEntryUtils.throwingMerger(), () -> new TreeMap(comparator));
    }

    public static BinaryOperator throwingMerger() {
        return (object, object2) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", object));
        };
    }
}

