/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sshd.common.util.GenericUtils$1;
import org.apache.sshd.common.util.functors.UnaryEquator;

public final class GenericUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Object NULL = new Object();
    public static final Comparator CASE_SENSITIVE_ORDER = (string, string2) -> {
        if (string == string2) {
            return 0;
        }
        return string.compareTo((String)string2);
    };
    public static final String QUOTES = "\"'";

    private GenericUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String trimToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String replaceWhitespaceAndTrim(String string) {
        if (string != null) {
            string = string.replace('\t', ' ');
        }
        return GenericUtils.trimToEmpty(string);
    }

    public static String replace(String string, String string2, String string3, int n2) {
        if (string == null || string2 == null || string3 == null || string2.length() == 0) {
            return string;
        }
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n4 = string.indexOf(string2, n3);
        while (n4 != -1) {
            stringBuilder.append(string.substring(n3, n4)).append(string3);
            n3 = n4 + string2.length();
            if (--n2 == 0) break;
            n4 = string.indexOf(string2, n3);
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static int hashCode(String string) {
        return GenericUtils.hashCode(string, null);
    }

    public static int hashCode(String string, Boolean bl2) {
        if (GenericUtils.isEmpty(string)) {
            return 0;
        }
        if (bl2 == null) {
            return string.hashCode();
        }
        if (bl2.booleanValue()) {
            return string.toUpperCase().hashCode();
        }
        return string.toLowerCase().hashCode();
    }

    public static int safeCompare(String string, String string2, boolean bl2) {
        if (UnaryEquator.isSameReference(string, string2)) {
            return 0;
        }
        if (string == null) {
            return 1;
        }
        if (string2 == null) {
            return -1;
        }
        if (bl2) {
            return string.compareTo(string2);
        }
        return string.compareToIgnoreCase(string2);
    }

    public static int length(CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return GenericUtils.length(charSequence) <= 0;
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !GenericUtils.isEmpty(charSequence);
    }

    public static boolean isBlank(CharSequence charSequence) {
        int n2;
        int n3 = n2 = charSequence != null ? charSequence.length() : 0;
        if (charSequence == null || n2 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence charSequence) {
        return !GenericUtils.isBlank(charSequence);
    }

    public static List filterToNotBlank(List list) {
        return list.stream().filter(GenericUtils::isNotBlank).collect(Collectors.toList());
    }

    public static int indexOf(CharSequence charSequence, char c2) {
        int n2 = GenericUtils.length(charSequence);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = charSequence.charAt(i2);
            if (c3 != c2) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence charSequence, char c2) {
        int n2 = GenericUtils.length(charSequence);
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            char c3 = charSequence.charAt(i2);
            if (c3 != c2) continue;
            return i2;
        }
        return -1;
    }

    public static String[] split(String string, char c2) {
        String string2;
        if (GenericUtils.isEmpty(string)) {
            return EMPTY_STRING_ARRAY;
        }
        int n2 = 0;
        int n3 = string.indexOf(c2);
        if (n3 < 0) {
            return new String[]{string};
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        do {
            string2 = string.substring(n2, n3);
            linkedList.add(string2);
            n2 = n3 + 1;
        } while (n2 < string.length() && (n3 = string.indexOf(c2, n2)) >= n2 && n3 < string.length());
        if (n2 < string.length()) {
            string2 = string.substring(n2);
            linkedList.add(string2);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String join(Object[] objectArray, char c2) {
        return GenericUtils.join(GenericUtils.isEmpty(objectArray) ? Collections.emptyList() : Arrays.asList(objectArray), c2);
    }

    public static String join(Iterable iterable, char c2) {
        return GenericUtils.join(iterable == null ? null : iterable.iterator(), c2);
    }

    public static String join(Iterator iterator, char c2) {
        if (iterator == null || !iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            Object e2 = iterator.next();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(Objects.toString(e2));
        } while (iterator.hasNext());
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, CharSequence charSequence) {
        return GenericUtils.join(GenericUtils.isEmpty(objectArray) ? Collections.emptyList() : Arrays.asList(objectArray), charSequence);
    }

    public static String join(Iterable iterable, CharSequence charSequence) {
        return GenericUtils.join(iterable == null ? null : iterable.iterator(), charSequence);
    }

    public static String join(Iterator iterator, CharSequence charSequence) {
        if (iterator == null || !iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            Object e2 = iterator.next();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(Objects.toString(e2));
        } while (iterator.hasNext());
        return stringBuilder.toString();
    }

    public static int size(Collection collection) {
        return collection == null ? 0 : collection.size();
    }

    public static boolean isEmpty(Collection collection) {
        return GenericUtils.size(collection) <= 0;
    }

    public static boolean isNotEmpty(Collection collection) {
        return !GenericUtils.isEmpty(collection);
    }

    public static boolean equals(Collection collection, Collection collection2) {
        if (GenericUtils.isEmpty(collection)) {
            return GenericUtils.isEmpty(collection2);
        }
        if (GenericUtils.isEmpty(collection2)) {
            return false;
        }
        return collection.size() == collection2.size() && collection.containsAll(collection2) && collection2.containsAll(collection);
    }

    @SafeVarargs
    public static int length(Object ... objectArray) {
        return objectArray == null ? 0 : objectArray.length;
    }

    public static boolean isEmpty(Iterable iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection) {
            return GenericUtils.isEmpty((Collection)iterable);
        }
        return GenericUtils.isEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterable iterable) {
        return !GenericUtils.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator iterator) {
        return iterator == null || !iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterator iterator) {
        return !GenericUtils.isEmpty(iterator);
    }

    public static boolean isEmpty(Object[] objectArray) {
        return GenericUtils.length(objectArray) <= 0;
    }

    public static int length(char[] cArray) {
        return cArray == null ? 0 : cArray.length;
    }

    public static boolean isEmpty(char[] cArray) {
        return GenericUtils.length(cArray) <= 0;
    }

    public static int compare(char[] cArray, char[] cArray2) {
        int n2;
        int n3 = GenericUtils.length(cArray);
        int n4 = GenericUtils.length(cArray2);
        int n5 = Math.min(n3, n4);
        for (n2 = 0; n2 < n5; ++n2) {
            char c2 = cArray[n2];
            char c3 = cArray2[n2];
            int n6 = Character.compare(c2, c3);
            if (n6 == 0) continue;
            return n6;
        }
        n2 = Integer.compare(n3, n4);
        if (n2 != 0) {
            return n2;
        }
        return 0;
    }

    @SafeVarargs
    public static Set of(Enum ... enumArray) {
        return GenericUtils.of(GenericUtils.isEmpty(enumArray) ? Collections.emptySet() : Arrays.asList(enumArray));
    }

    public static Set of(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptySet();
        }
        EnumSet<Enum> enumSet = null;
        for (Enum enum_ : collection) {
            if (enumSet == null) {
                enumSet = EnumSet.of(enum_);
                continue;
            }
            enumSet.add(enum_);
        }
        return enumSet;
    }

    public static int findFirstDifferentValueIndex(List list, List list2) {
        return GenericUtils.findFirstDifferentValueIndex(list, list2, UnaryEquator.defaultEquality());
    }

    public static int findFirstDifferentValueIndex(List list, List list2, UnaryEquator unaryEquator) {
        Objects.requireNonNull(unaryEquator, "No equator provided");
        int n2 = GenericUtils.size(list);
        int n3 = GenericUtils.size(list2);
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            Object e2;
            Object e3 = list.get(i2);
            if (unaryEquator.test(e3, e2 = list2.get(i2))) continue;
            return i2;
        }
        if (n2 < n3) {
            return n2;
        }
        if (n3 < n2) {
            return n3;
        }
        return -1;
    }

    public static int findFirstDifferentValueIndex(Iterable iterable, Iterable iterable2) {
        return GenericUtils.findFirstDifferentValueIndex(iterable, iterable2, UnaryEquator.defaultEquality());
    }

    public static int findFirstDifferentValueIndex(Iterable iterable, Iterable iterable2, UnaryEquator unaryEquator) {
        return GenericUtils.findFirstDifferentValueIndex(GenericUtils.iteratorOf(iterable), GenericUtils.iteratorOf(iterable2), unaryEquator);
    }

    public static int findFirstDifferentValueIndex(Iterator iterator, Iterator iterator2) {
        return GenericUtils.findFirstDifferentValueIndex(iterator, iterator2, UnaryEquator.defaultEquality());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int findFirstDifferentValueIndex(Iterator iterator, Iterator iterator2, UnaryEquator unaryEquator) {
        Objects.requireNonNull(unaryEquator, "No equator provided");
        iterator = GenericUtils.iteratorOf(iterator);
        iterator2 = GenericUtils.iteratorOf(iterator2);
        int n2 = 0;
        while (true) {
            if (iterator.hasNext()) {
                Object e2;
                if (!iterator2.hasNext()) return n2;
                Object e3 = iterator.next();
                if (!unaryEquator.test(e3, e2 = iterator2.next())) {
                    return n2;
                }
            } else {
                if (!iterator2.hasNext()) return -1;
                return n2;
            }
            ++n2;
        }
    }

    public static boolean containsAny(Collection collection, Iterable iterable) {
        if (GenericUtils.isEmpty(collection)) {
            return false;
        }
        for (Object t2 : iterable) {
            if (!collection.contains(t2)) continue;
            return true;
        }
        return false;
    }

    public static void forEach(Iterable iterable, Consumer consumer) {
        if (GenericUtils.isNotEmpty(iterable)) {
            iterable.forEach(consumer);
        }
    }

    public static List map(Collection collection, Function function) {
        return GenericUtils.stream(collection).map(function).collect(Collectors.toList());
    }

    public static NavigableSet mapSort(Collection collection, Function function, Comparator comparator) {
        return (NavigableSet)GenericUtils.stream(collection).map(function).collect(GenericUtils.toSortedSet(comparator));
    }

    public static Collector toSortedSet(Comparator comparator) {
        return Collectors.toCollection(() -> new TreeSet(comparator));
    }

    public static Stream stream(Iterable iterable) {
        if (GenericUtils.isEmpty(iterable)) {
            return Stream.empty();
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).stream();
        }
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @SafeVarargs
    public static List unmodifiableList(Object ... objectArray) {
        return GenericUtils.unmodifiableList(GenericUtils.asList(objectArray));
    }

    public static List unmodifiableList(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList(collection));
    }

    public static List unmodifiableList(Stream stream) {
        return GenericUtils.unmodifiableList(stream.collect(Collectors.toList()));
    }

    @SafeVarargs
    public static List asList(Object ... objectArray) {
        return GenericUtils.isEmpty(objectArray) ? Collections.emptyList() : Arrays.asList(objectArray);
    }

    @SafeVarargs
    public static Set asSet(Object ... objectArray) {
        return new HashSet(GenericUtils.asList(objectArray));
    }

    @SafeVarargs
    public static NavigableSet asSortedSet(Comparable ... comparableArray) {
        return GenericUtils.asSortedSet(Comparator.naturalOrder(), (Object[])comparableArray);
    }

    public static NavigableSet asSortedSet(Collection collection) {
        return GenericUtils.asSortedSet(Comparator.naturalOrder(), collection);
    }

    @SafeVarargs
    public static NavigableSet asSortedSet(Comparator comparator, Object ... objectArray) {
        return GenericUtils.asSortedSet(comparator, GenericUtils.isEmpty(objectArray) ? Collections.emptyList() : Arrays.asList(objectArray));
    }

    public static NavigableSet asSortedSet(Comparator comparator, Collection collection) {
        TreeSet treeSet = new TreeSet(Objects.requireNonNull(comparator, "No comparator"));
        if (GenericUtils.size(collection) > 0) {
            treeSet.addAll(collection);
        }
        return treeSet;
    }

    @SafeVarargs
    public static Object findFirstMatchingMember(Predicate predicate, Object ... objectArray) {
        return GenericUtils.findFirstMatchingMember(predicate, GenericUtils.isEmpty(objectArray) ? Collections.emptyList() : Arrays.asList(objectArray));
    }

    public static Object findFirstMatchingMember(Predicate predicate, Collection collection) {
        List list = GenericUtils.selectMatchingMembers(predicate, collection);
        return GenericUtils.isEmpty(list) ? null : list.get(0);
    }

    @SafeVarargs
    public static List selectMatchingMembers(Predicate predicate, Object ... objectArray) {
        return GenericUtils.selectMatchingMembers(predicate, GenericUtils.isEmpty(objectArray) ? Collections.emptyList() : Arrays.asList(objectArray));
    }

    public static List selectMatchingMembers(Predicate predicate, Collection collection) {
        return GenericUtils.stream(collection).filter(predicate).collect(Collectors.toList());
    }

    public static CharSequence stripQuotes(CharSequence charSequence) {
        if (GenericUtils.isEmpty(charSequence)) {
            return charSequence;
        }
        for (int i2 = 0; i2 < QUOTES.length(); ++i2) {
            char c2 = QUOTES.charAt(i2);
            CharSequence charSequence2 = GenericUtils.stripDelimiters(charSequence, c2);
            if (charSequence2 == charSequence) continue;
            return charSequence2;
        }
        return charSequence;
    }

    public static CharSequence stripDelimiters(CharSequence charSequence, char c2) {
        if (GenericUtils.isEmpty(charSequence) || charSequence.length() < 2) {
            return charSequence;
        }
        int n2 = charSequence.length() - 1;
        if (charSequence.charAt(0) != c2 || charSequence.charAt(n2) != c2) {
            return charSequence;
        }
        return charSequence.subSequence(1, n2);
    }

    public static Supplier supplierOf(Object object) {
        return () -> object;
    }

    public static Iterator iteratorOf(Iterable iterable) {
        return GenericUtils.iteratorOf(iterable == null ? null : iterable.iterator());
    }

    public static Function downcast() {
        return object -> object;
    }

    public static Object head(Iterable iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof Deque) {
            Deque deque = (Deque)iterable;
            return !deque.isEmpty() ? deque.getFirst() : null;
        }
        if (iterable instanceof List) {
            List list = (List)iterable;
            return !list.isEmpty() ? list.get(0) : null;
        }
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            return !sortedSet.isEmpty() ? sortedSet.first() : null;
        }
        Iterator iterator = iterable.iterator();
        return iterator == null || !iterator.hasNext() ? null : iterator.next();
    }

    public static Iterator iteratorOf(Iterator iterator) {
        return iterator == null ? Collections.emptyIterator() : iterator;
    }

    public static Iterable wrapIterable(Iterable iterable, Function function) {
        return () -> GenericUtils.wrapIterator(iterable, function);
    }

    public static Iterator wrapIterator(Iterable iterable, Function function) {
        return GenericUtils.stream(iterable).map(function).iterator();
    }

    public static Iterator wrapIterator(Iterator iterator, Function function) {
        Iterator iterator2 = GenericUtils.iteratorOf(iterator);
        return new GenericUtils$1(iterator2, function);
    }

    public static Object selectNextMatchingValue(Iterator iterator, Class clazz) {
        Objects.requireNonNull(clazz, "No type selector specified");
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            Class<?> clazz2;
            Object e2 = iterator.next();
            if (e2 == null || !clazz.isAssignableFrom(clazz2 = e2.getClass())) continue;
            return clazz.cast(e2);
        }
        return null;
    }

    public static Iterable multiIterableSuppliers(Iterable iterable) {
        return () -> GenericUtils.stream(iterable).flatMap(supplier -> GenericUtils.stream((Iterable)supplier.get())).map(Function.identity()).iterator();
    }

    public static Supplier memoizeLock(Supplier supplier) {
        AtomicReference atomicReference = new AtomicReference();
        return () -> GenericUtils.lambda$memoizeLock$7(atomicReference, (Supplier)supplier);
    }

    public static boolean isPositive(Duration duration) {
        return !GenericUtils.isNegativeOrNull(duration);
    }

    public static boolean isNegativeOrNull(Duration duration) {
        return duration.isNegative() || duration.isZero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Object lambda$memoizeLock$7(AtomicReference atomicReference, Supplier supplier) {
        Object object = atomicReference.get();
        if (object == null) {
            AtomicReference atomicReference2 = atomicReference;
            synchronized (atomicReference2) {
                object = atomicReference.get();
                if (object == null) {
                    object = Objects.requireNonNull(supplier.get());
                    atomicReference.set(object);
                }
            }
        }
        return object;
    }
}

