/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.apache.sshd.common.util.OsUtils;

public final class ExceptionUtils {
    private ExceptionUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static void rethrowAsIoException(Throwable throwable) {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new IOException(throwable);
    }

    public static Throwable accumulateException(Throwable throwable, Throwable throwable2) {
        if (throwable == null) {
            return throwable2;
        }
        if (throwable2 == null || throwable2 == throwable) {
            return throwable;
        }
        throwable.addSuppressed(throwable2);
        return throwable;
    }

    public static Throwable resolveExceptionCause(Throwable throwable) {
        if (throwable == null) {
            return throwable;
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return throwable;
        }
        return throwable2;
    }

    public static Throwable peelException(Throwable throwable) {
        Throwable throwable2;
        if (throwable == null) {
            return throwable;
        }
        if (throwable instanceof UndeclaredThrowableException) {
            throwable2 = ((UndeclaredThrowableException)throwable).getUndeclaredThrowable();
            if (throwable2 != null) {
                return ExceptionUtils.peelException(throwable2);
            }
            throwable2 = throwable.getCause();
            if (throwable2 != throwable) {
                return ExceptionUtils.peelException(throwable2);
            }
        } else if (throwable instanceof InvocationTargetException) {
            throwable2 = ((InvocationTargetException)throwable).getTargetException();
            if (throwable2 != null) {
                return ExceptionUtils.peelException(throwable2);
            }
        } else if (throwable instanceof ExecutionException) {
            return ExceptionUtils.peelException(ExceptionUtils.resolveExceptionCause(throwable));
        }
        if (!OsUtils.isAndroid() && (throwable instanceof ReflectionException ? (throwable2 = ((ReflectionException)throwable).getTargetException()) != null : throwable instanceof MBeanException && (throwable2 = ((MBeanException)throwable).getTargetException()) != null)) {
            return ExceptionUtils.peelException(throwable2);
        }
        return throwable;
    }

    public static RuntimeException toRuntimeException(Throwable throwable, boolean bl2) {
        Throwable throwable2;
        Throwable throwable3 = throwable2 = bl2 ? ExceptionUtils.peelException(throwable) : throwable;
        if (throwable2 instanceof RuntimeException) {
            return (RuntimeException)throwable2;
        }
        return new RuntimeException(throwable2);
    }

    public static RuntimeException toRuntimeException(Throwable throwable) {
        return ExceptionUtils.toRuntimeException(throwable, true);
    }
}

