/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ProxyUtils;
import org.apache.sshd.common.util.SshdEventListener;

public final class EventListenerUtils {
    public static final Comparator LISTENER_INSTANCE_COMPARATOR = (eventListener, eventListener2) -> {
        String string;
        int n2;
        if (eventListener == eventListener2) {
            return 0;
        }
        if (eventListener == null) {
            return 1;
        }
        if (eventListener2 == null) {
            return -1;
        }
        Class<?> clazz = eventListener.getClass();
        Class<?> clazz2 = eventListener2.getClass();
        boolean bl2 = true;
        if (Proxy.isProxyClass(clazz)) {
            if (!Proxy.isProxyClass(clazz2)) return 1;
            bl2 = false;
        } else if (Proxy.isProxyClass(clazz2)) {
            return -1;
        }
        if (bl2 && (n2 = Integer.compare(eventListener.hashCode(), eventListener2.hashCode())) != 0) {
            return n2;
        }
        n2 = Integer.compare(System.identityHashCode(eventListener), System.identityHashCode(eventListener2));
        if (n2 != 0) {
            return n2;
        }
        if (clazz != clazz2) {
            return clazz.getName().compareTo(clazz2.getName());
        }
        String string2 = Objects.toString(eventListener.toString(), "");
        n2 = string2.compareTo(string = Objects.toString(eventListener2.toString(), ""));
        if (n2 == 0) throw new UnsupportedOperationException("Ran out of options to compare instance of " + string2 + " vs. " + string);
        return n2;
    };

    private EventListenerUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Set synchronizedListenersSet(Collection collection) {
        Set set = EventListenerUtils.synchronizedListenersSet();
        if (GenericUtils.size(collection) > 0) {
            set.addAll(collection);
        }
        return set;
    }

    public static Set synchronizedListenersSet() {
        return Collections.synchronizedSet(new TreeSet(LISTENER_INSTANCE_COMPARATOR));
    }

    public static SshdEventListener proxyWrapper(Class clazz, Iterable iterable) {
        return EventListenerUtils.proxyWrapper(clazz, clazz.getClassLoader(), iterable);
    }

    public static SshdEventListener proxyWrapper(Class clazz, ClassLoader classLoader, Iterable iterable) {
        Objects.requireNonNull(iterable, "No listeners container provided");
        return (SshdEventListener)ProxyUtils.newProxyInstance(classLoader, clazz, (object, method, objectArray) -> {
            Throwable throwable = null;
            for (SshdEventListener sshdEventListener : iterable) {
                try {
                    method.invoke((Object)sshdEventListener, objectArray);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = ExceptionUtils.peelException(throwable2);
                    throwable = ExceptionUtils.accumulateException(throwable, throwable3);
                }
            }
            if (throwable != null) {
                throw ProxyUtils.unwrapInvocationThrowable(throwable);
            }
            return null;
        });
    }
}

