/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class SignatureRSA
extends AbstractSignature {
    public static final NavigableSet SUPPORTED_KEY_TYPES = Collections.unmodifiableNavigableSet(Stream.of("ssh-rsa", "ssh-rsa-cert-v01@openssh.com", "rsa-sha2-256", "rsa-sha2-512", "rsa-sha2-256-cert-v01@openssh.com", "rsa-sha2-512-cert-v01@openssh.com").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
    private int verifierSignatureSize = -1;
    private final String sshAlgorithmName;

    protected SignatureRSA(String string, String string2) {
        super(string);
        this.sshAlgorithmName = ValidateUtils.checkNotNullAndNotEmpty(string2, "Missing protocol name of the signature algorithm.");
    }

    @Override
    public String getSshAlgorithmName(String string) {
        return this.sshAlgorithmName;
    }

    protected int getVerifierSignatureSize() {
        return this.verifierSignatureSize;
    }

    @Override
    public void initVerifier(SessionContext sessionContext, PublicKey publicKey) {
        super.initVerifier(sessionContext, publicKey);
        RSAKey rSAKey = (RSAKey)ValidateUtils.checkInstanceOf(publicKey, RSAKey.class, "Not an RSA key");
        this.verifierSignatureSize = SignatureRSA.getVerifierSignatureSize(rSAKey);
    }

    public static int getVerifierSignatureSize(RSAKey rSAKey) {
        BigInteger bigInteger = rSAKey.getModulus();
        return (bigInteger.bitLength() + 8 - 1) / 8;
    }

    @Override
    public boolean verify(SessionContext sessionContext, byte[] byArray) {
        int n2;
        Object object;
        Object object2 = byArray;
        Map.Entry entry = this.extractEncodedSignature((byte[])object2, SUPPORTED_KEY_TYPES);
        if (entry != null) {
            String string = (String)entry.getKey();
            object = KeyUtils.getCanonicalKeyType(string);
            ValidateUtils.checkTrue(SUPPORTED_KEY_TYPES.contains(object), "Mismatched key type: %s", (Object)string);
            object2 = (byte[])entry.getValue();
        }
        ValidateUtils.checkTrue((n2 = this.getVerifierSignatureSize()) > 0, "Signature verification size has not been initialized");
        if (((byte[])object2).length < n2) {
            object = new byte[n2];
            System.arraycopy(object2, 0, object, ((Object)object).length - ((byte[])object2).length, ((byte[])object2).length);
            object2 = object;
        }
        return this.doVerify((byte[])object2);
    }
}

