/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;

public interface SignatureFactory
extends BuiltinFactory {
    public static final List ECC_SIGNATURE_TYPE_PREFERENCES = Collections.unmodifiableList(Arrays.asList(KeyPairProvider.ECDSA_SHA2_NISTP521, KeyPairProvider.ECDSA_SHA2_NISTP384, KeyPairProvider.ECDSA_SHA2_NISTP256));
    public static final List RSA_SIGNATURE_TYPE_PREFERENCES = Collections.unmodifiableList(Arrays.asList("rsa-sha2-512", "rsa-sha2-256", "ssh-rsa"));

    public static List resolveSignatureFactoriesProposal(Iterable iterable, Collection collection) {
        return SignatureFactory.resolveSignatureFactoryNamesProposal(iterable, NamedResource.getNameList(collection));
    }

    public static List resolveSignatureFactoryNamesProposal(Iterable iterable, Collection collection) {
        Object object;
        if (iterable == null || GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        HashSet hashSet = new HashSet();
        for (String string : iterable) {
            object = KeyUtils.getAllEquivalentKeyTypes(string);
            hashSet.addAll(object);
        }
        if (GenericUtils.isEmpty(hashSet)) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(collection);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            object = (String)arrayList.get(i2);
            if (hashSet.contains(object)) continue;
            arrayList.remove(i2);
            --i2;
        }
        return arrayList;
    }

    public static int resolvePreferredSignaturePosition(List list, NamedFactory namedFactory) {
        if (GenericUtils.isEmpty(list)) {
            return -1;
        }
        String string = namedFactory.getName();
        if ("ssh-rsa".equalsIgnoreCase(string)) {
            return -1;
        }
        int n2 = RSA_SIGNATURE_TYPE_PREFERENCES.indexOf(string);
        if (n2 >= 0) {
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                NamedFactory namedFactory2 = (NamedFactory)list.get(i2);
                String string2 = namedFactory2.getName();
                String string3 = KeyUtils.getCanonicalKeyType(string2);
                if (!"ssh-rsa".equalsIgnoreCase(string3)) continue;
                treeMap.put(string2, i2);
            }
            return SignatureFactory.resolvePreferredSignaturePosition(RSA_SIGNATURE_TYPE_PREFERENCES, n2, treeMap);
        }
        n2 = ECC_SIGNATURE_TYPE_PREFERENCES.indexOf(string);
        if (n2 >= 0) {
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            int n4 = list.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                NamedFactory namedFactory3 = (NamedFactory)list.get(i3);
                String string4 = namedFactory3.getName();
                if (!ECC_SIGNATURE_TYPE_PREFERENCES.contains(string4)) continue;
                treeMap.put(string4, i3);
            }
            return SignatureFactory.resolvePreferredSignaturePosition(ECC_SIGNATURE_TYPE_PREFERENCES, n2, treeMap);
        }
        return -1;
    }

    public static int resolvePreferredSignaturePosition(List list, int n2, Map map) {
        if (GenericUtils.isEmpty(list) || n2 < 0 || MapEntryUtils.isEmpty(map)) {
            return -1;
        }
        int n3 = -1;
        for (Map.Entry entry : map.entrySet()) {
            int n4;
            String string = (String)entry.getKey();
            int n5 = list.indexOf(string);
            if (n5 < 0) continue;
            Integer n6 = (Integer)entry.getValue();
            if (n5 < n2) {
                n4 = n6 + 1;
            } else {
                if (n5 <= n2) continue;
                n4 = n6;
            }
            if (n3 >= 0 && n4 >= n3) continue;
            n3 = n4;
        }
        return n3;
    }

    public static NamedFactory resolveSignatureFactory(String string, Collection collection) {
        if (GenericUtils.isEmpty(string) || GenericUtils.isEmpty(collection)) {
            return null;
        }
        List list = KeyUtils.getAllEquivalentKeyTypes(string);
        if (GenericUtils.isEmpty(list)) {
            return (NamedFactory)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, collection);
        }
        return (NamedFactory)NamedResource.findFirstMatchByName(list, String.CASE_INSENSITIVE_ORDER, collection);
    }

    public static NamedFactory resolveSignatureFactoryByPublicKey(PublicKey publicKey, String string) {
        Object object;
        if (publicKey == null) {
            return null;
        }
        BuiltinSignatures builtinSignatures = null;
        if (publicKey instanceof DSAPublicKey) {
            builtinSignatures = BuiltinSignatures.dsa;
        } else if (publicKey instanceof ECPublicKey) {
            object = (ECPublicKey)publicKey;
            builtinSignatures = BuiltinSignatures.getFactoryByCurveSize(object.getParams());
        } else if (publicKey instanceof RSAPublicKey) {
            if (GenericUtils.isEmpty(string)) {
                builtinSignatures = BuiltinSignatures.rsa;
            } else if (string.contains("rsa")) {
                builtinSignatures = BuiltinSignatures.fromFactoryName(string);
            }
        } else if ("EdDSA".equalsIgnoreCase(publicKey.getAlgorithm())) {
            builtinSignatures = BuiltinSignatures.ed25519;
        }
        if (GenericUtils.isEmpty(string) || builtinSignatures == null) {
            return builtinSignatures;
        }
        object = builtinSignatures.getName();
        if (!string.equalsIgnoreCase((String)object)) {
            throw new InvalidKeySpecException("Mismatched factory name (" + (String)object + ") for algorithm=" + string + " when using key type" + KeyUtils.getKeyType(publicKey));
        }
        return builtinSignatures;
    }
}

