/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.BuiltinSignatures$ParseResult;
import org.apache.sshd.common.signature.SignatureFactoriesHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface SignatureFactoriesManager
extends SignatureFactoriesHolder {
    public void setSignatureFactories(List var1);

    default public void setSignatureFactoriesNameList(String string) {
        this.setSignatureFactoriesNames(GenericUtils.split(string, ','));
    }

    default public void setSignatureFactoriesNames(String ... stringArray) {
        this.setSignatureFactoriesNames(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    default public void setSignatureFactoriesNames(Collection collection) {
        BuiltinSignatures$ParseResult builtinSignatures$ParseResult = BuiltinSignatures.parseSignatureList(collection);
        List list = (List)ValidateUtils.checkNotNullAndNotEmpty(builtinSignatures$ParseResult.getParsedFactories(), "No supported signature factories: %s", collection);
        List list2 = builtinSignatures$ParseResult.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(list2), "Unsupported signature factories found: %s", (Object)list2);
        this.setSignatureFactories(list);
    }

    public static List resolveSignatureFactories(SignatureFactoriesManager signatureFactoriesManager, SignatureFactoriesManager signatureFactoriesManager2) {
        List list = SignatureFactoriesManager.getSignatureFactories(signatureFactoriesManager);
        return GenericUtils.isEmpty(list) ? SignatureFactoriesManager.getSignatureFactories(signatureFactoriesManager2) : list;
    }

    public static List getSignatureFactories(SignatureFactoriesManager signatureFactoriesManager) {
        return signatureFactoriesManager == null ? null : signatureFactoriesManager.getSignatureFactories();
    }
}

