/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.io.FilterOutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.Map;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.der.DERWriter;

public class SignatureECDSA
extends AbstractSignature {
    protected SignatureECDSA(String string) {
        super(string);
    }

    @Override
    public byte[] sign(SessionContext sessionContext) {
        byte[] byArray = super.sign(sessionContext);
        try (DERParser dERParser = new DERParser(byArray);){
            int n2 = dERParser.read();
            if (n2 != 48) {
                throw new StreamCorruptedException("Invalid signature format - not a DER SEQUENCE: 0x" + Integer.toHexString(n2));
            }
            int n3 = dERParser.readLength();
            if (n3 < 6) {
                throw new StreamCorruptedException("Invalid signature format - not enough encoded data length: " + n3);
            }
            BigInteger bigInteger = dERParser.readBigInteger();
            BigInteger bigInteger2 = dERParser.readBigInteger();
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            byteArrayBuffer.putMPInt(bigInteger);
            byteArrayBuffer.putMPInt(bigInteger2);
            byte[] byArray2 = byteArrayBuffer.getCompactData();
            return byArray2;
        }
    }

    @Override
    public boolean verify(SessionContext sessionContext, byte[] byArray) {
        byte[] byArray2;
        byte[] byArray3;
        Object object;
        Object object2;
        byte[] byArray4 = byArray;
        Map.Entry entry = this.extractEncodedSignature(byArray4, ECCurves.KEY_TYPES);
        if (entry != null) {
            object2 = (String)entry.getKey();
            object = ECCurves.fromKeyType((String)object2);
            ValidateUtils.checkNotNull(object, "Unknown curve type: %s", object2);
            byArray4 = (byte[])entry.getValue();
        }
        object2 = new ByteArrayBuffer(byArray4);
        object = ((Buffer)object2).getMPIntAsBytes();
        Object object3 = new DERWriter(((Object)object).length + 4);
        Object object4 = null;
        try {
            ((DERWriter)object3).writeBigInteger((byte[])object);
            byArray3 = ((DERWriter)object3).toByteArray();
        }
        catch (Throwable throwable) {
            object4 = throwable;
            throw throwable;
        }
        finally {
            if (object3 != null) {
                if (object4 != null) {
                    try {
                        ((FilterOutputStream)object3).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object4).addSuppressed(throwable);
                    }
                } else {
                    ((FilterOutputStream)object3).close();
                }
            }
        }
        object3 = ((Buffer)object2).getMPIntAsBytes();
        try (DERWriter dERWriter = new DERWriter(((Object)object3).length + 4);){
            dERWriter.writeBigInteger((byte[])object3);
            object4 = dERWriter.toByteArray();
        }
        int n2 = object2.available();
        if (n2 != 0) {
            throw new StreamCorruptedException("Signature had padding - remaining=" + n2);
        }
        int n3 = byArray3.length + ((Object)object4).length;
        try (DERWriter dERWriter = new DERWriter(1 + n3 + 4);){
            dERWriter.write(48);
            dERWriter.writeLength(n3);
            dERWriter.write(byArray3);
            dERWriter.write((byte[])object4);
            byArray2 = dERWriter.toByteArray();
        }
        return this.doVerify(byArray2);
    }
}

