/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.io.FilterOutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.SignatureException;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.der.DERWriter;

public class SignatureDSA
extends AbstractSignature {
    public static final String DEFAULT_ALGORITHM = "SHA1withDSA";
    public static final int DSA_SIGNATURE_LENGTH = 40;
    public static final int MAX_SIGNATURE_VALUE_LENGTH = 20;

    public SignatureDSA() {
        this(DEFAULT_ALGORITHM);
    }

    protected SignatureDSA(String string) {
        super(string);
    }

    @Override
    public byte[] sign(SessionContext sessionContext) {
        byte[] byArray = super.sign(sessionContext);
        try (DERParser dERParser = new DERParser(byArray);){
            int n2 = dERParser.read();
            if (n2 != 48) {
                throw new StreamCorruptedException("Invalid signature format - not a DER SEQUENCE: 0x" + Integer.toHexString(n2));
            }
            int n3 = dERParser.readLength();
            if (n3 < 6) {
                throw new StreamCorruptedException("Invalid signature format - not enough encoded data length: " + n3);
            }
            BigInteger bigInteger = dERParser.readBigInteger();
            BigInteger bigInteger2 = dERParser.readBigInteger();
            byte[] byArray2 = new byte[40];
            SignatureDSA.putBigInteger(bigInteger, byArray2, 0);
            SignatureDSA.putBigInteger(bigInteger2, byArray2, 20);
            byte[] byArray3 = byArray2;
            return byArray3;
        }
    }

    public static void putBigInteger(BigInteger bigInteger, byte[] byArray, int n2) {
        byte[] byArray2 = bigInteger.toByteArray();
        boolean bl2 = byArray2.length > 20;
        int n3 = bl2 ? 0 : 20 - byArray2.length;
        System.arraycopy(byArray2, bl2 ? 1 : 0, byArray, n2 + n3, Math.min(20, byArray2.length));
    }

    @Override
    public boolean verify(SessionContext sessionContext, byte[] byArray) {
        Object object;
        Object object2;
        int n2 = NumberUtils.length(byArray);
        byte[] byArray2 = byArray;
        if (n2 != 40 && (object2 = this.extractEncodedSignature(byArray, "ssh-dss"::equalsIgnoreCase)) != null) {
            object = (String)object2.getKey();
            ValidateUtils.checkTrue("ssh-dss".equals(object), "Mismatched key type: %s", object);
            byArray2 = (byte[])object2.getValue();
            n2 = NumberUtils.length(byArray2);
        }
        if (n2 != 40) {
            throw new SignatureException("Bad signature length (" + n2 + " instead of " + 40 + ") for " + BufferUtils.toHex(':', byArray2));
        }
        object = new DERWriter(24);
        Object object3 = null;
        try {
            ((DERWriter)object).writeBigInteger(byArray2, 0, 20);
            object2 = ((DERWriter)object).toByteArray();
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object3 != null) {
                    try {
                        ((FilterOutputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    ((FilterOutputStream)object).close();
                }
            }
        }
        object3 = new DERWriter(24);
        Object object4 = null;
        try {
            ((DERWriter)object3).writeBigInteger(byArray2, 20, 20);
            object = ((DERWriter)object3).toByteArray();
        }
        catch (Throwable throwable) {
            object4 = throwable;
            throw throwable;
        }
        finally {
            if (object3 != null) {
                if (object4 != null) {
                    try {
                        ((FilterOutputStream)object3).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object4).addSuppressed(throwable);
                    }
                } else {
                    ((FilterOutputStream)object3).close();
                }
            }
        }
        int n3 = ((Object)object2).length + ((Object)object).length;
        try (DERWriter dERWriter = new DERWriter(1 + n3 + 4);){
            dERWriter.write(48);
            dERWriter.writeLength(n3);
            dERWriter.write((byte[])object2);
            dERWriter.write((byte[])object);
            object4 = dERWriter.toByteArray();
        }
        return this.doVerify((byte[])object4);
    }
}

