/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.signature.BuiltinSignatures$1;
import org.apache.sshd.common.signature.BuiltinSignatures$10;
import org.apache.sshd.common.signature.BuiltinSignatures$11;
import org.apache.sshd.common.signature.BuiltinSignatures$12;
import org.apache.sshd.common.signature.BuiltinSignatures$13;
import org.apache.sshd.common.signature.BuiltinSignatures$14;
import org.apache.sshd.common.signature.BuiltinSignatures$15;
import org.apache.sshd.common.signature.BuiltinSignatures$16;
import org.apache.sshd.common.signature.BuiltinSignatures$17;
import org.apache.sshd.common.signature.BuiltinSignatures$18;
import org.apache.sshd.common.signature.BuiltinSignatures$2;
import org.apache.sshd.common.signature.BuiltinSignatures$3;
import org.apache.sshd.common.signature.BuiltinSignatures$4;
import org.apache.sshd.common.signature.BuiltinSignatures$5;
import org.apache.sshd.common.signature.BuiltinSignatures$6;
import org.apache.sshd.common.signature.BuiltinSignatures$7;
import org.apache.sshd.common.signature.BuiltinSignatures$8;
import org.apache.sshd.common.signature.BuiltinSignatures$9;
import org.apache.sshd.common.signature.BuiltinSignatures$ParseResult;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class BuiltinSignatures
extends Enum
implements SignatureFactory {
    @Deprecated
    public static final /* enum */ BuiltinSignatures dsa = new BuiltinSignatures$1("ssh-dss");
    @Deprecated
    public static final /* enum */ BuiltinSignatures dsa_cert = new BuiltinSignatures$2("ssh-dss-cert-v01@openssh.com");
    public static final /* enum */ BuiltinSignatures rsa = new BuiltinSignatures$3("ssh-rsa");
    @Deprecated
    public static final /* enum */ BuiltinSignatures rsa_cert = new BuiltinSignatures$4("ssh-rsa-cert-v01@openssh.com");
    public static final /* enum */ BuiltinSignatures rsaSHA256 = new BuiltinSignatures$5("rsa-sha2-256");
    public static final /* enum */ BuiltinSignatures rsaSHA256_cert = new BuiltinSignatures$6("rsa-sha2-256-cert-v01@openssh.com");
    public static final /* enum */ BuiltinSignatures rsaSHA512 = new BuiltinSignatures$7("rsa-sha2-512");
    public static final /* enum */ BuiltinSignatures rsaSHA512_cert = new BuiltinSignatures$8("rsa-sha2-512-cert-v01@openssh.com");
    public static final /* enum */ BuiltinSignatures nistp256 = new BuiltinSignatures$9(KeyPairProvider.ECDSA_SHA2_NISTP256);
    public static final /* enum */ BuiltinSignatures nistp256_cert = new BuiltinSignatures$10("ecdsa-sha2-nistp256-cert-v01@openssh.com");
    public static final /* enum */ BuiltinSignatures nistp384 = new BuiltinSignatures$11(KeyPairProvider.ECDSA_SHA2_NISTP384);
    public static final /* enum */ BuiltinSignatures nistp384_cert = new BuiltinSignatures$12("ecdsa-sha2-nistp384-cert-v01@openssh.com");
    public static final /* enum */ BuiltinSignatures nistp521 = new BuiltinSignatures$13(KeyPairProvider.ECDSA_SHA2_NISTP521);
    public static final /* enum */ BuiltinSignatures nistp521_cert = new BuiltinSignatures$14("ecdsa-sha2-nistp521-cert-v01@openssh.com");
    public static final /* enum */ BuiltinSignatures sk_ecdsa_sha2_nistp256 = new BuiltinSignatures$15("sk-ecdsa-sha2-nistp256@openssh.com");
    public static final /* enum */ BuiltinSignatures ed25519 = new BuiltinSignatures$16("ssh-ed25519");
    public static final /* enum */ BuiltinSignatures ed25519_cert = new BuiltinSignatures$17("ssh-ed25519-cert-v01@openssh.com");
    public static final /* enum */ BuiltinSignatures sk_ssh_ed25519 = new BuiltinSignatures$18("sk-ssh-ed25519@openssh.com");
    public static final Set VALUES;
    private static final Map EXTENSIONS;
    private final String factoryName;
    private static final /* synthetic */ BuiltinSignatures[] $VALUES;

    public static BuiltinSignatures[] values() {
        return (BuiltinSignatures[])$VALUES.clone();
    }

    public static BuiltinSignatures valueOf(String string) {
        return Enum.valueOf(BuiltinSignatures.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinSignatures() {
        void var3_2;
        void var2_-1;
        void var1_-1;
        this.factoryName = var3_2;
    }

    public static BuiltinSignatures getFactoryByCurveSize(ECParameterSpec eCParameterSpec) {
        int n2 = ECCurves.getCurveSize(eCParameterSpec);
        if (n2 <= 256) {
            return nistp256;
        }
        if (n2 <= 384) {
            return nistp384;
        }
        return nistp521;
    }

    public static Signature getSignerByCurveSize(ECParameterSpec eCParameterSpec) {
        BuiltinSignatures builtinSignatures = BuiltinSignatures.getFactoryByCurveSize(eCParameterSpec);
        return builtinSignatures == null ? null : (Signature)builtinSignatures.create();
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(SignatureFactory signatureFactory) {
        String string = Objects.requireNonNull(signatureFactory, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinSignatures.fromFactoryName(string) == null, "Extension overrides built-in: %s", (Object)string);
        Map map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(string), "Extension overrides existing: %s", (Object)string);
            EXTENSIONS.put(string, signatureFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet getRegisteredExtensions() {
        Map map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignatureFactory unregisterExtension(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (SignatureFactory)EXTENSIONS.remove(string);
        }
    }

    public static BuiltinSignatures fromString(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (BuiltinSignatures builtinSignatures : VALUES) {
            if (!string.equalsIgnoreCase(builtinSignatures.name())) continue;
            return builtinSignatures;
        }
        return null;
    }

    public static BuiltinSignatures fromFactory(NamedFactory namedFactory) {
        if (namedFactory == null) {
            return null;
        }
        return BuiltinSignatures.fromFactoryName(namedFactory.getName());
    }

    public static BuiltinSignatures fromFactoryName(String string) {
        return (BuiltinSignatures)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinSignatures$ParseResult parseSignatureList(String string) {
        return BuiltinSignatures.parseSignatureList(GenericUtils.split(string, ','));
    }

    public static BuiltinSignatures$ParseResult parseSignatureList(String ... stringArray) {
        return BuiltinSignatures.parseSignatureList(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public static BuiltinSignatures$ParseResult parseSignatureList(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return BuiltinSignatures$ParseResult.EMPTY;
        }
        ArrayList<SignatureFactory> arrayList = new ArrayList<SignatureFactory>(collection.size());
        List list = Collections.emptyList();
        for (String string : collection) {
            SignatureFactory signatureFactory = BuiltinSignatures.resolveFactory(string);
            if (signatureFactory != null) {
                arrayList.add(signatureFactory);
                continue;
            }
            if (list.isEmpty()) {
                list = new ArrayList();
            }
            list.add(string);
        }
        return new BuiltinSignatures$ParseResult(arrayList, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignatureFactory resolveFactory(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        BuiltinSignatures builtinSignatures = BuiltinSignatures.fromFactoryName(string);
        if (builtinSignatures != null) {
            return builtinSignatures;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (SignatureFactory)EXTENSIONS.get(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ BuiltinSignatures(String string, BuiltinSignatures$1 builtinSignatures$1) {
        this((String)var1_-1, (int)builtinSignatures$1, (String)var3_2);
        void var3_2;
        void var1_-1;
    }

    static {
        $VALUES = new BuiltinSignatures[]{dsa, dsa_cert, rsa, rsa_cert, rsaSHA256, rsaSHA256_cert, rsaSHA512, rsaSHA512_cert, nistp256, nistp256_cert, nistp384, nistp384_cert, nistp521, nistp521_cert, sk_ecdsa_sha2_nistp256, ed25519, ed25519_cert, sk_ssh_ed25519};
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinSignatures.class));
        EXTENSIONS = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }
}

