/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractSignature
implements Signature {
    private java.security.Signature signatureInstance;
    private final String algorithm;

    protected AbstractSignature(String string) {
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(string, "No signature algorithm specified");
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    protected java.security.Signature doInitSignature(SessionContext sessionContext, String string, Key key, boolean bl2) {
        return SecurityUtils.getSignature(string);
    }

    protected java.security.Signature getSignature() {
        return this.signatureInstance;
    }

    @Override
    public byte[] sign(SessionContext sessionContext) {
        java.security.Signature signature = Objects.requireNonNull(this.getSignature(), "Signature not initialized");
        return signature.sign();
    }

    @Override
    public void initVerifier(SessionContext sessionContext, PublicKey publicKey) {
        String string = this.getAlgorithm();
        this.signatureInstance = Objects.requireNonNull(this.doInitSignature(sessionContext, string, publicKey, false), "No signature instance create");
        this.signatureInstance.initVerify(Objects.requireNonNull(publicKey, "No public key provided"));
    }

    @Override
    public void initSigner(SessionContext sessionContext, PrivateKey privateKey) {
        String string = this.getAlgorithm();
        this.signatureInstance = Objects.requireNonNull(this.doInitSignature(sessionContext, string, privateKey, true), "No signature instance create");
        this.signatureInstance.initSign(Objects.requireNonNull(privateKey, "No private key provided"));
    }

    @Override
    public void update(SessionContext sessionContext, byte[] byArray, int n2, int n3) {
        java.security.Signature signature = Objects.requireNonNull(this.getSignature(), "Signature not initialized");
        signature.update(byArray, n2, n3);
    }

    protected Map.Entry extractEncodedSignature(byte[] byArray, Collection collection) {
        return GenericUtils.isEmpty(collection) ? null : this.extractEncodedSignature(byArray, collection::contains);
    }

    protected Map.Entry extractEncodedSignature(byte[] byArray, Predicate predicate) {
        int n2 = NumberUtils.length(byArray);
        if (n2 < 8) {
            return null;
        }
        long l2 = BufferUtils.getUInt(byArray, 0, n2);
        if (l2 >= (long)(n2 - 4)) {
            return null;
        }
        int n3 = 4;
        int n4 = n3 + (int)l2;
        int n5 = n2 - n4;
        if (n5 < 4) {
            return null;
        }
        long l3 = BufferUtils.getUInt(byArray, n4, n5);
        if (l3 > (long)(n5 - 4)) {
            return null;
        }
        String string = new String(byArray, n3, (int)l2, StandardCharsets.UTF_8);
        if (!predicate.test(string)) {
            return null;
        }
        byte[] byArray2 = new byte[(int)l3];
        System.arraycopy(byArray, n4 + 4, byArray2, 0, (int)l3);
        return new AbstractMap.SimpleImmutableEntry<String, byte[]>(string, byArray2);
    }

    protected boolean doVerify(byte[] byArray) {
        java.security.Signature signature = Objects.requireNonNull(this.getSignature(), "Signature not initialized");
        return signature.verify(byArray);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAlgorithm() + "]";
    }
}

