/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractSecurityKeySignature
implements Signature {
    private static final int FLAG_USER_PRESENCE = 1;
    private final String keyType;
    private SecurityKeyPublicKey publicKey;
    private MessageDigest challengeDigest;

    protected AbstractSecurityKeySignature(String string) {
        this.keyType = string;
    }

    @Override
    public void initVerifier(SessionContext sessionContext, PublicKey publicKey) {
        if (!(publicKey instanceof SecurityKeyPublicKey)) {
            throw new IllegalArgumentException("Only instances of SecurityKeyPublicKey can be used");
        }
        this.publicKey = (SecurityKeyPublicKey)publicKey;
        this.challengeDigest = SecurityUtils.getMessageDigest("SHA-256");
    }

    @Override
    public void update(SessionContext sessionContext, byte[] byArray, int n2, int n3) {
        if (this.challengeDigest == null) {
            throw new IllegalStateException("initVerifier must be called before update");
        }
        this.challengeDigest.update(byArray, n2, n3);
    }

    protected abstract String getSignatureKeyType();

    protected abstract Signature getDelegateSignature();

    @Override
    public boolean verify(SessionContext sessionContext, byte[] byArray) {
        if (this.challengeDigest == null) {
            throw new IllegalStateException("initVerifier must be called before verify");
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(byArray);
        String string = byteArrayBuffer.getString();
        if (!this.keyType.equals(string)) {
            return false;
        }
        byte[] byArray2 = byteArrayBuffer.getBytes();
        byte by = byteArrayBuffer.getByte();
        long l2 = byteArrayBuffer.getUInt();
        if ((by & 0xFFFFFFFE) != 0) {
            return false;
        }
        if ((by & 1) != 1 && !this.publicKey.isNoTouchRequired()) {
            return false;
        }
        ByteArrayBuffer byteArrayBuffer2 = new ByteArrayBuffer();
        byteArrayBuffer2.putString(this.getSignatureKeyType());
        byteArrayBuffer2.putBytes(byArray2);
        MessageDigest messageDigest = SecurityUtils.getMessageDigest("SHA-256");
        byte[] byArray3 = messageDigest.digest(this.publicKey.getAppName().getBytes(StandardCharsets.UTF_8));
        byte[] byArray4 = this.challengeDigest.digest();
        ByteArrayBuffer byteArrayBuffer3 = new ByteArrayBuffer(4, false);
        byteArrayBuffer3.putUInt(l2);
        Signature signature = this.getDelegateSignature();
        signature.initVerifier(sessionContext, this.publicKey.getDelegatePublicKey());
        signature.update(sessionContext, byArray3);
        signature.update(sessionContext, new byte[]{by});
        signature.update(sessionContext, byteArrayBuffer3.getCompactData());
        signature.update(sessionContext, byArray4);
        return signature.verify(sessionContext, byteArrayBuffer2.getCompactData());
    }

    @Override
    public void initSigner(SessionContext sessionContext, PrivateKey privateKey) {
        throw new UnsupportedOperationException("Security key private key signatures are unsupported.");
    }

    @Override
    public byte[] sign(SessionContext sessionContext) {
        throw new UnsupportedOperationException("Security key private key signatures are unsupported.");
    }
}

