/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.helpers.SessionHelper;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class SessionTimeoutListener
extends AbstractLoggingBean
implements Runnable,
SessionListener {
    protected final Set sessions = new CopyOnWriteArraySet();

    @Override
    public void sessionCreated(Session session) {
        if (session instanceof SessionHelper && (GenericUtils.isPositive(session.getAuthTimeout()) || GenericUtils.isPositive(session.getIdleTimeout()))) {
            this.sessions.add((SessionHelper)session);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionCreated({}) tracking", (Object)session);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("sessionCreated({}) not tracked", (Object)session);
        }
    }

    @Override
    public void sessionException(Session session, Throwable throwable) {
        this.debug("sessionException({}) {}: {}", session, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
        this.sessionClosed(session);
    }

    @Override
    public void sessionClosed(Session session) {
        if (this.sessions.remove(session)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionClosed({}) un-tracked", (Object)session);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("sessionClosed({}) not tracked", (Object)session);
        }
    }

    @Override
    public void run() {
        for (SessionHelper sessionHelper : this.sessions) {
            try {
                sessionHelper.checkForTimeouts();
            }
            catch (Exception exception) {
                this.warn("run({}) {} while checking timeouts: {}", sessionHelper, exception.getClass().getSimpleName(), exception.getMessage(), exception);
            }
        }
    }
}

