/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolver;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.AbstractKexFactoryManager;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.SessionListener$Event;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.session.helpers.ReservedSessionMessagesHandlerAdapter;
import org.apache.sshd.common.session.helpers.TimeoutIndicator;
import org.apache.sshd.common.session.helpers.TimeoutIndicator$TimeoutStatus;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable$State;
import org.apache.sshd.common.util.io.functors.Invoker;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class SessionHelper
extends AbstractKexFactoryManager
implements Session {
    protected Instant authStart = Instant.now();
    protected Instant idleStart = Instant.now();
    protected Map initialKexProposal;
    private final boolean serverSession;
    private final IoSession ioSession;
    private final Map properties = new ConcurrentHashMap();
    private final Map attributes = new ConcurrentHashMap();
    private final AtomicReference timeoutStatus = new AtomicReference<TimeoutIndicator>(TimeoutIndicator.NONE);
    private ReservedSessionMessagesHandler reservedSessionMessagesHandler;
    private SessionDisconnectHandler sessionDisconnectHandler;
    private UnknownChannelReferenceHandler unknownChannelReferenceHandler;
    private ChannelStreamWriterResolver channelStreamPacketWriterResolver;
    private volatile String username;
    private volatile boolean authed;

    protected SessionHelper(boolean bl2, FactoryManager factoryManager, IoSession ioSession) {
        super(Objects.requireNonNull(factoryManager, "No factory manager provided"));
        this.serverSession = bl2;
        this.ioSession = Objects.requireNonNull(ioSession, "No IoSession provided");
    }

    @Override
    public IoSession getIoSession() {
        return this.ioSession;
    }

    @Override
    public boolean isServerSession() {
        return this.serverSession;
    }

    @Override
    public FactoryManager getFactoryManager() {
        return (FactoryManager)this.getDelegate();
    }

    @Override
    public PropertyResolver getParentPropertyResolver() {
        return this.getFactoryManager();
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.size();
    }

    @Override
    public Object getAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        return this.attributes.get(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"));
    }

    @Override
    public Collection attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    @Override
    public Object computeAttributeIfAbsent(AttributeRepository$AttributeKey attributeRepository$AttributeKey, Function function) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"), function);
    }

    @Override
    public Object setAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey, Object object) {
        return this.attributes.put(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"), Objects.requireNonNull(object, "No value"));
    }

    @Override
    public Object removeAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        return this.attributes.remove(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"));
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String string) {
        this.username = string;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authed;
    }

    @Override
    public void setAuthenticated() {
        this.authed = true;
        try {
            this.signalSessionEvent(SessionListener$Event.Authenticated);
        }
        catch (Exception exception) {
            ExceptionUtils.rethrowAsIoException(exception);
        }
    }

    protected TimeoutIndicator checkForTimeouts() {
        TimeoutIndicator$TimeoutStatus timeoutIndicator$TimeoutStatus;
        boolean bl2 = this.log.isDebugEnabled();
        if (!this.isOpen() || this.isClosing() || this.isClosed()) {
            if (bl2) {
                this.log.debug("checkForTimeouts({}) session closing", (Object)this);
            }
            return TimeoutIndicator.NONE;
        }
        TimeoutIndicator timeoutIndicator = (TimeoutIndicator)this.timeoutStatus.get();
        TimeoutIndicator$TimeoutStatus timeoutIndicator$TimeoutStatus2 = timeoutIndicator$TimeoutStatus = timeoutIndicator == null ? TimeoutIndicator$TimeoutStatus.NoTimeout : timeoutIndicator.getStatus();
        if (timeoutIndicator$TimeoutStatus != null && timeoutIndicator$TimeoutStatus != TimeoutIndicator$TimeoutStatus.NoTimeout) {
            if (bl2) {
                this.log.debug("checkForTimeouts({}) already detected {}", (Object)this, (Object)timeoutIndicator);
            }
            return timeoutIndicator;
        }
        Instant instant = Instant.now();
        timeoutIndicator = this.checkAuthenticationTimeout(instant, this.getAuthTimeout());
        if (timeoutIndicator == null) {
            timeoutIndicator = this.checkIdleTimeout(instant, this.getIdleTimeout());
        }
        TimeoutIndicator$TimeoutStatus timeoutIndicator$TimeoutStatus3 = timeoutIndicator$TimeoutStatus = timeoutIndicator == null ? TimeoutIndicator$TimeoutStatus.NoTimeout : timeoutIndicator.getStatus();
        if (timeoutIndicator$TimeoutStatus == null || TimeoutIndicator$TimeoutStatus.NoTimeout.equals((Object)timeoutIndicator$TimeoutStatus)) {
            return TimeoutIndicator.NONE;
        }
        boolean bl3 = false;
        try {
            SessionDisconnectHandler sessionDisconnectHandler = this.getSessionDisconnectHandler();
            bl3 = sessionDisconnectHandler != null && sessionDisconnectHandler.handleTimeoutDisconnectReason(this, timeoutIndicator);
        }
        catch (IOException | RuntimeException exception) {
            this.warn("checkForTimeouts({}) failed ({}) to invoke disconnect handler to handle {}: {}", this, exception.getClass().getSimpleName(), timeoutIndicator, exception.getMessage(), exception);
        }
        if (bl3) {
            if (bl2) {
                this.log.debug("checkForTimeouts({}) cancel {} due to handler intervention", (Object)this, (Object)timeoutIndicator);
            }
            switch (timeoutIndicator$TimeoutStatus) {
                case AuthTimeout: {
                    this.resetAuthTimeout();
                    break;
                }
                case IdleTimeout: {
                    this.resetIdleTimeout();
                    break;
                }
            }
            return TimeoutIndicator.NONE;
        }
        if (bl2) {
            this.log.debug("checkForTimeouts({}) disconnect - reason={}", (Object)this, (Object)timeoutIndicator);
        }
        this.timeoutStatus.set(timeoutIndicator);
        this.disconnect(2, "Detected " + (Object)((Object)timeoutIndicator$TimeoutStatus) + " after " + TimeoutIndicator.toDisplayDurationValue(timeoutIndicator.getExpiredValue()) + "/" + TimeoutIndicator.toDisplayDurationValue(timeoutIndicator.getThresholdValue()) + " ms.");
        return timeoutIndicator;
    }

    @Override
    public Instant getAuthTimeoutStart() {
        return this.authStart;
    }

    @Override
    public Instant resetAuthTimeout() {
        Instant instant = this.getAuthTimeoutStart();
        this.authStart = Instant.now();
        return instant;
    }

    protected TimeoutIndicator checkAuthenticationTimeout(Instant instant, Duration duration) {
        Duration duration2 = Duration.between(this.authStart, instant);
        if (!this.isAuthenticated() && GenericUtils.isPositive(duration) && duration2.compareTo(duration) > 0) {
            return new TimeoutIndicator(TimeoutIndicator$TimeoutStatus.AuthTimeout, duration, duration2);
        }
        return null;
    }

    @Override
    public Instant getIdleTimeoutStart() {
        return this.idleStart;
    }

    protected TimeoutIndicator checkIdleTimeout(Instant instant, Duration duration) {
        Duration duration2 = Duration.between(this.idleStart, instant);
        if (this.isAuthenticated() && GenericUtils.isPositive(duration) && duration2.compareTo(duration) > 0) {
            return new TimeoutIndicator(TimeoutIndicator$TimeoutStatus.IdleTimeout, duration, duration2);
        }
        return null;
    }

    @Override
    public Instant resetIdleTimeout() {
        Instant instant = this.getIdleTimeoutStart();
        this.idleStart = Instant.now();
        return instant;
    }

    @Override
    public TimeoutIndicator getTimeoutStatus() {
        return (TimeoutIndicator)this.timeoutStatus.get();
    }

    @Override
    public ReservedSessionMessagesHandler getReservedSessionMessagesHandler() {
        return (ReservedSessionMessagesHandler)this.resolveEffectiveProvider(ReservedSessionMessagesHandler.class, this.reservedSessionMessagesHandler, this.getFactoryManager().getReservedSessionMessagesHandler());
    }

    @Override
    public void setReservedSessionMessagesHandler(ReservedSessionMessagesHandler reservedSessionMessagesHandler) {
        this.reservedSessionMessagesHandler = reservedSessionMessagesHandler;
    }

    @Override
    public SessionDisconnectHandler getSessionDisconnectHandler() {
        return (SessionDisconnectHandler)this.resolveEffectiveProvider(SessionDisconnectHandler.class, this.sessionDisconnectHandler, this.getFactoryManager().getSessionDisconnectHandler());
    }

    @Override
    public void setSessionDisconnectHandler(SessionDisconnectHandler sessionDisconnectHandler) {
        this.sessionDisconnectHandler = sessionDisconnectHandler;
    }

    protected void handleIgnore(Buffer buffer) {
        if (!buffer.isValidMessageStructure(byte[].class)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleIgnore({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        this.doInvokeIgnoreMessageHandler(buffer);
    }

    protected void doInvokeIgnoreMessageHandler(Buffer buffer) {
        ReservedSessionMessagesHandler reservedSessionMessagesHandler = this.resolveReservedSessionMessagesHandler();
        reservedSessionMessagesHandler.handleIgnoreMessage(this, buffer);
    }

    protected IoWriteFuture sendNotImplemented(long l2) {
        Buffer buffer = this.createBuffer((byte)3, 8);
        buffer.putUInt(l2);
        return this.writePacket(buffer);
    }

    protected void handleUnimplemented(Buffer buffer) {
        if (!buffer.isValidMessageStructure(Integer.TYPE)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleUnimplemented({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        this.doInvokeUnimplementedMessageHandler(3, buffer);
    }

    protected boolean doInvokeUnimplementedMessageHandler(int n2, Buffer buffer) {
        ReservedSessionMessagesHandler reservedSessionMessagesHandler = this.resolveReservedSessionMessagesHandler();
        return reservedSessionMessagesHandler.handleUnimplementedMessage(this, n2, buffer);
    }

    @Override
    public IoWriteFuture sendDebugMessage(boolean bl2, Object object, String string) {
        String string2 = Objects.toString(object, "");
        string = string == null ? "" : string;
        Buffer buffer = this.createBuffer((byte)4, string2.length() + string.length() + 32);
        buffer.putBoolean(bl2);
        buffer.putString(string2);
        buffer.putString(string);
        return this.writePacket(buffer);
    }

    protected void handleDebug(Buffer buffer) {
        if (!buffer.isValidMessageStructure(Boolean.TYPE, String.class, String.class)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleDebug({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        this.doInvokeDebugMessageHandler(buffer);
    }

    protected void doInvokeDebugMessageHandler(Buffer buffer) {
        ReservedSessionMessagesHandler reservedSessionMessagesHandler = this.resolveReservedSessionMessagesHandler();
        reservedSessionMessagesHandler.handleDebugMessage(this, buffer);
    }

    protected ReservedSessionMessagesHandler resolveReservedSessionMessagesHandler() {
        ReservedSessionMessagesHandler reservedSessionMessagesHandler = this.getReservedSessionMessagesHandler();
        return reservedSessionMessagesHandler == null ? ReservedSessionMessagesHandlerAdapter.DEFAULT : reservedSessionMessagesHandler;
    }

    @Override
    public UnknownChannelReferenceHandler getUnknownChannelReferenceHandler() {
        return this.unknownChannelReferenceHandler;
    }

    @Override
    public void setUnknownChannelReferenceHandler(UnknownChannelReferenceHandler unknownChannelReferenceHandler) {
        this.unknownChannelReferenceHandler = unknownChannelReferenceHandler;
    }

    @Override
    public UnknownChannelReferenceHandler resolveUnknownChannelReferenceHandler() {
        UnknownChannelReferenceHandler unknownChannelReferenceHandler = this.getUnknownChannelReferenceHandler();
        if (unknownChannelReferenceHandler != null) {
            return unknownChannelReferenceHandler;
        }
        FactoryManager factoryManager = this.getFactoryManager();
        return factoryManager == null ? null : factoryManager.resolveUnknownChannelReferenceHandler();
    }

    @Override
    public ChannelStreamWriterResolver getChannelStreamWriterResolver() {
        return this.channelStreamPacketWriterResolver;
    }

    @Override
    public void setChannelStreamWriterResolver(ChannelStreamWriterResolver channelStreamWriterResolver) {
        this.channelStreamPacketWriterResolver = channelStreamWriterResolver;
    }

    @Override
    public ChannelStreamWriterResolver resolveChannelStreamWriterResolver() {
        ChannelStreamWriterResolver channelStreamWriterResolver = this.getChannelStreamWriterResolver();
        if (channelStreamWriterResolver != null) {
            return channelStreamWriterResolver;
        }
        FactoryManager factoryManager = this.getFactoryManager();
        return factoryManager.resolveChannelStreamWriterResolver();
    }

    @Override
    public IoWriteFuture sendIgnoreMessage(byte ... byArray) {
        byArray = byArray == null ? GenericUtils.EMPTY_BYTE_ARRAY : byArray;
        Buffer buffer = this.createBuffer((byte)2, byArray.length + 8);
        buffer.putBytes(byArray);
        return this.writePacket(buffer);
    }

    protected void signalSessionEstablished(IoSession ioSession) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalSessionEstablished((SessionListener)sessionListener);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            this.debug("Failed ({}) to announce session={} established: {}", throwable2.getClass().getSimpleName(), ioSession, throwable2.getMessage(), throwable2);
            if (throwable2 instanceof Exception) {
                throw (Exception)throwable2;
            }
            throw new RuntimeSshException(throwable2);
        }
    }

    protected void signalSessionEstablished(SessionListener sessionListener) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionEstablished(this);
    }

    protected void signalSessionCreated(IoSession ioSession) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalSessionCreated((SessionListener)sessionListener);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            this.debug("Failed ({}) to announce session={} created: {}", throwable2.getClass().getSimpleName(), ioSession, throwable2.getMessage(), throwable2);
            if (throwable2 instanceof Exception) {
                throw (Exception)throwable2;
            }
            throw new RuntimeSshException(throwable2);
        }
    }

    protected void signalSessionCreated(SessionListener sessionListener) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionCreated(this);
    }

    protected void signalSendIdentification(String string, List list) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalSendIdentification((SessionListener)sessionListener, string, list);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            if (throwable2 instanceof Exception) {
                throw (Exception)throwable2;
            }
            throw new RuntimeSshException(throwable2);
        }
    }

    protected void signalSendIdentification(SessionListener sessionListener, String string, List list) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionPeerIdentificationSend(this, string, list);
    }

    protected void signalReadPeerIdentificationLine(String string, List list) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalReadPeerIdentificationLine((SessionListener)sessionListener, string, list);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            this.debug("signalReadPeerIdentificationLine({}) Failed ({}) to announce peer={}: {}", this, throwable2.getClass().getSimpleName(), string, throwable2.getMessage(), throwable2);
            if (throwable2 instanceof Exception) {
                throw (Exception)throwable2;
            }
            throw new RuntimeSshException(throwable2);
        }
    }

    protected void signalReadPeerIdentificationLine(SessionListener sessionListener, String string, List list) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionPeerIdentificationLine(this, string, list);
    }

    protected void signalPeerIdentificationReceived(String string, List list) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalPeerIdentificationReceived((SessionListener)sessionListener, string, list);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            this.debug("signalPeerIdentificationReceived({}) Failed ({}) to announce peer={}: {}", this, throwable2.getClass().getSimpleName(), string, throwable2.getMessage(), throwable2);
            if (throwable2 instanceof Exception) {
                throw (Exception)throwable2;
            }
            throw new RuntimeSshException(throwable2);
        }
    }

    protected void signalPeerIdentificationReceived(SessionListener sessionListener, String string, List list) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionPeerIdentificationReceived(this, string, list);
    }

    protected void signalSessionEvent(SessionListener$Event sessionListener$Event) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalSessionEvent((SessionListener)sessionListener, sessionListener$Event);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            this.debug("sendSessionEvent({})[{}] failed ({}) to inform listeners: {}", this, (Object)sessionListener$Event, throwable2.getClass().getSimpleName(), throwable2.getMessage(), throwable2);
            if (throwable2 instanceof Exception) {
                throw (Exception)throwable2;
            }
            throw new RuntimeSshException(throwable2);
        }
    }

    protected void signalSessionEvent(SessionListener sessionListener, SessionListener$Event sessionListener$Event) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionEvent(this, sessionListener$Event);
    }

    protected void invokeSessionSignaller(Invoker invoker) {
        FactoryManager factoryManager = this.getFactoryManager();
        SessionListener[] sessionListenerArray = new SessionListener[]{factoryManager == null ? null : factoryManager.getSessionListenerProxy(), this.getSessionListenerProxy()};
        Throwable throwable = null;
        for (SessionListener sessionListener : sessionListenerArray) {
            if (sessionListener == null) continue;
            try {
                invoker.invoke(sessionListener);
            }
            catch (Throwable throwable2) {
                throwable = ExceptionUtils.accumulateException(throwable, throwable2);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    protected byte[] resizeKey(byte[] byArray, int n2, Digest digest, byte[] byArray2, byte[] byArray3) {
        Buffer buffer = null;
        while (n2 > byArray.length) {
            if (buffer == null) {
                buffer = new ByteArrayBuffer();
            }
            buffer.putMPInt(byArray2);
            buffer.putRawBytes(byArray3);
            buffer.putRawBytes(byArray);
            digest.update(buffer.array(), 0, buffer.available());
            byte[] byArray4 = digest.digest();
            byte[] byArray5 = new byte[byArray.length + byArray4.length];
            System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
            System.arraycopy(byArray4, 0, byArray5, byArray.length, byArray4.length);
            byArray = byArray5;
            buffer = BufferUtils.clear(buffer);
        }
        return byArray;
    }

    protected SocketAddress resolvePeerAddress(SocketAddress socketAddress) {
        if (socketAddress != null) {
            return socketAddress;
        }
        IoSession ioSession = this.getIoSession();
        return ioSession == null ? null : ioSession.getRemoteAddress();
    }

    protected long calculateNextIgnorePacketCount(Random random, long l2, int n2) {
        long l3;
        if (l2 <= 0L || n2 < 0) {
            return -1L;
        }
        if (n2 == 0) {
            return l2;
        }
        int n3 = random.random(n2 < 0 ? 0 - n2 : n2);
        long l4 = l3 = n2 < 0 ? l2 - (long)n3 : l2 + (long)n3;
        if (this.log.isTraceEnabled()) {
            this.log.trace("calculateNextIgnorePacketCount({}) count={}", (Object)this, (Object)l3);
        }
        return l3;
    }

    protected String resolveIdentificationString(String string) {
        FactoryManager factoryManager = this.getFactoryManager();
        String string2 = factoryManager.getString(string);
        return "SSH-2.0-" + (GenericUtils.isEmpty(string2) ? factoryManager.getVersion() : string2);
    }

    protected IoWriteFuture sendIdentification(String string, List list) {
        ReservedSessionMessagesHandler reservedSessionMessagesHandler = this.getReservedSessionMessagesHandler();
        IoWriteFuture ioWriteFuture = reservedSessionMessagesHandler == null ? null : reservedSessionMessagesHandler.sendIdentification(this, string, list);
        boolean bl2 = this.log.isDebugEnabled();
        if (ioWriteFuture != null) {
            if (bl2) {
                this.log.debug("sendIdentification({})[{}] sent {} lines via reserved handler", new Object[]{this, string, GenericUtils.size(list)});
            }
            return ioWriteFuture;
        }
        String string2 = string;
        if (GenericUtils.size(list) > 0) {
            string2 = GenericUtils.join((Iterable)list, (CharSequence)"\r\n") + "\r\n" + string;
        }
        if (bl2) {
            this.log.debug("sendIdentification({}): {}", (Object)this, (Object)string2.replace('\r', '|').replace('\n', '|'));
        }
        IoSession ioSession = this.getIoSession();
        byte[] byArray = (string2 + "\r\n").getBytes(StandardCharsets.UTF_8);
        return ioSession.writeBuffer(new ByteArrayBuffer(byArray));
    }

    protected List doReadIdentification(Buffer buffer, boolean bl2) {
        int n2 = (Integer)CoreModuleProperties.MAX_IDENTIFICATION_SIZE.getRequired(this);
        ArrayList<String> arrayList = null;
        int n3 = buffer.rpos();
        boolean bl3 = this.log.isDebugEnabled();
        byte[] byArray = new byte[256];
        do {
            int n4 = 0;
            boolean bl4 = false;
            while (true) {
                if (buffer.available() == 0) {
                    buffer.rpos(n3);
                    return null;
                }
                byte by = buffer.getByte();
                if (by == 0) {
                    throw new StreamCorruptedException("Incorrect identification (null characters not allowed) -  at line " + (GenericUtils.size(arrayList) + 1) + " character #" + (n4 + 1) + " after '" + new String(byArray, 0, n4, StandardCharsets.UTF_8) + "'");
                }
                if (by == 13) {
                    bl4 = true;
                    continue;
                }
                if (by == 10) break;
                if (bl4) {
                    throw new StreamCorruptedException("Incorrect identification (bad line ending)  at line " + (GenericUtils.size(arrayList) + 1) + ": " + new String(byArray, 0, n4, StandardCharsets.UTF_8));
                }
                if (n4 >= byArray.length) {
                    throw new StreamCorruptedException("Incorrect identification (line too long):  at line " + (GenericUtils.size(arrayList) + 1) + ": " + new String(byArray, 0, n4, StandardCharsets.UTF_8));
                }
                byArray[n4++] = by;
            }
            String string = new String(byArray, 0, n4, StandardCharsets.UTF_8);
            if (bl3) {
                this.log.debug("doReadIdentification({}) line='{}'", (Object)this, (Object)string);
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            this.signalReadPeerIdentificationLine(string, arrayList);
            arrayList.add(string);
            if (!bl2 && !string.startsWith("SSH-")) continue;
            return arrayList;
        } while (buffer.rpos() <= n2);
        throw new StreamCorruptedException("Incorrect identification (too many header lines): size > " + n2);
    }

    protected String resolveSessionKexProposal(String string) {
        return NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getKeyExchangeFactories(), "No KEX factories", new Object[0]));
    }

    protected String resolveAvailableSignaturesProposal() {
        return this.resolveAvailableSignaturesProposal(this.getFactoryManager());
    }

    protected abstract String resolveAvailableSignaturesProposal(FactoryManager var1);

    protected Map getKexProposal() {
        if (this.initialKexProposal == null) {
            String string = this.resolveAvailableSignaturesProposal();
            if (GenericUtils.isEmpty(string)) {
                throw new SshException(9, "getKexProposal() no resolved signatures available");
            }
            Map map = this.createProposal(string);
            KexExtensionHandler kexExtensionHandler = this.getKexExtensionHandler();
            boolean bl2 = this.log.isTraceEnabled();
            if (kexExtensionHandler != null) {
                if (bl2) {
                    this.log.trace("getKexProposal({}) options before handler: {}", (Object)this, (Object)map);
                }
                kexExtensionHandler.handleKexInitProposal(this, true, map);
                if (bl2) {
                    this.log.trace("getKexProposal({}) options after handler: {}", (Object)this, (Object)map);
                }
            }
            this.signalNegotiationOptionsCreated(map);
            this.initialKexProposal = new EnumMap(map);
        }
        return this.initialKexProposal;
    }

    protected Map createProposal(String string) {
        EnumMap<KexProposalOption, String> enumMap = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        String string2 = this.resolveSessionKexProposal(string);
        enumMap.put(KexProposalOption.ALGORITHMS, string2);
        enumMap.put(KexProposalOption.SERVERKEYS, string);
        String string3 = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getCipherFactories(), "No cipher factories", new Object[0]));
        enumMap.put(KexProposalOption.S2CENC, string3);
        enumMap.put(KexProposalOption.C2SENC, string3);
        String string4 = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getMacFactories(), "No MAC factories", new Object[0]));
        enumMap.put(KexProposalOption.S2CMAC, string4);
        enumMap.put(KexProposalOption.C2SMAC, string4);
        String string5 = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getCompressionFactories(), "No compression factories", new Object[0]));
        enumMap.put(KexProposalOption.S2CCOMP, string5);
        enumMap.put(KexProposalOption.C2SCOMP, string5);
        enumMap.put(KexProposalOption.S2CLANG, "");
        enumMap.put(KexProposalOption.C2SLANG, "");
        return enumMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map mergeProposals(Map map, Map map2) {
        if (map == map2) {
            return map2;
        }
        Map map3 = map;
        synchronized (map3) {
            if (!map.isEmpty()) {
                map.clear();
            }
            if (MapEntryUtils.isEmpty(map2)) {
                return map2;
            }
            map.putAll(map2);
        }
        return map2;
    }

    protected void signalNegotiationOptionsCreated(Map map) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalNegotiationOptionsCreated((SessionListener)sessionListener, map);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            throw new IllegalArgumentException(throwable2);
        }
    }

    protected void signalNegotiationOptionsCreated(SessionListener sessionListener, Map map) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionNegotiationOptionsCreated(this, map);
    }

    protected void signalNegotiationStart(Map map, Map map2) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalNegotiationStart((SessionListener)sessionListener, map, map2);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            throw new IllegalArgumentException(throwable2);
        }
    }

    protected void signalNegotiationStart(SessionListener sessionListener, Map map, Map map2) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionNegotiationStart(this, map, map2);
    }

    protected void signalNegotiationEnd(Map map, Map map2, Map map3, Throwable throwable) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalNegotiationEnd((SessionListener)sessionListener, map, map2, map3, throwable);
                return null;
            });
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = ExceptionUtils.peelException(throwable2);
            if (throwable3 instanceof RuntimeException) {
                throw (RuntimeException)throwable3;
            }
            if (throwable3 instanceof Error) {
                throw (Error)throwable3;
            }
            throw new IllegalArgumentException(throwable3);
        }
    }

    protected void signalNegotiationEnd(SessionListener sessionListener, Map map, Map map2, Map map3, Throwable throwable) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionNegotiationEnd(this, map, map2, map3, null);
    }

    protected Buffer preProcessEncodeBuffer(int n2, Buffer buffer) {
        int n3 = buffer.rpos();
        if (n3 >= 5) {
            return buffer;
        }
        this.log.warn("preProcessEncodeBuffer({}) command={}[{}] performance cost: available buffer packet header length ({}) below min. required ({})", new Object[]{this, n2, SshConstants.getCommandMessageName(n2), n3, 5});
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(buffer.available() + 64, false);
        ((Buffer)byteArrayBuffer).wpos(5);
        byteArrayBuffer.putBuffer(buffer);
        return byteArrayBuffer;
    }

    @Override
    public void disconnect(int n2, String string) {
        this.log.info("Disconnecting({}): {} - {}", new Object[]{this, SshConstants.getDisconnectReasonName(n2), string});
        String string2 = "";
        this.signalDisconnect(n2, string, string2, true);
        Buffer buffer = this.createBuffer((byte)1, string.length() + 16);
        buffer.putInt(n2);
        buffer.putString(string);
        buffer.putString("");
        Duration duration = (Duration)CoreModuleProperties.DISCONNECT_TIMEOUT.getRequired(this);
        IoWriteFuture ioWriteFuture2 = this.writePacket(buffer, duration);
        ioWriteFuture2.addListener(ioWriteFuture -> {
            Throwable throwable = ioWriteFuture.getException();
            boolean bl2 = this.log.isDebugEnabled();
            if (throwable == null) {
                if (bl2) {
                    this.log.debug("disconnect({}) operation successfully completed for reason={} [{}]", new Object[]{this, SshConstants.getDisconnectReasonName(n2), string});
                }
            } else if (bl2) {
                this.debug("disconnect({}) operation failed ({}) for reason={} [{}]: {}", this, throwable.getClass().getSimpleName(), SshConstants.getDisconnectReasonName(n2), string, throwable.getMessage(), throwable);
            }
            this.close(true);
        });
    }

    protected void handleDisconnect(Buffer buffer) {
        int n2 = buffer.getInt();
        String string = buffer.getString();
        String string2 = buffer.available() > 0 ? buffer.getString() : "";
        this.handleDisconnect(n2, string, string2, buffer);
    }

    protected void handleDisconnect(int n2, String string, String string2, Buffer buffer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleDisconnect({}) SSH_MSG_DISCONNECT reason={}, [lang={}] msg={}", new Object[]{this, SshConstants.getDisconnectReasonName(n2), string2, string});
        }
        this.signalDisconnect(n2, string, string2, false);
        this.close(true);
    }

    protected void signalDisconnect(int n2, String string, String string2, boolean bl2) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalDisconnect((SessionListener)sessionListener, n2, string, string2, bl2);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            this.debug("signalDisconnect({}) {}: {}", this, throwable2.getClass().getSimpleName(), throwable2.getMessage(), throwable2);
        }
    }

    protected void signalDisconnect(SessionListener sessionListener, int n2, String string, String string2, boolean bl2) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionDisconnect(this, n2, string, string2, bl2);
    }

    @Override
    public void exceptionCaught(Throwable throwable) {
        int n2;
        AbstractCloseable$State abstractCloseable$State = (AbstractCloseable$State)((Object)this.state.get());
        if (!AbstractCloseable$State.Opened.equals((Object)abstractCloseable$State) && !AbstractCloseable$State.Graceful.equals((Object)abstractCloseable$State)) {
            this.debug("exceptionCaught({}) ignore {} due to state={}, message='{}'", this, throwable.getClass().getSimpleName(), (Object)abstractCloseable$State, throwable.getMessage(), throwable);
            return;
        }
        this.warn("exceptionCaught({})[state={}] {}: {}", this, (Object)abstractCloseable$State, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
        this.signalExceptionCaught(throwable);
        if (AbstractCloseable$State.Opened.equals((Object)abstractCloseable$State) && throwable instanceof SshException && (n2 = ((SshException)throwable).getDisconnectCode()) > 0) {
            try {
                this.disconnect(n2, throwable.getMessage());
            }
            catch (Throwable throwable2) {
                this.debug("exceptionCaught({}) {} while disconnect with code={}: {}", this, throwable2.getClass().getSimpleName(), SshConstants.getDisconnectReasonName(n2), throwable2.getMessage(), throwable2);
            }
            return;
        }
        this.close(true);
    }

    protected void signalExceptionCaught(Throwable throwable) {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalExceptionCaught((SessionListener)sessionListener, throwable);
                return null;
            });
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = ExceptionUtils.peelException(throwable2);
            this.debug("signalExceptionCaught({}) {}: {}", this, throwable3.getClass().getSimpleName(), throwable3.getMessage(), throwable3);
        }
    }

    protected void signalExceptionCaught(SessionListener sessionListener, Throwable throwable) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionException(this, throwable);
    }

    protected void signalSessionClosed() {
        try {
            this.invokeSessionSignaller(sessionListener -> {
                this.signalSessionClosed((SessionListener)sessionListener);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            this.debug("signalSessionClosed({}) {} while signal session closed: {}", this, throwable2.getClass().getSimpleName(), throwable2.getMessage(), throwable2);
        }
    }

    protected void signalSessionClosed(SessionListener sessionListener) {
        if (sessionListener == null) {
            return;
        }
        sessionListener.sessionClosed(this);
    }

    protected abstract ConnectionService getConnectionService();

    protected Forwarder getForwarder() {
        ConnectionService connectionService = this.getConnectionService();
        return connectionService == null ? null : connectionService.getForwarder();
    }

    @Override
    public List getLocalForwardsBindings() {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyList() : forwarder.getLocalForwardsBindings();
    }

    @Override
    public boolean isLocalPortForwardingStartedForPort(int n2) {
        Forwarder forwarder = this.getForwarder();
        return forwarder != null && forwarder.isLocalPortForwardingStartedForPort(n2);
    }

    @Override
    public List getStartedLocalPortForwards() {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyList() : forwarder.getStartedLocalPortForwards();
    }

    @Override
    public List getBoundLocalPortForwards(int n2) {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyList() : forwarder.getBoundLocalPortForwards(n2);
    }

    @Override
    public List getRemoteForwardsBindings() {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyList() : forwarder.getRemoteForwardsBindings();
    }

    @Override
    public boolean isRemotePortForwardingStartedForPort(int n2) {
        Forwarder forwarder = this.getForwarder();
        return forwarder != null && forwarder.isRemotePortForwardingStartedForPort(n2);
    }

    @Override
    public NavigableSet getStartedRemotePortForwards() {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyNavigableSet() : forwarder.getStartedRemotePortForwards();
    }

    @Override
    public SshdSocketAddress getBoundRemotePortForward(int n2) {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? null : forwarder.getBoundRemotePortForward(n2);
    }

    @Override
    public Duration getAuthTimeout() {
        return (Duration)CoreModuleProperties.AUTH_TIMEOUT.getRequired(this);
    }

    @Override
    public Duration getIdleTimeout() {
        return (Duration)CoreModuleProperties.IDLE_TIMEOUT.getRequired(this);
    }

    public String toString() {
        IoSession ioSession = this.getIoSession();
        SocketAddress socketAddress = ioSession == null ? null : ioSession.getRemoteAddress();
        return this.getClass().getSimpleName() + "[" + this.getUsername() + "@" + socketAddress + "]";
    }
}

