/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.util.List;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ReservedSessionMessagesHandlerAdapter
extends AbstractLoggingBean
implements ReservedSessionMessagesHandler {
    public static final ReservedSessionMessagesHandlerAdapter DEFAULT = new ReservedSessionMessagesHandlerAdapter();

    @Override
    public IoWriteFuture sendIdentification(Session session, String string, List list) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendIdentification({}) version={} linesCount={}", new Object[]{session, string, GenericUtils.size(list)});
        }
        if (this.log.isTraceEnabled() && GenericUtils.isNotEmpty(list)) {
            for (String string2 : list) {
                this.log.trace("sendIdentification({}) {}", (Object)session, (Object)string2);
            }
        }
        return null;
    }

    @Override
    public void handleIgnoreMessage(Session session, Buffer buffer) {
        this.handleIgnoreMessage(session, buffer.getBytes(), buffer);
    }

    public void handleIgnoreMessage(Session session, byte[] byArray, Buffer buffer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleIgnoreMessage({}) SSH_MSG_IGNORE", (Object)session);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleIgnoreMessage({}) data: {}", (Object)session, (Object)BufferUtils.toHex(byArray));
        }
    }

    @Override
    public void handleDebugMessage(Session session, Buffer buffer) {
        this.handleDebugMessage(session, buffer.getBoolean(), buffer.getString(), buffer.getString(), buffer);
    }

    public void handleDebugMessage(Session session, boolean bl2, String string, String string2, Buffer buffer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleDebugMessage({}) SSH_MSG_DEBUG (display={}) [lang={}] '{}'", new Object[]{session, bl2, string2, string});
        }
    }

    @Override
    public boolean handleUnimplementedMessage(Session session, int n2, Buffer buffer) {
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            if (n2 == 3) {
                long l2 = buffer.getUInt();
                this.log.debug("handleUnimplementedMessage({}) SSH_MSG_UNIMPLEMENTED - seqNo={}", (Object)session, (Object)l2);
            } else {
                this.log.debug("handleUnimplementedMessage({}): {}", (Object)session, (Object)SshConstants.getCommandMessageName(n2));
            }
        }
        return false;
    }
}

