/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.util.Objects;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;

public class PendingWriteFuture
extends AbstractIoWriteFuture
implements SshFutureListener {
    private final Buffer buffer;

    public PendingWriteFuture(Object object, Buffer buffer) {
        super(object, null);
        this.buffer = Objects.requireNonNull(buffer, "No buffer provided");
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setWritten() {
        this.setValue(Boolean.TRUE);
    }

    public void setException(Throwable throwable) {
        Objects.requireNonNull(throwable, "No cause specified");
        this.setValue(throwable);
    }

    public void operationComplete(IoWriteFuture ioWriteFuture) {
        if (ioWriteFuture.isWritten()) {
            this.setWritten();
        } else {
            this.setException(ioWriteFuture.getException());
        }
    }
}

