/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.Serializable;
import java.net.ProtocolException;
import java.security.GeneralSecurityException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.DefaultVerifiableSshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.session.helpers.KeyExchangeMessageHandler$1;
import org.apache.sshd.common.session.helpers.KeyExchangeMessageHandler$2;
import org.apache.sshd.common.session.helpers.PendingWriteFuture;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.slf4j.Logger;

public class KeyExchangeMessageHandler {
    protected static ExecutorService flushRunner = ThreadUtils.newCachedThreadPool("kex-flusher");
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    protected final AbstractSession session;
    protected final Logger log;
    protected final Queue pendingPackets = new ConcurrentLinkedQueue();
    protected final AtomicBoolean kexFlushed = new AtomicBoolean(true);
    protected final AtomicBoolean shutDown = new AtomicBoolean();
    protected final AtomicReference kexFlushedFuture = new AtomicReference();

    public KeyExchangeMessageHandler(AbstractSession abstractSession, Logger logger) {
        this.session = Objects.requireNonNull(abstractSession);
        this.log = Objects.requireNonNull(logger);
        DefaultKeyExchangeFuture defaultKeyExchangeFuture = new DefaultKeyExchangeFuture(abstractSession.toString(), abstractSession.getFutureLock());
        defaultKeyExchangeFuture.setValue(Boolean.TRUE);
        this.kexFlushedFuture.set(defaultKeyExchangeFuture);
    }

    public void updateState(Runnable runnable) {
        this.updateState(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object updateState(Supplier supplier) {
        boolean bl2 = false;
        if (this.lock.getReadHoldCount() == 0) {
            this.lock.writeLock().lock();
            bl2 = true;
        }
        try {
            Object t2 = supplier.get();
            return t2;
        }
        finally {
            if (bl2) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public DefaultKeyExchangeFuture initNewKeyExchange() {
        return (DefaultKeyExchangeFuture)this.updateState(() -> {
            this.kexFlushed.set(false);
            return this.kexFlushedFuture.getAndSet(new DefaultKeyExchangeFuture(this.session.toString(), this.session.getFutureLock()));
        });
    }

    public AbstractMap.SimpleImmutableEntry terminateKeyExchange() {
        return (AbstractMap.SimpleImmutableEntry)this.updateState(() -> {
            int n2 = this.pendingPackets.size();
            if (n2 == 0) {
                this.kexFlushed.set(true);
            }
            return new AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture>(n2, (DefaultKeyExchangeFuture)this.kexFlushedFuture.get());
        });
    }

    public void shutdown() {
        this.shutDown.set(true);
        AbstractMap.SimpleImmutableEntry simpleImmutableEntry = (AbstractMap.SimpleImmutableEntry)this.updateState(() -> {
            this.kexFlushed.set(true);
            return new AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture>(this.pendingPackets.size(), (DefaultKeyExchangeFuture)this.kexFlushedFuture.get());
        });
        ((DefaultKeyExchangeFuture)simpleImmutableEntry.getValue()).setValue((Integer)simpleImmutableEntry.getKey() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoWriteFuture writePacket(Buffer buffer, long l2, TimeUnit timeUnit) {
        byte[] byArray = buffer.array();
        int n2 = byArray[buffer.rpos()] & 0xFF;
        boolean bl2 = false;
        boolean bl3 = n2 <= 49 && n2 != 5 && n2 != 6;
        IoWriteFuture ioWriteFuture = null;
        try {
            if (bl3) {
                ioWriteFuture = this.session.doWritePacket(buffer);
            } else {
                ioWriteFuture = this.writeOrEnqueue(n2, buffer, l2, timeUnit);
                bl2 = ioWriteFuture instanceof PendingWriteFuture;
            }
        }
        finally {
            this.session.resetIdleTimeout();
        }
        if (!bl2) {
            try {
                this.session.checkRekey();
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("writePacket({}) failed ({}) to check re-key: {}", new Object[]{this.session, generalSecurityException.getClass().getSimpleName(), generalSecurityException.getMessage(), generalSecurityException});
                }
                throw (ProtocolException)ValidateUtils.initializeExceptionCause(new ProtocolException("Failed (" + generalSecurityException.getClass().getSimpleName() + ") to check re-key necessity: " + generalSecurityException.getMessage()), generalSecurityException);
            }
            catch (Exception exception) {
                ExceptionUtils.rethrowAsIoException(exception);
            }
        }
        return ioWriteFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture writeOrEnqueue(int n2, Buffer buffer, long l2, TimeUnit timeUnit) {
        boolean bl2 = Thread.holdsLock(this.session.getFutureLock());
        while (true) {
            DefaultKeyExchangeFuture defaultKeyExchangeFuture;
            block13: {
                defaultKeyExchangeFuture = null;
                this.lock.readLock().lock();
                try {
                    boolean bl3;
                    if (this.shutDown.get()) {
                        throw new SshException("Write attempt on closing session: " + SshConstants.getCommandMessageName(n2));
                    }
                    KexState kexState = (KexState)((Object)this.session.kexState.get());
                    boolean bl4 = bl3 = KexState.DONE.equals((Object)kexState) || KexState.KEYS.equals((Object)kexState);
                    if (bl3 && this.kexFlushed.get()) {
                        IoWriteFuture ioWriteFuture = this.session.doWritePacket(buffer);
                        return ioWriteFuture;
                    }
                    if (!bl2 && this.isBlockAllowed(n2)) {
                        defaultKeyExchangeFuture = (DefaultKeyExchangeFuture)this.kexFlushedFuture.get();
                        break block13;
                    }
                    if (bl3 && this.log.isDebugEnabled()) {
                        this.log.debug("writeOrEnqueue({})[{}]: Queuing packet while flushing", (Object)this.session, (Object)SshConstants.getCommandMessageName(n2));
                    }
                    PendingWriteFuture pendingWriteFuture = this.enqueuePendingPacket(n2, buffer);
                    return pendingWriteFuture;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            if (defaultKeyExchangeFuture == null) continue;
            if (l2 <= 0L || timeUnit == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("writeOrEnqueue({})[{}]: Blocking thread {} until KEX is over", new Object[]{this.session, SshConstants.getCommandMessageName(n2), Thread.currentThread()});
                }
                defaultKeyExchangeFuture.await();
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("writeOrEnqueue({})[{}]: Blocking thread {} until KEX is over or timeout {} {}", new Object[]{this.session, SshConstants.getCommandMessageName(n2), Thread.currentThread(), l2, timeUnit});
                }
                defaultKeyExchangeFuture.await(l2, timeUnit);
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("writeOrEnqueue({})[{}]: Thread {} awakens after KEX done", new Object[]{this.session, SshConstants.getCommandMessageName(n2), Thread.currentThread()});
        }
    }

    protected boolean isBlockAllowed(int n2) {
        boolean bl2 = n2 == 94 || n2 == 95;
        return bl2 && !ThreadUtils.isInternalThread();
    }

    protected PendingWriteFuture enqueuePendingPacket(int n2, Buffer buffer) {
        String string = SshConstants.getCommandMessageName(n2);
        PendingWriteFuture pendingWriteFuture = new PendingWriteFuture((Object)string, buffer);
        this.pendingPackets.add(pendingWriteFuture);
        int n3 = this.pendingPackets.size();
        if (this.log.isDebugEnabled()) {
            if (n3 == 1) {
                this.log.debug("enqueuePendingPacket({})[{}] Start flagging packets as pending until key exchange is done", (Object)this.session, (Object)string);
            } else {
                this.log.debug("enqueuePendingPacket({})[{}] enqueued until key exchange is done (pending={})", new Object[]{this.session, string, n3});
            }
        }
        return pendingWriteFuture;
    }

    protected void flushQueue(DefaultKeyExchangeFuture defaultKeyExchangeFuture) {
        flushRunner.submit(() -> {
            ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> arrayList = new ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>>();
            boolean bl2 = false;
            DefaultSshFuture defaultSshFuture = null;
            Serializable serializable = null;
            try {
                boolean bl3 = false;
                int n2 = -1;
                int n3 = 2;
                while (!bl2) {
                    this.lock.writeLock().lock();
                    try {
                        PendingWriteFuture pendingWriteFuture;
                        DefaultVerifiableSshFuture defaultVerifiableSshFuture;
                        if (this.pendingPackets.isEmpty()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("flushQueue({}): All packets at end of KEX flushed", (Object)this.session);
                            }
                            this.kexFlushed.set(true);
                            bl2 = true;
                            break;
                        }
                        if (!this.session.isOpen()) {
                            this.log.info("flushQueue({}): Session closed while flushing pending packets at end of KEX", (Object)this.session);
                            defaultVerifiableSshFuture = new KeyExchangeMessageHandler$1(this, this.session, null);
                            defaultVerifiableSshFuture.setValue(new SshException("Session closed while flushing pending packets at end of KEX"));
                            this.drainQueueTo(arrayList, (IoWriteFuture)((Object)defaultVerifiableSshFuture));
                            this.kexFlushed.set(true);
                            serializable = Boolean.FALSE;
                            break;
                        }
                        defaultVerifiableSshFuture = (DefaultKeyExchangeFuture)this.kexFlushedFuture.get();
                        if (defaultVerifiableSshFuture != defaultKeyExchangeFuture) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("flushQueue({}): Stopping flushing pending packets", (Object)this.session);
                            }
                            defaultSshFuture = defaultVerifiableSshFuture;
                            break;
                        }
                        int n4 = this.pendingPackets.size();
                        if (n2 < 0) {
                            this.log.info("flushQueue({}): {} pending packets to flush", (Object)this.session, (Object)n4);
                        } else if (n4 >= n2) {
                            this.log.info("flushQueue({}): queue size before={} now={}", new Object[]{this.session, n2, n4});
                            if (n3 < 64) {
                                n3 *= 2;
                            } else if (!bl3) {
                                bl3 = true;
                                this.log.warn("flushQueue({}): maximum queue flush chunk of 64 reached", (Object)this.session);
                            }
                        }
                        n2 = n4;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("flushQueue({}): flushing {} packets", (Object)this.session, (Object)Math.min(n2, n3));
                        }
                        for (int i2 = 0; i2 < n3 && (pendingWriteFuture = (PendingWriteFuture)this.pendingPackets.poll()) != null; ++i2) {
                            IoWriteFuture ioWriteFuture;
                            try {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace("flushQueue({}): Flushing a packet at end of KEX for {}", (Object)this.session, pendingWriteFuture.getId());
                                }
                                ioWriteFuture = this.session.doWritePacket(pendingWriteFuture.getBuffer());
                            }
                            catch (Throwable throwable) {
                                this.log.error("flushQueue({}): Exception while flushing packet at end of KEX for {}", new Object[]{this.session, pendingWriteFuture.getId(), throwable});
                                KeyExchangeMessageHandler$2 keyExchangeMessageHandler$2 = new KeyExchangeMessageHandler$2(this, pendingWriteFuture.getId(), null);
                                keyExchangeMessageHandler$2.setValue(throwable);
                                arrayList.add(new AbstractMap.SimpleImmutableEntry<PendingWriteFuture, KeyExchangeMessageHandler$2>(pendingWriteFuture, keyExchangeMessageHandler$2));
                                this.drainQueueTo(arrayList, keyExchangeMessageHandler$2);
                                this.kexFlushed.set(true);
                                serializable = throwable;
                                this.lock.writeLock().unlock();
                                if (bl2) {
                                    defaultKeyExchangeFuture.setValue(Boolean.TRUE);
                                } else if (serializable != null) {
                                    defaultKeyExchangeFuture.setValue(serializable);
                                    if (serializable instanceof Throwable) {
                                        this.session.exceptionCaught((Throwable)serializable);
                                    }
                                } else if (defaultSshFuture != null) {
                                    defaultSshFuture.addListener(keyExchangeFuture -> {
                                        Throwable throwable = keyExchangeFuture.getException();
                                        defaultKeyExchangeFuture.setValue(throwable != null ? throwable : Boolean.TRUE);
                                    });
                                }
                                arrayList.forEach(simpleImmutableEntry -> ((IoWriteFuture)simpleImmutableEntry.getValue()).addListener((SshFutureListener)simpleImmutableEntry.getKey()));
                                return;
                            }
                            arrayList.add(new AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>(pendingWriteFuture, ioWriteFuture));
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("flushQueue({}): Flushed a packet at end of KEX for {}", (Object)this.session, pendingWriteFuture.getId());
                            }
                            this.session.resetIdleTimeout();
                        }
                        if (!this.pendingPackets.isEmpty()) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("flushQueue({}): All packets at end of KEX flushed", (Object)this.session);
                        }
                        this.kexFlushed.set(true);
                        bl2 = true;
                        break;
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                }
            }
            finally {
                if (bl2) {
                    defaultKeyExchangeFuture.setValue(Boolean.TRUE);
                } else if (serializable != null) {
                    defaultKeyExchangeFuture.setValue(serializable);
                    if (serializable instanceof Throwable) {
                        this.session.exceptionCaught((Throwable)serializable);
                    }
                } else if (defaultSshFuture != null) {
                    defaultSshFuture.addListener(keyExchangeFuture -> {
                        Throwable throwable = keyExchangeFuture.getException();
                        defaultKeyExchangeFuture.setValue(throwable != null ? throwable : Boolean.TRUE);
                    });
                }
                arrayList.forEach(simpleImmutableEntry -> ((IoWriteFuture)simpleImmutableEntry.getValue()).addListener((SshFutureListener)simpleImmutableEntry.getKey()));
            }
        });
    }

    private void drainQueueTo(List list, IoWriteFuture ioWriteFuture) {
        PendingWriteFuture pendingWriteFuture = (PendingWriteFuture)this.pendingPackets.poll();
        while (pendingWriteFuture != null) {
            list.add(new AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>(pendingWriteFuture, ioWriteFuture));
            pendingWriteFuture = (PendingWriteFuture)this.pendingPackets.poll();
        }
    }
}

