/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.core.CoreModuleProperties;

public class DefaultUnknownChannelReferenceHandler
extends AbstractLoggingBean
implements UnknownChannelReferenceHandler {
    public static final DefaultUnknownChannelReferenceHandler INSTANCE = new DefaultUnknownChannelReferenceHandler();

    @Override
    public Channel handleUnknownChannelCommand(ConnectionService connectionService, byte by, long l2, Buffer buffer) {
        Session session = connectionService.getSession();
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("handleUnknownChannelCommand({}) received {} command for unknown channel: {}", new Object[]{session, SshConstants.getCommandMessageName(by), l2});
        }
        boolean bl3 = false;
        switch (by) {
            case 98: {
                String string = buffer.getString();
                bl3 = buffer.getBoolean();
                if (!bl2) break;
                this.log.debug("handleUnknownChannelCommand({}) Received SSH_MSG_CHANNEL_REQUEST={} (wantReply={}) for unknown channel: {}", new Object[]{session, string, bl3, l2});
                break;
            }
            case 94: 
            case 95: {
                bl3 = (Boolean)CoreModuleProperties.SEND_REPLY_FOR_CHANNEL_DATA.getRequired(session);
                if (!this.log.isTraceEnabled()) break;
                this.log.trace("handleUnknownChannelCommand({}) received msg channel data (opcode={}) reply={}", new Object[]{session, by, bl3});
                break;
            }
        }
        if (bl3) {
            this.sendFailureResponse(connectionService, by, l2);
        }
        return null;
    }

    protected IoWriteFuture sendFailureResponse(ConnectionService connectionService, byte by, long l2) {
        Session session = connectionService.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendFailureResponse({}) send SSH_MSG_CHANNEL_FAILURE for {} command on unknown channel: {}", new Object[]{session, SshConstants.getCommandMessageName(by), l2});
        }
        Buffer buffer = session.createBuffer((byte)100, 4);
        buffer.putUInt(l2);
        return session.writePacket(buffer);
    }
}

