/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.util.Objects;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class CurrentService {
    protected final Session session;
    private String currentName;
    private Service currentService;

    protected CurrentService(Session session) {
        this.session = Objects.requireNonNull(session, "No session given");
    }

    public synchronized String getName() {
        return this.currentName;
    }

    public synchronized Service getService() {
        return this.currentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Service service, String string, boolean bl2) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No service name specified");
        Objects.requireNonNull(service, "No service specified");
        CurrentService currentService = this;
        synchronized (currentService) {
            this.currentName = string;
            this.currentService = service;
        }
        if (bl2) {
            service.start();
        }
    }

    public void start() {
        Service service = this.getService();
        ValidateUtils.checkState(service != null, "No current SSH service; cannot start");
        service.start();
    }

    public boolean process(int n2, Buffer buffer) {
        Service service = this.getService();
        if (service != null) {
            service.process(n2, buffer);
            return true;
        }
        return false;
    }
}

