/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.session.helpers.MissingAttachedSessionException;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractSessionIoHandler
extends AbstractLoggingBean
implements IoHandler {
    protected AbstractSessionIoHandler() {
    }

    @Override
    public void sessionCreated(IoSession ioSession) {
        ValidateUtils.checkNotNull((Object)this.createSession(ioSession), "No session created for %s", (Object)ioSession);
    }

    @Override
    public void sessionClosed(IoSession ioSession) {
        AbstractSession abstractSession = AbstractSession.getSession(ioSession);
        abstractSession.close(true);
    }

    @Override
    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        AbstractSession abstractSession = AbstractSession.getSession(ioSession, true);
        if (abstractSession == null) {
            throw new MissingAttachedSessionException("No session available to signal caught exception=" + throwable.getClass().getSimpleName(), throwable);
        }
        abstractSession.exceptionCaught(throwable);
    }

    @Override
    public void messageReceived(IoSession ioSession, Readable readable) {
        AbstractSession abstractSession = AbstractSession.getSession(ioSession);
        try {
            abstractSession.messageReceived(readable);
        }
        catch (Error error) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("messageReceived({}) failed {} to handle message: {}", new Object[]{ioSession, error.getClass().getSimpleName(), error.getMessage(), error});
            }
            throw new RuntimeSshException(error);
        }
    }

    protected abstract AbstractSession createSession(IoSession var1);
}

