/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongConsumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.Cipher$Mode;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.compression.Compression$Type;
import org.apache.sshd.common.compression.CompressionInformation;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.GlobalRequestFuture;
import org.apache.sshd.common.future.GlobalRequestFuture$ReplyHandler;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.global.GlobalRequestException;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensionHandler$AvailabilityPhase;
import org.apache.sshd.common.kex.extension.KexExtensionHandler$KexPhase;
import org.apache.sshd.common.kex.extension.KexExtensions;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.SessionListener$Event;
import org.apache.sshd.common.session.SessionWorkBuffer;
import org.apache.sshd.common.session.helpers.AbstractSession$1;
import org.apache.sshd.common.session.helpers.AbstractSession$2;
import org.apache.sshd.common.session.helpers.AbstractSession$KexStart;
import org.apache.sshd.common.session.helpers.AbstractSession$MessageCodingSettings;
import org.apache.sshd.common.session.helpers.CurrentService;
import org.apache.sshd.common.session.helpers.KeyExchangeMessageHandler;
import org.apache.sshd.common.session.helpers.MissingAttachedSessionException;
import org.apache.sshd.common.session.helpers.MultipleAttachedSessionException;
import org.apache.sshd.common.session.helpers.PendingWriteFuture;
import org.apache.sshd.common.session.helpers.SessionHelper;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class AbstractSession
extends SessionHelper {
    public static final String SESSION = "org.apache.sshd.session";
    protected final Random random;
    protected final Collection sessionListeners = new CopyOnWriteArraySet();
    protected final SessionListener sessionListenerProxy;
    protected final Collection channelListeners = new CopyOnWriteArraySet();
    protected final ChannelListener channelListenerProxy;
    protected final Collection tunnelListeners = new CopyOnWriteArraySet();
    protected final PortForwardingEventListener tunnelListenerProxy;
    protected byte[] sessionId;
    protected String serverVersion;
    protected String clientVersion;
    protected final Map serverProposal = new EnumMap(KexProposalOption.class);
    protected final Map unmodServerProposal = Collections.unmodifiableMap(this.serverProposal);
    protected final Map clientProposal = new EnumMap(KexProposalOption.class);
    protected final Map unmodClientProposal = Collections.unmodifiableMap(this.clientProposal);
    protected final Map negotiationResult = new EnumMap(KexProposalOption.class);
    protected final Map unmodNegotiationResult = Collections.unmodifiableMap(this.negotiationResult);
    protected KeyExchange kex;
    protected Boolean firstKexPacketFollows;
    protected boolean initialKexDone;
    protected final AtomicReference kexState = new AtomicReference<KexState>(KexState.UNKNOWN);
    protected final AtomicReference kexFutureHolder = new AtomicReference<Object>(null);
    protected DefaultKeyExchangeFuture kexInitializedFuture;
    protected Cipher outCipher;
    protected Cipher inCipher;
    protected int outCipherSize = 8;
    protected int inCipherSize = 8;
    protected Mac outMac;
    protected Mac inMac;
    protected int outMacSize;
    protected int inMacSize;
    protected byte[] inMacResult;
    protected Compression outCompression;
    protected Compression inCompression;
    protected long seqi;
    protected long seqo;
    protected SessionWorkBuffer uncompressBuffer;
    protected final SessionWorkBuffer decoderBuffer;
    protected int decoderState;
    protected int decoderLength;
    protected final Object encodeLock = new Object();
    protected final Object decodeLock = new Object();
    protected final Object requestLock = new Object();
    protected boolean strictKex;
    protected long initialKexInitSequenceNumber = -1L;
    protected final KeyExchangeMessageHandler kexHandler;
    protected final AtomicLong inPacketsCount = new AtomicLong(0L);
    protected final AtomicLong outPacketsCount = new AtomicLong(0L);
    protected final AtomicLong inBytesCount = new AtomicLong(0L);
    protected final AtomicLong outBytesCount = new AtomicLong(0L);
    protected final AtomicLong inBlocksCount = new AtomicLong(0L);
    protected final AtomicLong outBlocksCount = new AtomicLong(0L);
    protected final AtomicReference lastKeyTimeValue = new AtomicReference<Instant>(Instant.now());
    protected long maxRekyPackets;
    protected long maxRekeyBytes;
    protected Duration maxRekeyInterval;
    protected AbstractSession$MessageCodingSettings inSettings;
    protected AbstractSession$MessageCodingSettings outSettings;
    protected final CurrentService currentService;
    protected int ignorePacketDataLength;
    protected long ignorePacketsFrequency;
    protected int ignorePacketsVariance;
    protected final AtomicLong maxRekeyBlocks = new AtomicLong((Long)CoreModuleProperties.REKEY_BYTES_LIMIT.getRequiredDefault() / 16L);
    protected final AtomicLong ignorePacketsCount = new AtomicLong((Long)CoreModuleProperties.IGNORE_MESSAGE_FREQUENCY.getRequiredDefault());
    private final Deque pendingGlobalRequests = new ConcurrentLinkedDeque();
    private final Map globalSequenceNumbers = new ConcurrentHashMap();
    private byte[] clientKexData;
    private byte[] serverKexData;

    protected AbstractSession(boolean bl2, FactoryManager factoryManager, IoSession ioSession) {
        super(bl2, factoryManager, ioSession);
        this.decoderBuffer = new SessionWorkBuffer(this);
        this.kexHandler = Objects.requireNonNull(this.initializeKeyExchangeMessageHandler(), "No KeyExchangeMessageHandler set on the session");
        this.currentService = Objects.requireNonNull(this.initializeCurrentService(), "No CurrentService set on the session");
        AbstractSession.attachSession(ioSession, this);
        Factory factory = (Factory)ValidateUtils.checkNotNull((Object)factoryManager.getRandomFactory(), "No random factory for %s", (Object)ioSession);
        this.random = (Random)ValidateUtils.checkNotNull((Object)((Random)factory.create()), "No randomizer instance for %s", (Object)ioSession);
        this.refreshConfiguration();
        this.sessionListenerProxy = (SessionListener)EventListenerUtils.proxyWrapper(SessionListener.class, this.sessionListeners);
        this.channelListenerProxy = (ChannelListener)EventListenerUtils.proxyWrapper(ChannelListener.class, this.channelListeners);
        this.tunnelListenerProxy = (PortForwardingEventListener)EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.tunnelListeners);
        try {
            this.signalSessionEstablished(ioSession);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeSshException(exception);
        }
    }

    protected KeyExchangeMessageHandler initializeKeyExchangeMessageHandler() {
        return new KeyExchangeMessageHandler(this, this.log);
    }

    protected CurrentService initializeCurrentService() {
        return new CurrentService(this);
    }

    public static int calculatePadLength(int n2, int n3, boolean bl2) {
        int n4;
        ++n2;
        if (!bl2) {
            n2 += 4;
        }
        if ((n4 = -n2 & n3 - 1) < n3) {
            n4 += n3;
        }
        return n4;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public Map getServerKexProposals() {
        return this.unmodServerProposal;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public Map getClientKexProposals() {
        return this.unmodClientProposal;
    }

    @Override
    public KeyExchange getKex() {
        return this.kex;
    }

    @Override
    public KexState getKexState() {
        return (KexState)((Object)this.kexState.get());
    }

    @Override
    public byte[] getSessionId() {
        return NumberUtils.isEmpty(this.sessionId) ? this.sessionId : (byte[])this.sessionId.clone();
    }

    @Override
    public Map getKexNegotiationResult() {
        return this.unmodNegotiationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNegotiatedKexParameter(KexProposalOption kexProposalOption) {
        if (kexProposalOption == null) {
            return null;
        }
        Map map = this.negotiationResult;
        synchronized (map) {
            return (String)this.negotiationResult.get((Object)kexProposalOption);
        }
    }

    @Override
    public CipherInformation getCipherInformation(boolean bl2) {
        return bl2 ? this.inCipher : this.outCipher;
    }

    @Override
    public CompressionInformation getCompressionInformation(boolean bl2) {
        return bl2 ? this.inCompression : this.outCompression;
    }

    @Override
    public MacInformation getMacInformation(boolean bl2) {
        return bl2 ? this.inMac : this.outMac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(Readable readable) {
        Object object = this.decodeLock;
        synchronized (object) {
            this.decoderBuffer.putBuffer(readable);
            if (this.clientVersion == null || this.serverVersion == null) {
                if (this.readIdentification(this.decoderBuffer)) {
                    this.decoderBuffer.compact();
                } else {
                    return;
                }
            }
            this.decode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshConfiguration() {
        Random random = this.random;
        synchronized (random) {
            this.maxRekeyBytes = (Long)CoreModuleProperties.REKEY_BYTES_LIMIT.getRequired(this);
            this.maxRekeyInterval = (Duration)CoreModuleProperties.REKEY_TIME_LIMIT.getRequired(this);
            this.maxRekyPackets = (Long)CoreModuleProperties.REKEY_PACKETS_LIMIT.getRequired(this);
            this.ignorePacketDataLength = (Integer)CoreModuleProperties.IGNORE_MESSAGE_SIZE.getRequired(this);
            this.ignorePacketsFrequency = (Long)CoreModuleProperties.IGNORE_MESSAGE_FREQUENCY.getRequired(this);
            this.ignorePacketsVariance = (Integer)CoreModuleProperties.IGNORE_MESSAGE_VARIANCE.getRequired(this);
            if ((long)this.ignorePacketsVariance >= this.ignorePacketsFrequency) {
                this.ignorePacketsVariance = 0;
            }
            long l2 = this.calculateNextIgnorePacketCount(this.random, this.ignorePacketsFrequency, this.ignorePacketsVariance);
            this.ignorePacketsCount.set(l2);
        }
    }

    protected void handleMessage(Buffer buffer) {
        try {
            ThreadUtils.runAsInternal(() -> {
                this.doHandleMessage(buffer);
                return null;
            });
        }
        catch (Throwable throwable) {
            DefaultKeyExchangeFuture defaultKeyExchangeFuture = (DefaultKeyExchangeFuture)this.kexFutureHolder.get();
            if (defaultKeyExchangeFuture != null) {
                defaultKeyExchangeFuture.setValue(throwable);
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeSshException(throwable);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doHandleMessage(Buffer var1_1) {
        var2_2 = var1_1.getUByte();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doHandleMessage({}) process #{} {}", new Object[]{this, this.seqi - 1L, SshConstants.getCommandMessageName(var2_2)});
        }
        switch (var2_2) {
            case 1: {
                this.handleDisconnect(var1_1);
                break;
            }
            case 2: {
                this.failStrictKex(var2_2);
                this.handleIgnore(var1_1);
                break;
            }
            case 3: {
                this.failStrictKex(var2_2);
                this.handleUnimplemented(var1_1);
                break;
            }
            case 4: {
                this.handleDebug(var1_1);
                this.failStrictKex(var2_2);
                break;
            }
            case 5: {
                this.failStrictKex(var2_2);
                this.handleServiceRequest(var1_1);
                break;
            }
            case 6: {
                this.failStrictKex(var2_2);
                this.handleServiceAccept(var1_1);
                break;
            }
            case 20: {
                this.handleKexInit(var1_1);
                break;
            }
            case 21: {
                this.handleNewKeys(var2_2, var1_1);
                break;
            }
            case 7: {
                this.failStrictKex(var2_2);
                this.handleKexExtension(var2_2, var1_1);
                break;
            }
            case 8: {
                this.failStrictKex(var2_2);
                this.handleNewCompression(var2_2, var1_1);
                break;
            }
            default: {
                if (var2_2 < 30 || var2_2 > 49) ** GOTO lbl54
                if (this.firstKexPacketFollows != null) {
                    try {
                        if (!this.handleFirstKexPacketFollows(var2_2, var1_1, this.firstKexPacketFollows)) {
                            break;
                        }
                    }
                    finally {
                        this.firstKexPacketFollows = null;
                    }
                }
                this.handleKexMessage(var2_2, var1_1);
                break;
lbl54:
                // 1 sources

                this.failStrictKex(var2_2);
                if (this.currentService.process(var2_2, var1_1)) {
                    this.resetIdleTimeout();
                    break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Unsupported command: {}", (Object)this, (Object)SshConstants.getCommandMessageName(var2_2));
                }
                this.notImplemented(var2_2, var1_1);
            }
        }
        this.checkRekey();
    }

    protected void failStrictKex(int n2) {
        if (!this.initialKexDone && this.strictKex) {
            throw new SshException(3, SshConstants.getCommandMessageName(n2) + " not allowed during initial key exchange in strict KEX");
        }
    }

    protected boolean handleFirstKexPacketFollows(int n2, Buffer buffer, boolean bl2) {
        if (!bl2) {
            return true;
        }
        boolean bl3 = this.log.isDebugEnabled();
        for (KexProposalOption kexProposalOption : KexProposalOption.FIRST_KEX_PACKET_GUESS_MATCHES) {
            Map.Entry entry = this.comparePreferredKexProposalOption(kexProposalOption);
            if (entry == null) continue;
            if (bl3) {
                this.log.debug("handleFirstKexPacketFollows({})[{}] 1st follow KEX packet {} option mismatch: client={}, server={}", new Object[]{this, SshConstants.getCommandMessageName(n2), kexProposalOption, entry.getKey(), entry.getValue()});
            }
            return false;
        }
        return true;
    }

    protected Map.Entry comparePreferredKexProposalOption(KexProposalOption kexProposalOption) {
        Object object;
        Object[] objectArray = GenericUtils.split((String)this.clientProposal.get((Object)kexProposalOption), ',');
        Object object2 = GenericUtils.isEmpty(objectArray) ? null : objectArray[0];
        Object[] objectArray2 = GenericUtils.split((String)this.serverProposal.get((Object)kexProposalOption), ',');
        Object object3 = object = GenericUtils.isEmpty(objectArray2) ? null : objectArray2[0];
        if (GenericUtils.isEmpty((CharSequence)object2) || GenericUtils.isEmpty((CharSequence)object) || !Objects.equals(object2, object)) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(object2, object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture sendNewKeys() {
        AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
        int n2;
        IoWriteFuture ioWriteFuture;
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendNewKeys({}) Send SSH_MSG_NEWKEYS", (Object)this);
        }
        this.prepareNewKeys();
        Buffer buffer = this.createBuffer((byte)21, 8);
        Object object = this.encodeLock;
        synchronized (object) {
            ioWriteFuture = this.doWritePacket(buffer);
            this.setOutputEncoding();
        }
        this.kexHandler.updateState(() -> this.kexState.set(KexState.KEYS));
        this.resetIdleTimeout();
        object = this.getKexExtensionHandler();
        if (object != null && object.isKexExtensionsAvailable(this, KexExtensionHandler$AvailabilityPhase.NEWKEYS)) {
            object.sendKexExtensions(this, KexExtensionHandler$KexPhase.NEWKEYS);
        }
        if ((n2 = ((Integer)(simpleImmutableEntry = this.kexHandler.terminateKeyExchange()).getKey()).intValue()) == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleNewKeys({}) No pending packets to flush at end of KEX", (Object)this);
            }
            ((DefaultKeyExchangeFuture)simpleImmutableEntry.getValue()).setValue(Boolean.TRUE);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleNewKeys({}) {} pending packets to flush at end of KEX", (Object)this, (Object)n2);
            }
            this.kexHandler.flushQueue((DefaultKeyExchangeFuture)simpleImmutableEntry.getValue());
        }
        return ioWriteFuture;
    }

    protected void handleKexMessage(int n2, Buffer buffer) {
        this.validateKexState(n2, KexState.RUN);
        boolean bl2 = this.log.isDebugEnabled();
        if (this.kex.next(n2, buffer)) {
            if (bl2) {
                this.log.debug("handleKexMessage({})[{}] KEX processing complete after cmd={}", new Object[]{this, this.kex.getName(), n2});
            }
            this.checkKeys();
            this.sendNewKeys();
        } else if (bl2) {
            this.log.debug("handleKexMessage({})[{}] more KEX packets expected after cmd={}", new Object[]{this, this.kex.getName(), n2});
        }
    }

    protected void handleKexExtension(int n2, Buffer buffer) {
        KexExtensionHandler kexExtensionHandler = this.getKexExtensionHandler();
        int n3 = buffer.rpos();
        if (kexExtensionHandler != null && kexExtensionHandler.handleKexExtensionsMessage(this, buffer)) {
            return;
        }
        buffer.rpos(n3);
        this.notImplemented(n2, buffer);
    }

    protected void handleNewCompression(int n2, Buffer buffer) {
        KexExtensionHandler kexExtensionHandler = this.getKexExtensionHandler();
        int n3 = buffer.rpos();
        if (kexExtensionHandler != null && kexExtensionHandler.handleKexCompressionMessage(this, buffer)) {
            return;
        }
        buffer.rpos(n3);
        this.notImplemented(n2, buffer);
    }

    protected void handleServiceRequest(Buffer buffer) {
        String string = buffer.getString();
        this.handleServiceRequest(string, buffer);
    }

    protected boolean handleServiceRequest(String string, Buffer buffer) {
        KexState kexState;
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("handleServiceRequest({}) SSH_MSG_SERVICE_REQUEST '{}'", (Object)this, (Object)string);
        }
        if (!this.validateServiceKexState(kexState = (KexState)((Object)this.kexState.get()))) {
            throw new IllegalStateException("Received " + SshConstants.getCommandMessageName(5) + " while in KEX state=" + (Object)((Object)kexState));
        }
        try {
            this.startService(string, buffer);
        }
        catch (Throwable throwable) {
            this.debug("handleServiceRequest({}) Service {} rejected: {} = {}", this, string, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            this.disconnect(7, "Bad service request: " + string);
            return false;
        }
        if (bl2) {
            this.log.debug("handleServiceRequest({}) Accepted service {}", (Object)this, (Object)string);
        }
        Buffer buffer2 = this.createBuffer((byte)6, 8 + GenericUtils.length(string));
        buffer2.putString(string);
        this.writePacket(buffer2);
        return true;
    }

    protected boolean validateServiceKexState(KexState kexState) {
        if (KexState.DONE.equals((Object)kexState)) {
            return true;
        }
        if (KexState.INIT.equals((Object)kexState)) {
            return this.initialKexDone;
        }
        return false;
    }

    protected void handleServiceAccept(Buffer buffer) {
        this.handleServiceAccept(buffer.getString(), buffer);
    }

    protected void handleServiceAccept(String string, Buffer buffer) {
        KexState kexState;
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServiceAccept({}) SSH_MSG_SERVICE_ACCEPT service={}", (Object)this, (Object)string);
        }
        if (!this.validateServiceKexState(kexState = (KexState)((Object)this.kexState.get()))) {
            throw new IllegalStateException("Received " + SshConstants.getCommandMessageName(5) + " while in KEX state=" + (Object)((Object)kexState));
        }
    }

    protected void handleKexInit(Buffer buffer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleKexInit({}) SSH_MSG_KEXINIT", (Object)this);
        }
        this.receiveKexInit(buffer);
        this.doKexNegotiation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doKexNegotiation() {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        Object object2;
        AbstractSession$KexStart abstractSession$KexStart = (AbstractSession$KexStart)((Object)this.kexHandler.updateState(() -> {
            if (this.kexState.compareAndSet(KexState.DONE, KexState.RUN)) {
                this.kexHandler.initNewKeyExchange();
                return AbstractSession$KexStart.PEER;
            }
            if (this.kexState.compareAndSet(KexState.INIT, KexState.RUN)) {
                return AbstractSession$KexStart.BOTH;
            }
            return AbstractSession$KexStart.ONGOING;
        }));
        switch (abstractSession$KexStart) {
            case PEER: {
                this.sendKexInit();
                break;
            }
            case BOTH: {
                object2 = this.kexState;
                synchronized (object2) {
                    object = this.kexInitializedFuture;
                    if (object == null) {
                        this.kexInitializedFuture = object = new DefaultKeyExchangeFuture(this.toString(), null);
                    }
                }
                object.await((Duration)CoreModuleProperties.KEX_PROPOSAL_SETUP_TIMEOUT.getRequired(this));
                break;
            }
            default: {
                throw new IllegalStateException("Received SSH_MSG_KEXINIT while key exchange is running");
            }
        }
        object = this.negotiate();
        object2 = (String)object.get((Object)KexProposalOption.ALGORITHMS);
        List list = this.getKeyExchangeFactories();
        KeyExchangeFactory keyExchangeFactory = (KeyExchangeFactory)NamedResource.findByName((String)object2, String.CASE_INSENSITIVE_ORDER, list);
        ValidateUtils.checkNotNull((Object)keyExchangeFactory, "Unknown negotiated KEX algorithm: %s", object2);
        byte[] byArray3 = this.serverVersion.getBytes(StandardCharsets.UTF_8);
        byte[] byArray4 = this.clientVersion.getBytes(StandardCharsets.UTF_8);
        AtomicReference atomicReference = this.kexState;
        synchronized (atomicReference) {
            byArray2 = this.getServerKexData();
            byArray = this.getClientKexData();
        }
        this.kex = keyExchangeFactory.createKeyExchange(this);
        this.kex.init(byArray3, byArray4, byArray2, byArray);
        atomicReference = this.kexState;
        synchronized (atomicReference) {
            this.kexInitializedFuture = null;
        }
        this.signalSessionEvent(SessionListener$Event.KexCompleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewKeys(int n2, Buffer buffer) {
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("handleNewKeys({}) SSH_MSG_NEWKEYS command={}", (Object)this, (Object)SshConstants.getCommandMessageName(n2));
        }
        this.validateKexState(n2, KexState.KEYS);
        this.setInputEncoding();
        Object object = this.kexState;
        synchronized (object) {
            this.kexInitializedFuture = null;
        }
        this.initialKexDone = true;
        object = (DefaultKeyExchangeFuture)this.kexFutureHolder.get();
        if (object != null) {
            ((DefaultSshFuture)object).setValue(Boolean.TRUE);
        }
        this.signalSessionEvent(SessionListener$Event.KeyEstablished);
        this.kexHandler.updateState(() -> {
            this.kex = null;
            this.kexState.set(KexState.DONE);
        });
        Object object2 = this.futureLock;
        synchronized (object2) {
            this.futureLock.notifyAll();
        }
    }

    protected void validateKexState(int n2, KexState kexState) {
        KexState kexState2 = (KexState)((Object)this.kexState.get());
        if (!kexState.equals((Object)kexState2)) {
            throw new IllegalStateException("Received KEX command=" + SshConstants.getCommandMessageName(n2) + " while in state=" + (Object)((Object)kexState2) + " instead of " + (Object)((Object)kexState));
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        Closeable closeable = this.builder().parallel(this.toString(), this.getServices()).close(this.getIoSession()).build();
        closeable.addCloseFutureListener(closeFuture -> this.clearAttributes());
        return closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        GlobalRequestFuture globalRequestFuture;
        DefaultKeyExchangeFuture defaultKeyExchangeFuture;
        Object object = this.kexState;
        synchronized (object) {
            defaultKeyExchangeFuture = this.kexInitializedFuture;
        }
        if (defaultKeyExchangeFuture != null) {
            defaultKeyExchangeFuture.setValue(new SshException("Session closing while KEX in progress"));
        }
        if ((object = (DefaultKeyExchangeFuture)this.kexFutureHolder.get()) != null) {
            ((DefaultSshFuture)object).setValue(new SshException("Session closing while KEX in progress"));
        }
        this.kexHandler.shutdown();
        boolean bl2 = this.log.isDebugEnabled();
        while ((globalRequestFuture = (GlobalRequestFuture)this.pendingGlobalRequests.pollLast()) != null) {
            if (bl2) {
                this.log.debug("preClose({}): Session closing; failing still pending global request {}", (Object)this, (Object)globalRequestFuture.getId());
            }
            globalRequestFuture.setValue(new SshException("Session is closing"));
        }
        try {
            this.signalSessionClosed();
        }
        finally {
            this.sessionListeners.clear();
            this.channelListeners.clear();
            this.tunnelListeners.clear();
        }
        super.preClose();
    }

    protected List getServices() {
        Service service = this.currentService.getService();
        return service != null ? Collections.singletonList(service) : Collections.emptyList();
    }

    @Override
    public Service getService(Class clazz) {
        List list = this.getServices();
        ValidateUtils.checkState(GenericUtils.isNotEmpty(list), "No registered services to look for %s", (Object)clazz.getSimpleName());
        for (Service service : list) {
            if (!clazz.isInstance(service)) continue;
            return (Service)clazz.cast(service);
        }
        throw new IllegalStateException("Attempted to access unknown service " + clazz.getSimpleName());
    }

    @Override
    protected Buffer preProcessEncodeBuffer(int n2, Buffer buffer) {
        LongConsumer longConsumer = (LongConsumer)this.globalSequenceNumbers.remove(buffer = super.preProcessEncodeBuffer(n2, buffer));
        if (longConsumer != null) {
            longConsumer.accept(this.seqo);
        }
        return buffer;
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer) {
        return this.kexHandler.writePacket(buffer, 0L, null);
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer, long l2, TimeUnit timeUnit) {
        IoWriteFuture ioWriteFuture2;
        long l3 = timeUnit.toMillis(l2);
        try {
            long l4 = System.currentTimeMillis();
            ioWriteFuture2 = this.kexHandler.writePacket(buffer, l2, timeUnit);
            long l5 = System.currentTimeMillis() - l4;
            l3 = l5 >= l3 ? 1L : (l3 -= l5);
        }
        catch (InterruptedIOException interruptedIOException) {
            PendingWriteFuture pendingWriteFuture = new PendingWriteFuture((Object)this, buffer);
            TimeoutException timeoutException = new TimeoutException("Timeout writing packet: " + l2 + " " + (Object)((Object)timeUnit));
            timeoutException.initCause(interruptedIOException);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writePacket({}): {}", (Object)this, (Object)timeoutException.getMessage());
            }
            pendingWriteFuture.setValue(timeoutException);
            return pendingWriteFuture;
        }
        if (ioWriteFuture2.isDone()) {
            return ioWriteFuture2;
        }
        DefaultSshFuture defaultSshFuture = (DefaultSshFuture)((Object)ioWriteFuture2);
        FactoryManager factoryManager = this.getFactoryManager();
        ScheduledExecutorService scheduledExecutorService = factoryManager.getScheduledExecutorService();
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.schedule(() -> {
            TimeoutException timeoutException = new TimeoutException("Timeout writing packet: " + l2 + " " + (Object)((Object)timeUnit));
            if (this.log.isDebugEnabled()) {
                this.log.debug("writePacket({}): {}", (Object)this, (Object)timeoutException.getMessage());
            }
            defaultSshFuture.setValue(timeoutException);
        }, l3, TimeUnit.MILLISECONDS);
        defaultSshFuture.addListener(ioWriteFuture -> scheduledFuture.cancel(false));
        return ioWriteFuture2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Buffer resolveOutputPacket(Buffer buffer) {
        Object object;
        int n2;
        Buffer buffer2 = null;
        int n3 = this.resolveIgnoreBufferDataLength();
        if (n3 > 0) {
            buffer2 = this.createBuffer((byte)2, n3 + 8);
            buffer2.putUInt(n3);
            n2 = buffer2.wpos();
            Random random = this.random;
            object = random;
            // MONITORENTER : random
            this.random.fill(buffer2.array(), n2, n3);
            // MONITOREXIT : object
            buffer2.wpos(n2 + n3);
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveOutputPacket({}) append SSH_MSG_IGNORE message", (Object)this);
            }
        }
        n2 = buffer.rpos();
        object = buffer.array();
        int n4 = object[n2] & 0xFF;
        buffer = this.validateTargetBuffer(n4, buffer);
        if (buffer2 == null) return this.encode(buffer);
        buffer2 = this.encode(buffer2);
        IoSession ioSession = this.getIoSession();
        ioSession.writeBuffer(buffer2);
        return this.encode(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture doWritePacket(Buffer buffer) {
        Object object = this.encodeLock;
        synchronized (object) {
            Buffer buffer2 = this.resolveOutputPacket(buffer);
            IoSession ioSession = this.getIoSession();
            IoWriteFuture ioWriteFuture = ioSession.writeBuffer(buffer2);
            return ioWriteFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int resolveIgnoreBufferDataLength() {
        if (!this.initialKexDone || this.ignorePacketDataLength <= 0 || this.ignorePacketsFrequency <= 0L || this.ignorePacketsVariance < 0) {
            return 0;
        }
        long l2 = this.ignorePacketsCount.decrementAndGet();
        if (l2 > 0L) {
            return 0;
        }
        Random random = this.random;
        synchronized (random) {
            l2 = this.calculateNextIgnorePacketCount(this.random, this.ignorePacketsFrequency, this.ignorePacketsVariance);
            this.ignorePacketsCount.set(l2);
            return this.ignorePacketDataLength + this.random.random(this.ignorePacketDataLength);
        }
    }

    private boolean wantReply(Buffer buffer) {
        int n2 = buffer.rpos();
        buffer.getByte();
        buffer.getString();
        boolean bl2 = buffer.getBoolean();
        buffer.rpos(n2);
        return bl2;
    }

    @Override
    public Buffer request(String string, Buffer buffer, long l2) {
        Object object;
        ValidateUtils.checkTrue(l2 > 0L, "Requested timeout for " + string + " is not strictly greater than zero: " + l2);
        boolean bl2 = this.log.isDebugEnabled();
        boolean bl3 = this.wantReply(buffer);
        GlobalRequestFuture globalRequestFuture = this.request(buffer, string, null);
        boolean bl4 = false;
        try {
            if (bl2) {
                this.log.debug("request({}) request={}, timeout={}ms", new Object[]{this, string, l2});
            }
            bl4 = globalRequestFuture.await(l2);
            object = globalRequestFuture.getValue();
        }
        catch (InterruptedIOException interruptedIOException) {
            throw (InterruptedIOException)new InterruptedIOException("Interrupted while waiting for request=" + string + " result").initCause(interruptedIOException);
        }
        if (!this.isOpen()) {
            throw new IOException("Session was closed or closing while awaiting reply for request=" + string);
        }
        if (bl3) {
            if (bl2) {
                this.log.debug("request({}) request={}, timeout={}ms, requestSeqNo={}, done {}, result received={}", new Object[]{this, string, l2, globalRequestFuture.getSequenceNumber(), bl4, object instanceof Buffer});
            }
            if (!bl4 || object == null) {
                throw new SocketTimeoutException("No response received after " + l2 + "ms for request=" + string);
            }
            if (object instanceof GlobalRequestException) {
                if (bl2) {
                    this.log.debug("request({}) request={}, requestSeqNo={}: received={}", new Object[]{this, string, globalRequestFuture.getSequenceNumber(), SshConstants.getCommandMessageName(((GlobalRequestException)object).getCode())});
                }
                return null;
            }
        }
        if (object instanceof Throwable) {
            throw new IOException("Exception on request " + string, (Throwable)object);
        }
        if (object instanceof Buffer) {
            return (Buffer)object;
        }
        return null;
    }

    @Override
    public GlobalRequestFuture request(Buffer buffer, String string, GlobalRequestFuture$ReplyHandler globalRequestFuture$ReplyHandler) {
        if (!this.wantReply(buffer)) {
            if (!this.isOpen()) {
                throw new IOException("Global request " + string + ": session is closing or closed.");
            }
            AbstractSession$1 abstractSession$1 = new AbstractSession$1(this, string, globalRequestFuture$ReplyHandler);
            this.writePacket(buffer).addListener(abstractSession$1);
            return abstractSession$1;
        }
        AbstractSession$2 abstractSession$2 = new AbstractSession$2(this, string, globalRequestFuture$ReplyHandler);
        if (!this.isOpen()) {
            throw new IOException("Global request " + string + ": session is closing or closed.");
        }
        this.globalSequenceNumbers.put(buffer, l2 -> {
            abstractSession$2.setSequenceNumber(l2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("makeGlobalRequest({})[{}] want-reply=true with seqNo={}", new Object[]{this, abstractSession$2.getId(), l2});
            }
            this.pendingGlobalRequests.push(abstractSession$2);
        });
        ((IoWriteFuture)this.writePacket(buffer).addListener(ioWriteFuture -> {
            Throwable throwable = ioWriteFuture.getException();
            if (throwable != null) {
                this.globalSequenceNumbers.remove(buffer);
            }
        })).addListener(abstractSession$2);
        return abstractSession$2;
    }

    @Override
    protected boolean doInvokeUnimplementedMessageHandler(int n2, Buffer buffer) {
        if (!this.pendingGlobalRequests.isEmpty() && n2 == 3) {
            long l2 = buffer.rawUInt(buffer.rpos());
            GlobalRequestFuture globalRequestFuture2 = this.pendingGlobalRequests.stream().filter(globalRequestFuture -> globalRequestFuture.getSequenceNumber() == l2).findAny().orElse(null);
            if (globalRequestFuture2 != null && this.pendingGlobalRequests.removeFirstOccurrence(globalRequestFuture2)) {
                GlobalRequestFuture$ReplyHandler globalRequestFuture$ReplyHandler;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doInvokeUnimplementedMessageHandler({}) report global request={} failure for seqNo={}", new Object[]{this, globalRequestFuture2.getId(), l2});
                }
                if ((globalRequestFuture$ReplyHandler = globalRequestFuture2.getHandler()) != null) {
                    ByteArrayBuffer byteArrayBuffer = ByteArrayBuffer.getCompactClone(buffer.array(), buffer.rpos(), buffer.available());
                    globalRequestFuture$ReplyHandler.accept(n2, byteArrayBuffer);
                } else {
                    globalRequestFuture2.setValue(new GlobalRequestException(n2));
                }
                return true;
            }
            if (globalRequestFuture2 != null) {
                return true;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("doInvokeUnimplementedMessageHandler({}) SSH_MSG_UNIMPLEMENTED with message seqNo={} not for a global request", (Object)this, (Object)l2);
            }
        }
        return super.doInvokeUnimplementedMessageHandler(n2, buffer);
    }

    @Override
    public Buffer createBuffer(byte by, int n2) {
        if (n2 <= 0) {
            return this.prepareBuffer(by, new ByteArrayBuffer());
        }
        boolean bl2 = this.outMac != null && this.outMac.isEncryptThenMac();
        int n3 = this.outCipher != null ? this.outCipher.getAuthenticationTagSize() : 0;
        boolean bl3 = n3 > 0;
        int n4 = AbstractSession.calculatePadLength(n2, this.outCipherSize, bl2 || bl3);
        n2 += 5 + n4 + n3;
        if (this.outMac != null) {
            n2 += this.outMacSize;
        }
        return this.prepareBuffer(by, new ByteArrayBuffer(new byte[n2 + 8], false));
    }

    @Override
    public Buffer prepareBuffer(byte by, Buffer buffer) {
        buffer = this.validateTargetBuffer(by & 0xFF, buffer);
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte(by);
        return buffer;
    }

    protected Buffer validateTargetBuffer(int n2, Buffer buffer) {
        ValidateUtils.checkNotNull((Object)buffer, "No target buffer to examine for command=%d", n2);
        ValidateUtils.checkTrue(buffer != this.decoderBuffer, "Not allowed to use the internal decoder buffer for command=%d", n2);
        ValidateUtils.checkTrue(buffer != this.uncompressBuffer, "Not allowed to use the internal uncompress buffer for command=%d", n2);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer encode(Buffer buffer) {
        try {
            int n2;
            int n3;
            int n4 = buffer.rpos();
            int n5 = buffer.rawByte(n4) & 0xFF;
            Buffer buffer2 = this.preProcessEncodeBuffer(n5, buffer);
            if (buffer2 != buffer && n5 != (n3 = (buffer = buffer2).rawByte(n4 = buffer.rpos()) & 0xFF)) {
                this.log.warn("encode({}) - command changed from {}[{}] to {}[{}] by pre-processor", new Object[]{this, n5, SshConstants.getCommandMessageName(n5), n3, SshConstants.getCommandMessageName(n3)});
                n5 = n3;
            }
            n3 = buffer.available();
            if (this.log.isDebugEnabled()) {
                this.log.debug("encode({}) packet #{} sending command={}[{}] len={}", new Object[]{this, this.seqo, n5, SshConstants.getCommandMessageName(n5), n3});
            }
            int n6 = n4 - 5;
            boolean bl2 = this.log.isTraceEnabled();
            if (bl2) {
                buffer.dumpHex(this.getSimplifiedLogger(), Level.FINEST, "encode(" + this + ") packet #" + this.seqo, this);
            }
            if (this.outCompression != null && this.outCompression.isCompressionExecuted() && (this.isAuthenticated() || !this.outCompression.isDelayed())) {
                n2 = n3;
                this.outCompression.compress(buffer);
                n3 = buffer.available();
                if (bl2) {
                    this.log.trace("encode({}) packet #{} command={}[{}] compressed {} -> {}", new Object[]{this, this.seqo, n5, SshConstants.getCommandMessageName(n5), n2, n3});
                }
            }
            n2 = this.outMac != null && this.outMac.isEncryptThenMac() ? 1 : 0;
            int n7 = this.outCipher != null ? this.outCipher.getAuthenticationTagSize() : 0;
            boolean bl3 = n7 > 0;
            int n8 = n3;
            int n9 = AbstractSession.calculatePadLength(n3, this.outCipherSize, n2 != 0 || bl3);
            n3 += 1 + n9;
            if (bl2) {
                this.log.trace("encode({}) packet #{} command={}[{}] len={}, pad={}, mac={}", new Object[]{this, this.seqo, n5, SshConstants.getCommandMessageName(n5), n3, n9, this.outMac});
            }
            buffer.wpos(n6);
            buffer.putUInt(n3);
            buffer.putByte((byte)n9);
            buffer.wpos(n6 + n8 + 5 + n9);
            Random random = this.random;
            synchronized (random) {
                this.random.fill(buffer.array(), buffer.wpos() - n9, n9);
            }
            if (bl3) {
                int n10 = buffer.wpos();
                buffer.wpos(n10 + n7);
                this.aeadOutgoingBuffer(buffer, n6, n3);
            } else if (n2 != 0) {
                this.encryptOutgoingBuffer(buffer, n6 + 4, n3);
                this.appendOutgoingMac(buffer, n6, n3);
            } else {
                this.appendOutgoingMac(buffer, n6, n3);
                this.encryptOutgoingBuffer(buffer, n6, n3 + 4);
            }
            this.seqo = this.seqo + 1L & 0xFFFFFFFFL;
            this.outPacketsCount.incrementAndGet();
            this.outBytesCount.addAndGet(n3);
            buffer.rpos(n6);
            return buffer;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new SshException(exception);
        }
    }

    protected void aeadOutgoingBuffer(Buffer buffer, int n2, int n3) {
        if (this.outCipher == null || this.outCipher.getAuthenticationTagSize() == 0) {
            throw new IllegalArgumentException("AEAD mode requires an AEAD cipher");
        }
        byte[] byArray = buffer.array();
        this.outCipher.updateWithAAD(byArray, n2, 4, n3);
        int n4 = n3 / this.outCipherSize;
        this.outBlocksCount.addAndGet(Math.max(1, n4));
    }

    protected void appendOutgoingMac(Buffer buffer, int n2, int n3) {
        if (this.outMac == null) {
            return;
        }
        int n4 = buffer.wpos();
        buffer.wpos(n4 + this.outMacSize);
        this.outMac.updateUInt(this.seqo);
        this.outMac.update(buffer.array(), n2, n3 + 4);
        this.outMac.doFinal(buffer.array(), n4);
    }

    protected void encryptOutgoingBuffer(Buffer buffer, int n2, int n3) {
        if (this.outCipher == null) {
            return;
        }
        this.outCipher.update(buffer.array(), n2, n3);
        int n4 = n3 / this.outCipherSize;
        this.outBlocksCount.addAndGet(Math.max(1, n4));
    }

    protected void decode() {
        while (true) {
            SessionWorkBuffer sessionWorkBuffer;
            int n2;
            boolean bl2;
            int n3 = this.inCipher != null ? this.inCipher.getAuthenticationTagSize() : 0;
            boolean bl3 = n3 > 0;
            int n4 = this.inMac != null ? this.inMacSize : 0;
            boolean bl4 = bl2 = this.inMac != null && this.inMac.isEncryptThenMac();
            if (this.decoderState == 0) {
                int n5;
                assert (this.decoderBuffer.rpos() == 0);
                int n6 = n5 = bl2 || bl3 ? 4 : this.inCipherSize;
                if (this.decoderBuffer.available() <= n5) break;
                if (bl3) {
                    this.inCipher.updateAAD(this.decoderBuffer.array(), 0, 4);
                } else if (this.inCipher != null && !bl2) {
                    this.inCipher.update(this.decoderBuffer.array(), 0, this.inCipherSize);
                    n2 = this.inCipherSize / this.inCipher.getCipherBlockSize();
                    this.inBlocksCount.addAndGet(Math.max(1, n2));
                }
                this.decoderLength = this.decoderBuffer.getInt();
                if (this.decoderLength < 5 || this.decoderLength > 262144) {
                    this.log.warn("decode({}) Error decoding packet(invalid length): {}", (Object)this, (Object)this.decoderLength);
                    this.decoderBuffer.dumpHex(this.getSimplifiedLogger(), Level.FINEST, "decode(" + this + ") invalid length packet", this);
                    throw new SshException(2, "Invalid packet length: " + this.decoderLength);
                }
                this.decoderState = 1;
                continue;
            }
            if (this.decoderState != 1) continue;
            assert (this.decoderBuffer.rpos() == 4);
            if (this.decoderBuffer.available() < this.decoderLength + n4 + n3) break;
            byte[] byArray = this.decoderBuffer.array();
            if (bl3) {
                this.inCipher.update(byArray, 4, this.decoderLength);
                n2 = this.decoderLength / this.inCipherSize;
                this.inBlocksCount.addAndGet(Math.max(1, n2));
            } else if (bl2) {
                this.validateIncomingMac(byArray, 0, this.decoderLength + 4);
                if (this.inCipher != null) {
                    this.inCipher.update(byArray, 4, this.decoderLength);
                    n2 = this.decoderLength / this.inCipherSize;
                    this.inBlocksCount.addAndGet(Math.max(1, n2));
                }
            } else {
                if (this.inCipher != null) {
                    n2 = this.decoderLength + 4 - this.inCipherSize;
                    this.inCipher.update(byArray, this.inCipherSize, n2);
                    int n7 = n2 / this.inCipherSize;
                    this.inBlocksCount.addAndGet(Math.max(1, n7));
                }
                this.validateIncomingMac(byArray, 0, this.decoderLength + 4);
            }
            this.seqi = this.seqi + 1L & 0xFFFFFFFFL;
            n2 = this.decoderBuffer.getUByte();
            int n8 = this.decoderBuffer.wpos();
            if (this.inCompression != null && this.inCompression.isCompressionExecuted() && (this.isAuthenticated() || !this.inCompression.isDelayed())) {
                if (this.uncompressBuffer == null) {
                    this.uncompressBuffer = new SessionWorkBuffer(this);
                } else {
                    this.uncompressBuffer.forceClear(true);
                }
                this.decoderBuffer.wpos(this.decoderBuffer.rpos() + this.decoderLength - 1 - n2);
                this.inCompression.uncompress(this.decoderBuffer, this.uncompressBuffer);
                sessionWorkBuffer = this.uncompressBuffer;
            } else {
                this.decoderBuffer.wpos(this.decoderLength + 4 - n2);
                sessionWorkBuffer = this.decoderBuffer;
            }
            if (this.log.isTraceEnabled()) {
                sessionWorkBuffer.dumpHex(this.getSimplifiedLogger(), Level.FINEST, "decode(" + this + ") packet #" + this.seqi, this);
            }
            this.inPacketsCount.incrementAndGet();
            this.inBytesCount.addAndGet(sessionWorkBuffer.available());
            this.handleMessage(sessionWorkBuffer);
            this.decoderBuffer.rpos(this.decoderLength + 4 + n4 + n3);
            this.decoderBuffer.wpos(n8);
            this.decoderBuffer.compact();
            this.decoderState = 0;
        }
    }

    protected void validateIncomingMac(byte[] byArray, int n2, int n3) {
        if (this.inMac == null) {
            return;
        }
        this.inMac.updateUInt(this.seqi);
        this.inMac.update(byArray, n2, n3);
        this.inMac.doFinal(this.inMacResult, 0);
        if (!Mac.equals(this.inMacResult, 0, byArray, n2 + n3, this.inMacSize)) {
            throw new SshException(5, "MAC Error");
        }
    }

    protected abstract boolean readIdentification(Buffer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendKexInit(Map map) {
        Object object;
        KexProposalOption kexProposalOption2;
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("sendKexInit({}) Send SSH_MSG_KEXINIT", (Object)this);
        }
        Buffer buffer = this.createBuffer((byte)20);
        int n2 = buffer.wpos();
        buffer.wpos(n2 + 16);
        Random random = this.random;
        synchronized (random) {
            this.random.fill(buffer.array(), n2, 16);
        }
        boolean bl3 = this.log.isTraceEnabled();
        if (bl3) {
            this.log.trace("sendKexInit({}) cookie={}", (Object)this, (Object)BufferUtils.toHex(buffer.array(), n2, 16, ':'));
        }
        for (KexProposalOption kexProposalOption2 : KexProposalOption.VALUES) {
            object = (String)map.get((Object)kexProposalOption2);
            if (bl3) {
                this.log.trace("sendKexInit({})[{}] {}", new Object[]{this, kexProposalOption2.getDescription(), object});
            }
            buffer.putString(GenericUtils.trimToEmpty((String)object));
        }
        buffer.putBoolean(false);
        buffer.putUInt(0L);
        ReservedSessionMessagesHandler reservedSessionMessagesHandler = this.getReservedSessionMessagesHandler();
        kexProposalOption2 = reservedSessionMessagesHandler == null ? null : reservedSessionMessagesHandler.sendKexInitRequest(this, map, buffer);
        object = buffer.getCompactData();
        if (kexProposalOption2 == null) {
            this.writePacket(buffer);
        } else if (bl2) {
            this.log.debug("sendKexInit({}) KEX handled by reserved messages handler", (Object)this);
        }
        return object;
    }

    protected byte[] receiveKexInit(Buffer buffer, Map map) {
        long l2;
        Object object;
        byte[] byArray = buffer.array();
        byte[] byArray2 = new byte[buffer.available() + 1];
        byArray2[0] = 20;
        int n2 = 6;
        int n3 = buffer.rpos();
        System.arraycopy(byArray, n3, byArray2, 1, byArray2.length - 1);
        buffer.rpos(n3 + 16);
        n2 += 16;
        boolean bl2 = this.log.isTraceEnabled();
        if (bl2) {
            this.log.trace("receiveKexInit({}) cookie={}", (Object)this, (Object)BufferUtils.toHex(byArray, n3, 16, ':'));
        }
        for (KexProposalOption kexProposalOption : KexProposalOption.VALUES) {
            int n4 = buffer.rpos();
            object = buffer.getString();
            if (bl2) {
                this.log.trace("receiveKexInit({})[{}] {}", new Object[]{this, kexProposalOption.getDescription(), object});
            }
            int n5 = buffer.rpos();
            int n6 = n5 - n4;
            map.put(kexProposalOption, object);
            n2 += n6;
        }
        KexExtensionHandler kexExtensionHandler = this.getKexExtensionHandler();
        if (kexExtensionHandler != null) {
            if (bl2) {
                this.log.trace("receiveKexInit({}) options before handler: {}", (Object)this, (Object)map);
            }
            kexExtensionHandler.handleKexInitProposal(this, false, map);
            if (bl2) {
                this.log.trace("receiveKexInit({}) options after handler: {}", (Object)this, (Object)map);
            }
        }
        this.firstKexPacketFollows = buffer.getBoolean();
        if (bl2) {
            this.log.trace("receiveKexInit({}) first kex packet follows: {}", (Object)this, (Object)this.firstKexPacketFollows);
        }
        if ((l2 = buffer.getUInt()) != 0L && bl2) {
            this.log.trace("receiveKexInit({}) non-zero reserved value: {}", (Object)this, (Object)l2);
        }
        object = new byte[n2];
        System.arraycopy(byArray2, 0, object, 0, n2);
        return object;
    }

    protected void prepareNewKeys() {
        Mac mac;
        Mac mac2;
        int n2;
        byte[] byArray = this.kex.getK();
        byte[] byArray2 = this.kex.getH();
        Digest digest = this.kex.getHash();
        boolean bl2 = this.log.isDebugEnabled();
        if (this.sessionId == null) {
            this.sessionId = (byte[])byArray2.clone();
            if (bl2) {
                this.log.debug("prepareNewKeys({}) session ID={}", (Object)this, (Object)BufferUtils.toHex(':', this.sessionId));
            }
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        byteArrayBuffer.putMPInt(byArray);
        byteArrayBuffer.putRawBytes(byArray2);
        ((Buffer)byteArrayBuffer).putByte((byte)65);
        byteArrayBuffer.putRawBytes(this.sessionId);
        int n3 = byteArrayBuffer.available();
        byte[] byArray3 = ((Buffer)byteArrayBuffer).array();
        digest.update(byArray3, 0, n3);
        byte[] byArray4 = digest.digest();
        int n4 = n2 = n3 - this.sessionId.length - 1;
        byArray3[n4] = (byte)(byArray3[n4] + 1);
        digest.update(byArray3, 0, n3);
        byte[] byArray5 = digest.digest();
        int n5 = n2;
        byArray3[n5] = (byte)(byArray3[n5] + 1);
        digest.update(byArray3, 0, n3);
        byte[] byArray6 = digest.digest();
        int n6 = n2;
        byArray3[n6] = (byte)(byArray3[n6] + 1);
        digest.update(byArray3, 0, n3);
        byte[] byArray7 = digest.digest();
        int n7 = n2;
        byArray3[n7] = (byte)(byArray3[n7] + 1);
        digest.update(byArray3, 0, n3);
        byte[] byArray8 = digest.digest();
        int n8 = n2;
        byArray3[n8] = (byte)(byArray3[n8] + 1);
        digest.update(byArray3, 0, n3);
        byte[] byArray9 = digest.digest();
        boolean bl3 = this.isServerSession();
        String string = this.getNegotiatedKexParameter(KexProposalOption.S2CENC);
        Cipher cipher = (Cipher)ValidateUtils.checkNotNull((Object)((Cipher)NamedFactory.create(this.getCipherFactories(), string)), "Unknown s2c cipher: %s", (Object)string);
        byArray7 = this.resizeKey(byArray7, cipher.getKdfSize(), digest, byArray, byArray2);
        if (cipher.getAuthenticationTagSize() == 0) {
            string = this.getNegotiatedKexParameter(KexProposalOption.S2CMAC);
            mac2 = (Mac)NamedFactory.create(this.getMacFactories(), string);
            if (mac2 == null) {
                throw new SshException(5, "Unknown s2c MAC: " + string);
            }
            byArray9 = this.resizeKey(byArray9, mac2.getBlockSize(), digest, byArray, byArray2);
            mac2.init(byArray9);
        } else {
            mac2 = null;
        }
        string = this.getNegotiatedKexParameter(KexProposalOption.S2CCOMP);
        Compression compression = (Compression)NamedFactory.create(this.getCompressionFactories(), string);
        if (compression == null) {
            throw new SshException(6, "Unknown s2c compression: " + string);
        }
        string = this.getNegotiatedKexParameter(KexProposalOption.C2SENC);
        Cipher cipher2 = (Cipher)ValidateUtils.checkNotNull((Object)((Cipher)NamedFactory.create(this.getCipherFactories(), string)), "Unknown c2s cipher: %s", (Object)string);
        byArray6 = this.resizeKey(byArray6, cipher2.getKdfSize(), digest, byArray, byArray2);
        if (cipher2.getAuthenticationTagSize() == 0) {
            string = this.getNegotiatedKexParameter(KexProposalOption.C2SMAC);
            mac = (Mac)NamedFactory.create(this.getMacFactories(), string);
            if (mac == null) {
                throw new SshException(5, "Unknown c2s MAC: " + string);
            }
            byArray8 = this.resizeKey(byArray8, mac.getBlockSize(), digest, byArray, byArray2);
            mac.init(byArray8);
        } else {
            mac = null;
        }
        string = this.getNegotiatedKexParameter(KexProposalOption.C2SCOMP);
        Compression compression2 = (Compression)NamedFactory.create(this.getCompressionFactories(), string);
        if (compression2 == null) {
            throw new SshException(6, "Unknown c2s compression: " + string);
        }
        if (bl3) {
            this.outSettings = new AbstractSession$MessageCodingSettings(cipher, mac2, compression, Cipher$Mode.Encrypt, byArray7, byArray5);
            this.inSettings = new AbstractSession$MessageCodingSettings(cipher2, mac, compression2, Cipher$Mode.Decrypt, byArray6, byArray4);
        } else {
            this.outSettings = new AbstractSession$MessageCodingSettings(cipher2, mac, compression2, Cipher$Mode.Encrypt, byArray6, byArray4);
            this.inSettings = new AbstractSession$MessageCodingSettings(cipher, mac2, compression, Cipher$Mode.Decrypt, byArray7, byArray5);
        }
    }

    protected void setOutputEncoding() {
        if (this.strictKex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("setOutputEncoding({}): strict KEX resets output message sequence number from {} to 0", (Object)this, (Object)this.seqo);
            }
            this.seqo = 0L;
        }
        this.outCipher = this.outSettings.getCipher(this.seqo);
        this.outMac = this.outSettings.getMac();
        this.outCompression = this.outSettings.getCompression();
        this.outSettings = null;
        this.outCipherSize = this.outCipher.getCipherBlockSize();
        this.outMacSize = this.outMac != null ? this.outMac.getBlockSize() : 0;
        this.outCompression.init(Compression$Type.Deflater, -1);
        this.maxRekeyBlocks.set(this.determineRekeyBlockLimit(this.inCipherSize, this.outCipherSize));
        this.outBytesCount.set(0L);
        this.outPacketsCount.set(0L);
        this.outBlocksCount.set(0L);
        this.lastKeyTimeValue.set(Instant.now());
        this.firstKexPacketFollows = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("setOutputEncoding({}): cipher {}; mac {}; compression {}; blocks limit {}", new Object[]{this, this.outCipher, this.outMac, this.outCompression, this.maxRekeyBlocks});
        }
    }

    protected void setInputEncoding() {
        if (this.strictKex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("setInputEncoding({}): strict KEX resets input message sequence number from {} to 0", (Object)this, (Object)this.seqi);
            }
            this.seqi = 0L;
        }
        this.inCipher = this.inSettings.getCipher(this.seqi);
        this.inMac = this.inSettings.getMac();
        this.inCompression = this.inSettings.getCompression();
        this.inSettings = null;
        this.inCipherSize = this.inCipher.getCipherBlockSize();
        this.inMacSize = this.inMac != null ? this.inMac.getBlockSize() : 0;
        this.inMacResult = new byte[this.inMacSize];
        this.inCompression.init(Compression$Type.Inflater, -1);
        this.maxRekeyBlocks.set(this.determineRekeyBlockLimit(this.inCipherSize, this.outCipherSize));
        this.inBytesCount.set(0L);
        this.inPacketsCount.set(0L);
        this.inBlocksCount.set(0L);
        this.lastKeyTimeValue.set(Instant.now());
        this.firstKexPacketFollows = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("setInputEncoding({}): cipher {}; mac {}; compression {}; blocks limit {}", new Object[]{this, this.inCipher, this.inMac, this.inCompression, this.maxRekeyBlocks});
        }
    }

    protected long determineRekeyBlockLimit(int n2, int n3) {
        long l2 = (Long)CoreModuleProperties.REKEY_BLOCKS_LIMIT.getRequired(this);
        if (l2 <= 0L) {
            int n4 = Math.min(this.inCipherSize, this.outCipherSize);
            l2 = n4 >= 16 ? 1L << Math.min(n4 * 2, 63) : 0x40000000L / (long)n4;
        }
        return l2;
    }

    protected IoWriteFuture notImplemented(int n2, Buffer buffer) {
        if (this.doInvokeUnimplementedMessageHandler(n2, buffer)) {
            return null;
        }
        return this.sendNotImplemented(this.seqi - 1L);
    }

    protected boolean removeValue(Map map, KexProposalOption kexProposalOption, String string) {
        String string2 = (String)map.get((Object)kexProposalOption);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(string2.split(",")));
        boolean bl2 = linkedHashSet.remove(string);
        if (bl2) {
            map.put(kexProposalOption, linkedHashSet.stream().collect(Collectors.joining(",")));
        }
        return bl2;
    }

    protected Map negotiate() {
        Map map;
        EnumMap<KexProposalOption, String> enumMap;
        Map map2;
        Map map3;
        block18: {
            map3 = this.getClientKexProposals();
            map2 = this.getServerKexProposals();
            this.signalNegotiationStart(map3, map2);
            map3 = new EnumMap(map3);
            map2 = new EnumMap(map2);
            boolean bl2 = this.removeValue(map3, KexProposalOption.ALGORITHMS, "kex-strict-c-v00@openssh.com");
            boolean bl3 = this.removeValue(map2, KexProposalOption.ALGORITHMS, "kex-strict-s-v00@openssh.com");
            if (this.removeValue(map3, KexProposalOption.ALGORITHMS, "kex-strict-s-v00@openssh.com") && !this.initialKexDone) {
                this.log.warn("negotiate({}) client proposal contains server flag {}; will be ignored", (Object)this, (Object)"kex-strict-s-v00@openssh.com");
            }
            if (this.removeValue(map2, KexProposalOption.ALGORITHMS, "kex-strict-c-v00@openssh.com") && !this.initialKexDone) {
                this.log.warn("negotiate({}) server proposal contains client flag {}; will be ignored", (Object)this, (Object)"kex-strict-c-v00@openssh.com");
            }
            map3 = Collections.unmodifiableMap(map3);
            map2 = Collections.unmodifiableMap(map2);
            enumMap = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
            map = Collections.unmodifiableMap(enumMap);
            try {
                boolean bl4 = this.log.isDebugEnabled();
                boolean bl5 = this.log.isTraceEnabled();
                if (!this.initialKexDone) {
                    boolean bl6 = this.strictKex = bl2 && bl3;
                    if (bl4) {
                        this.log.debug("negotiate({}) strict KEX={} client={} server={}", new Object[]{this, this.strictKex, bl2, bl3});
                    }
                    if (this.strictKex && this.initialKexInitSequenceNumber != 1L) {
                        throw new SshException(3, "Strict KEX negotiated but sequence number of first KEX_INIT received is not 1: " + this.initialKexInitSequenceNumber);
                    }
                }
                SessionDisconnectHandler sessionDisconnectHandler = this.getSessionDisconnectHandler();
                KexExtensionHandler kexExtensionHandler = this.getKexExtensionHandler();
                for (KexProposalOption kexProposalOption : KexProposalOption.VALUES) {
                    String string = (String)map3.get((Object)kexProposalOption);
                    String string2 = (String)map2.get((Object)kexProposalOption);
                    String[] stringArray = GenericUtils.split(string, ',');
                    String[] stringArray2 = GenericUtils.split(string2, ',');
                    for (String string3 : stringArray) {
                        Object object = stringArray2;
                        int n2 = ((String[])object).length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            String string4 = object[i2];
                            if (!string3.equals(string4)) continue;
                            enumMap.put(kexProposalOption, string3);
                            break;
                        }
                        if ((object = (String)enumMap.get((Object)kexProposalOption)) != null) break;
                    }
                    String object = (String)enumMap.get((Object)kexProposalOption);
                    if (kexExtensionHandler != null) {
                        kexExtensionHandler.handleKexExtensionNegotiation(this, kexProposalOption, object, map3, string, map2, string2);
                    }
                    if (object != null) {
                        if (!bl5) continue;
                        this.log.trace("negotiate({})[{}] guess={} (client={} / server={})", new Object[]{this, kexProposalOption.getDescription(), object, string, string2});
                        continue;
                    }
                    try {
                        if (sessionDisconnectHandler != null && sessionDisconnectHandler.handleKexDisconnectReason(this, map3, map2, map, kexProposalOption)) {
                            if (!bl4) continue;
                            this.log.debug("negotiate({}) ignore missing value for KEX option={}", (Object)this, (Object)kexProposalOption);
                            continue;
                        }
                    }
                    catch (IOException | RuntimeException string5) {
                        this.debug("negotiate({}) failed ({}) to invoke disconnect handler due to mismatched KEX option={}: {}", this, string5.getClass().getSimpleName(), (Object)kexProposalOption, string5.getMessage(), string5);
                    }
                    String string5 = "Unable to negotiate key exchange for " + kexProposalOption.getDescription() + " (client: " + string + " / server: " + string2 + ")";
                    if (KexProposalOption.S2CLANG.equals((Object)kexProposalOption) || KexProposalOption.C2SLANG.equals((Object)kexProposalOption)) {
                        if (!bl5) continue;
                        this.log.trace("negotiate({}) {}", (Object)this, (Object)string5);
                        continue;
                    }
                    throw new SshException(3, string5);
                }
                String string = (String)enumMap.get((Object)KexProposalOption.ALGORITHMS);
                if (!KexExtensions.IS_KEX_EXTENSION_SIGNAL.test(string)) break block18;
                if (sessionDisconnectHandler != null && sessionDisconnectHandler.handleKexDisconnectReason(this, map3, map2, map, KexProposalOption.ALGORITHMS)) {
                    if (bl4) {
                        this.log.debug("negotiate({}) ignore violating {} KEX option={}", new Object[]{this, KexProposalOption.ALGORITHMS, string});
                    }
                    break block18;
                }
                throw new SshException(3, "Illegal KEX option negotiated: " + (String)string);
            }
            catch (IOException | Error | RuntimeException throwable) {
                this.signalNegotiationEnd(map3, map2, map, throwable);
                throw throwable;
            }
        }
        this.signalNegotiationEnd(map3, map2, map, null);
        return this.setNegotiationResult(enumMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map setNegotiationResult(Map map) {
        Map map2 = this.negotiationResult;
        synchronized (map2) {
            if (!this.negotiationResult.isEmpty()) {
                this.negotiationResult.clear();
            }
            this.negotiationResult.putAll(map);
        }
        if (this.log.isDebugEnabled()) {
            map.forEach((kexProposalOption, string) -> this.log.debug("setNegotiationResult({}) Kex: {} = {}", new Object[]{this, kexProposalOption.getDescription(), string}));
        }
        return map;
    }

    protected void requestSuccess(Buffer buffer) {
        this.resetIdleTimeout();
        GlobalRequestFuture globalRequestFuture = (GlobalRequestFuture)this.pendingGlobalRequests.pollLast();
        if (globalRequestFuture != null) {
            ByteArrayBuffer byteArrayBuffer = ByteArrayBuffer.getCompactClone(buffer.array(), buffer.rpos(), buffer.available());
            GlobalRequestFuture$ReplyHandler globalRequestFuture$ReplyHandler = globalRequestFuture.getHandler();
            if (globalRequestFuture$ReplyHandler != null) {
                globalRequestFuture$ReplyHandler.accept(81, byteArrayBuffer);
            } else {
                globalRequestFuture.setValue(byteArrayBuffer);
            }
        }
    }

    protected void requestFailure(Buffer buffer) {
        this.resetIdleTimeout();
        GlobalRequestFuture globalRequestFuture = (GlobalRequestFuture)this.pendingGlobalRequests.pollLast();
        if (globalRequestFuture != null) {
            GlobalRequestFuture$ReplyHandler globalRequestFuture$ReplyHandler = globalRequestFuture.getHandler();
            if (globalRequestFuture$ReplyHandler != null) {
                ByteArrayBuffer byteArrayBuffer = ByteArrayBuffer.getCompactClone(buffer.array(), buffer.rpos(), buffer.available());
                globalRequestFuture$ReplyHandler.accept(82, byteArrayBuffer);
            } else {
                globalRequestFuture.setValue(new GlobalRequestException(82));
            }
        }
    }

    @Override
    public void addSessionListener(SessionListener sessionListener) {
        SessionListener.validateListener(sessionListener);
        if (!this.isOpen()) {
            this.log.warn("addSessionListener({})[{}] ignore registration while session is closing", (Object)this, (Object)sessionListener);
            return;
        }
        if (this.sessionListeners.add(sessionListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addSessionListener({})[{}] registered", (Object)this, (Object)sessionListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addSessionListener({})[{}] ignored duplicate", (Object)this, (Object)sessionListener);
        }
    }

    @Override
    public void removeSessionListener(SessionListener sessionListener) {
        if (sessionListener == null) {
            return;
        }
        SessionListener.validateListener(sessionListener);
        if (this.sessionListeners.remove(sessionListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeSessionListener({})[{}] removed", (Object)this, (Object)sessionListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeSessionListener({})[{}] not registered", (Object)this, (Object)sessionListener);
        }
    }

    @Override
    public SessionListener getSessionListenerProxy() {
        return this.sessionListenerProxy;
    }

    @Override
    public void addChannelListener(ChannelListener channelListener) {
        ChannelListener.validateListener(channelListener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while session is closing", (Object)this, (Object)channelListener);
            return;
        }
        if (this.channelListeners.add(channelListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)channelListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)channelListener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener channelListener) {
        if (channelListener == null) {
            return;
        }
        ChannelListener.validateListener(channelListener);
        if (this.channelListeners.remove(channelListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)channelListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)channelListener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.tunnelListenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        PortForwardingEventListener.validateListener(portForwardingEventListener);
        if (!this.isOpen()) {
            this.log.warn("addPortForwardingEventListener({})[{}] ignore registration while session is closing", (Object)this, (Object)portForwardingEventListener);
            return;
        }
        if (this.tunnelListeners.add(portForwardingEventListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addPortForwardingEventListener({})[{}] registered", (Object)this, (Object)portForwardingEventListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addPortForwardingEventListener({})[{}] ignored duplicate", (Object)this, (Object)portForwardingEventListener);
        }
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        if (portForwardingEventListener == null) {
            return;
        }
        PortForwardingEventListener.validateListener(portForwardingEventListener);
        if (this.tunnelListeners.remove(portForwardingEventListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removePortForwardingEventListener({})[{}] removed", (Object)this, (Object)portForwardingEventListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removePortForwardingEventListener({})[{}] not registered", (Object)this, (Object)portForwardingEventListener);
        }
    }

    @Override
    public KeyExchangeFuture reExchangeKeys() {
        try {
            this.requestNewKeysExchange();
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debug("reExchangeKeys({}) failed ({}) to request new keys: {}", this, generalSecurityException.getClass().getSimpleName(), generalSecurityException.getMessage(), generalSecurityException);
            throw (ProtocolException)ValidateUtils.initializeExceptionCause(new ProtocolException("Failed (" + generalSecurityException.getClass().getSimpleName() + ") to generate keys for exchange: " + generalSecurityException.getMessage()), generalSecurityException);
        }
        catch (Exception exception) {
            ExceptionUtils.rethrowAsIoException(exception);
            return null;
        }
        return (KeyExchangeFuture)ValidateUtils.checkNotNull((Object)((DefaultKeyExchangeFuture)this.kexFutureHolder.get()), "No current KEX future on state=%s", (Object)this.kexState);
    }

    protected KeyExchangeFuture checkRekey() {
        return this.isRekeyRequired() ? this.requestNewKeysExchange() : null;
    }

    protected KeyExchangeFuture requestNewKeysExchange() {
        boolean bl2 = (Boolean)this.kexHandler.updateState(() -> {
            boolean bl2;
            boolean bl3 = bl2 = !this.kexState.compareAndSet(KexState.DONE, KexState.INIT);
            if (!bl2) {
                this.kexHandler.initNewKeyExchange();
            }
            return bl2;
        });
        if (bl2) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("requestNewKeysExchange({}) KEX state not DONE: {}", (Object)this, (Object)this.kexState);
            }
            return null;
        }
        this.log.info("requestNewKeysExchange({}) Initiating key re-exchange", (Object)this);
        DefaultKeyExchangeFuture defaultKeyExchangeFuture = new DefaultKeyExchangeFuture(this.toString(), null);
        DefaultKeyExchangeFuture defaultKeyExchangeFuture2 = this.kexFutureHolder.getAndSet(defaultKeyExchangeFuture);
        if (defaultKeyExchangeFuture2 != null) {
            defaultKeyExchangeFuture2.setValue(new SshException("New KEX started while previous one still ongoing"));
        }
        this.sendKexInit();
        return defaultKeyExchangeFuture;
    }

    protected boolean isRekeyRequired() {
        if (!this.isOpen() || this.isClosing() || this.isClosed()) {
            return false;
        }
        KexState kexState = (KexState)((Object)this.kexState.get());
        if (!KexState.DONE.equals((Object)kexState)) {
            return false;
        }
        return this.isRekeyTimeIntervalExceeded() || this.isRekeyPacketCountsExceeded() || this.isRekeyBlocksCountExceeded() || this.isRekeyDataSizeExceeded();
    }

    protected boolean isRekeyTimeIntervalExceeded() {
        boolean bl2;
        if (GenericUtils.isNegativeOrNull(this.maxRekeyInterval)) {
            return false;
        }
        Instant instant = Instant.now();
        Duration duration = Duration.between((Temporal)this.lastKeyTimeValue.get(), instant);
        boolean bl3 = bl2 = duration.compareTo(this.maxRekeyInterval) > 0;
        if (bl2 && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyTimeIntervalExceeded({}) re-keying: last={}, now={}, diff={}, max={}", new Object[]{this, this.lastKeyTimeValue.get(), instant, duration, this.maxRekeyInterval});
        }
        return bl2;
    }

    protected boolean isRekeyPacketCountsExceeded() {
        boolean bl2;
        if (this.maxRekyPackets <= 0L) {
            return false;
        }
        boolean bl3 = bl2 = this.inPacketsCount.get() > this.maxRekyPackets || this.outPacketsCount.get() > this.maxRekyPackets;
        if (bl2 && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyPacketCountsExceeded({}) re-keying: in={}, out={}, max={}", new Object[]{this, this.inPacketsCount, this.outPacketsCount, this.maxRekyPackets});
        }
        return bl2;
    }

    protected boolean isRekeyDataSizeExceeded() {
        boolean bl2;
        if (this.maxRekeyBytes <= 0L) {
            return false;
        }
        boolean bl3 = bl2 = this.inBytesCount.get() > this.maxRekeyBytes || this.outBytesCount.get() > this.maxRekeyBytes;
        if (bl2 && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyDataSizeExceeded({}) re-keying: in={}, out={}, max={}", new Object[]{this, this.inBytesCount, this.outBytesCount, this.maxRekeyBytes});
        }
        return bl2;
    }

    protected boolean isRekeyBlocksCountExceeded() {
        boolean bl2;
        long l2 = this.maxRekeyBlocks.get();
        if (l2 <= 0L) {
            return false;
        }
        boolean bl3 = bl2 = this.inBlocksCount.get() > l2 || this.outBlocksCount.get() > l2;
        if (bl2 && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyBlocksCountExceeded({}) re-keying: in={}, out={}, max={}", new Object[]{this, this.inBlocksCount, this.outBlocksCount, l2});
        }
        return bl2;
    }

    @Override
    protected String resolveSessionKexProposal(String string) {
        String string2;
        String string3 = super.resolveSessionKexProposal(string);
        KexExtensionHandler kexExtensionHandler = this.getKexExtensionHandler();
        if (kexExtensionHandler == null || !kexExtensionHandler.isKexExtensionsAvailable(this, KexExtensionHandler$AvailabilityPhase.PROPOSAL)) {
            return string3;
        }
        String string4 = string2 = this.isServerSession() ? "ext-info-s" : "ext-info-c";
        if (GenericUtils.isEmpty(string3)) {
            return string2;
        }
        return string3 + "," + string2;
    }

    protected Map doStrictKexProposal(Map map) {
        String string;
        String string2 = (String)map.get((Object)KexProposalOption.ALGORITHMS);
        String string3 = string = this.isServerSession() ? "kex-strict-s-v00@openssh.com" : "kex-strict-c-v00@openssh.com";
        if (!this.initialKexDone) {
            string2 = GenericUtils.isEmpty(string2) ? string : string2 + "," + string;
        } else if (!GenericUtils.isEmpty(string2)) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string2.split(",")));
            String string4 = this.isServerSession() ? "ext-info-s" : "ext-info-c";
            boolean bl2 = arrayList.remove(string4);
            if (bl2 |= arrayList.remove(string)) {
                string2 = arrayList.stream().collect(Collectors.joining(","));
            }
        }
        map.put(KexProposalOption.ALGORITHMS, string2);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendKexInit() {
        byte[] byArray;
        Map map = this.doStrictKexProposal(this.getKexProposal());
        AtomicReference atomicReference = this.kexState;
        synchronized (atomicReference) {
            DefaultKeyExchangeFuture defaultKeyExchangeFuture = this.kexInitializedFuture;
            if (defaultKeyExchangeFuture == null) {
                this.kexInitializedFuture = defaultKeyExchangeFuture = new DefaultKeyExchangeFuture(this.toString(), null);
            }
            try {
                byArray = this.sendKexInit(map);
                this.setKexSeed(byArray);
                defaultKeyExchangeFuture.setValue(Boolean.TRUE);
            }
            catch (Exception exception) {
                defaultKeyExchangeFuture.setValue(exception);
                throw exception;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendKexInit({}) proposal={} seed: {}", new Object[]{this, map, BufferUtils.toHex(':', byArray)});
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getClientKexData() {
        AtomicReference atomicReference = this.kexState;
        synchronized (atomicReference) {
            return this.clientKexData == null ? null : (byte[])this.clientKexData.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClientKexData(byte[] byArray) {
        ValidateUtils.checkNotNullAndNotEmpty(byArray, "No client KEX seed");
        AtomicReference atomicReference = this.kexState;
        synchronized (atomicReference) {
            this.clientKexData = (byte[])byArray.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getServerKexData() {
        AtomicReference atomicReference = this.kexState;
        synchronized (atomicReference) {
            return this.serverKexData == null ? null : (byte[])this.serverKexData.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServerKexData(byte[] byArray) {
        ValidateUtils.checkNotNullAndNotEmpty(byArray, "No server KEX seed");
        AtomicReference atomicReference = this.kexState;
        synchronized (atomicReference) {
            this.serverKexData = (byte[])byArray.clone();
        }
    }

    protected abstract void setKexSeed(byte ... var1);

    protected abstract void checkKeys();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] receiveKexInit(Buffer buffer) {
        byte[] byArray;
        EnumMap enumMap = new EnumMap(KexProposalOption.class);
        if (!this.initialKexDone) {
            this.initialKexInitSequenceNumber = this.seqi;
        }
        AtomicReference atomicReference = this.kexState;
        synchronized (atomicReference) {
            byArray = this.receiveKexInit(buffer, enumMap);
            this.receiveKexInit(enumMap, byArray);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiveKexInit({}) proposal={} seed: {}", new Object[]{this, enumMap, BufferUtils.toHex(':', byArray)});
        }
        return byArray;
    }

    protected abstract void receiveKexInit(Map var1, byte[] var2);

    public static AbstractSession getSession(IoSession ioSession) {
        return AbstractSession.getSession(ioSession, false);
    }

    public static void attachSession(IoSession ioSession, AbstractSession abstractSession) {
        Objects.requireNonNull(ioSession, "No I/O session");
        Objects.requireNonNull(abstractSession, "No SSH session");
        Object object = ioSession.setAttributeIfAbsent(SESSION, abstractSession);
        if (object != null) {
            throw new MultipleAttachedSessionException("Multiple attached session to " + ioSession + ": " + object + " and " + abstractSession);
        }
    }

    public static AbstractSession getSession(IoSession ioSession, boolean bl2) {
        AbstractSession abstractSession = (AbstractSession)ioSession.getAttribute(SESSION);
        if (abstractSession == null && !bl2) {
            throw new MissingAttachedSessionException("No session attached to " + ioSession);
        }
        return abstractSession;
    }

    static /* synthetic */ Deque access$000(AbstractSession abstractSession) {
        return abstractSession.pendingGlobalRequests;
    }
}

