/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.agent.common.DefaultAgentForwardSupport;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.channel.exception.SshChannelNotFoundException;
import org.apache.sshd.common.channel.exception.SshChannelOpenException;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.forward.ForwarderFactory;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHeartbeatController$HeartbeatType;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.session.helpers.AbstractConnectionService$1;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.functors.Int2IntFunction;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.x11.DefaultX11ForwardSupport;
import org.apache.sshd.server.x11.X11ForwardSupport;
import org.slf4j.Logger;

public abstract class AbstractConnectionService
extends AbstractInnerCloseable
implements ConnectionService {
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add(8);
    public static final String DEFAULT_SESSION_IGNORE_HEARTBEAT_STRING = "ignore@sshd.apache.org";
    protected final Map channels = new ConcurrentHashMap();
    protected final AtomicLong nextChannelId = new AtomicLong(0L);
    protected final AtomicLong heartbeatCount = new AtomicLong(0L);
    private ScheduledFuture heartBeat;
    private final AtomicReference agentForwardHolder = new AtomicReference();
    private final AtomicReference x11ForwardHolder = new AtomicReference();
    private final AtomicReference forwarderHolder = new AtomicReference();
    private final AtomicBoolean allowMoreSessions = new AtomicBoolean(true);
    private final Collection listeners = new CopyOnWriteArraySet();
    private final Collection managersHolder = new CopyOnWriteArraySet();
    private final Map properties = new ConcurrentHashMap();
    private final PortForwardingEventListener listenerProxy;
    private final AbstractSession sessionInstance;
    private UnknownChannelReferenceHandler unknownChannelReferenceHandler;

    protected AbstractConnectionService(AbstractSession abstractSession) {
        this.sessionInstance = Objects.requireNonNull(abstractSession, "No session");
        this.listenerProxy = (PortForwardingEventListener)EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.listeners);
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        this.listeners.add(PortForwardingEventListener.validateListener(portForwardingEventListener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        if (portForwardingEventListener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(portForwardingEventListener));
    }

    @Override
    public UnknownChannelReferenceHandler getUnknownChannelReferenceHandler() {
        return this.unknownChannelReferenceHandler;
    }

    @Override
    public void setUnknownChannelReferenceHandler(UnknownChannelReferenceHandler unknownChannelReferenceHandler) {
        this.unknownChannelReferenceHandler = unknownChannelReferenceHandler;
    }

    @Override
    public Collection getRegisteredManagers() {
        return this.managersHolder.isEmpty() ? Collections.emptyList() : new ArrayList(this.managersHolder);
    }

    @Override
    public boolean addPortForwardingEventListenerManager(PortForwardingEventListenerManager portForwardingEventListenerManager) {
        return this.managersHolder.add(Objects.requireNonNull(portForwardingEventListenerManager, "No manager"));
    }

    @Override
    public boolean removePortForwardingEventListenerManager(PortForwardingEventListenerManager portForwardingEventListenerManager) {
        if (portForwardingEventListenerManager == null) {
            return false;
        }
        return this.managersHolder.remove(portForwardingEventListenerManager);
    }

    public Collection getChannels() {
        return this.channels.values();
    }

    @Override
    public AbstractSession getSession() {
        return this.sessionInstance;
    }

    @Override
    public void start() {
        this.heartBeat = this.startHeartBeat();
    }

    protected synchronized ScheduledFuture startHeartBeat() {
        this.stopHeartBeat();
        SessionHeartbeatController$HeartbeatType sessionHeartbeatController$HeartbeatType = this.getSessionHeartbeatType();
        Duration duration = this.getSessionHeartbeatInterval();
        AbstractSession abstractSession = this.getSession();
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("startHeartbeat({}) heartbeat type={}, interval={}", new Object[]{abstractSession, sessionHeartbeatController$HeartbeatType, duration});
        }
        if (sessionHeartbeatController$HeartbeatType == null || sessionHeartbeatController$HeartbeatType == SessionHeartbeatController$HeartbeatType.NONE || GenericUtils.isNegativeOrNull(duration)) {
            return null;
        }
        FactoryManager factoryManager = abstractSession.getFactoryManager();
        ScheduledExecutorService scheduledExecutorService = factoryManager.getScheduledExecutorService();
        return scheduledExecutorService.scheduleAtFixedRate(this::sendHeartBeat, duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected boolean sendHeartBeat() {
        SessionHeartbeatController$HeartbeatType sessionHeartbeatController$HeartbeatType = this.getSessionHeartbeatType();
        Duration duration = this.getSessionHeartbeatInterval();
        AbstractSession abstractSession = this.getSession();
        boolean bl2 = this.log.isTraceEnabled();
        if (bl2) {
            this.log.trace("sendHeartbeat({}) heartbeat type={}, interval={}", new Object[]{abstractSession, sessionHeartbeatController$HeartbeatType, duration});
        }
        if (sessionHeartbeatController$HeartbeatType == null || GenericUtils.isNegativeOrNull(duration) || this.heartBeat == null) {
            return false;
        }
        KexState kexState = abstractSession.getKexState();
        if (sessionHeartbeatController$HeartbeatType != SessionHeartbeatController$HeartbeatType.NONE && kexState != KexState.DONE) {
            if (bl2) {
                this.log.trace("sendHeartbeat({}) heartbeat type={}, interval={} - skip due to KEX state={}", new Object[]{abstractSession, sessionHeartbeatController$HeartbeatType, duration, kexState});
            }
            return false;
        }
        try {
            switch (sessionHeartbeatController$HeartbeatType) {
                case NONE: {
                    return false;
                }
                case IGNORE: {
                    Buffer buffer = abstractSession.createBuffer((byte)2, DEFAULT_SESSION_IGNORE_HEARTBEAT_STRING.length() + 8);
                    buffer.putString(DEFAULT_SESSION_IGNORE_HEARTBEAT_STRING);
                    IoWriteFuture ioWriteFuture = abstractSession.writePacket(buffer);
                    ioWriteFuture.addListener(this::futureDone);
                    return true;
                }
                case RESERVED: {
                    ReservedSessionMessagesHandler reservedSessionMessagesHandler = Objects.requireNonNull(abstractSession.getReservedSessionMessagesHandler(), "No customized heartbeat handler registered");
                    return reservedSessionMessagesHandler.sendReservedHeartbeat(this);
                }
            }
            throw new UnsupportedOperationException("Unsupported heartbeat type: " + (Object)((Object)sessionHeartbeatController$HeartbeatType));
        }
        catch (Throwable throwable) {
            abstractSession.exceptionCaught(throwable);
            this.warn("sendHeartBeat({}) failed ({}) to send heartbeat #{} request={}: {}", abstractSession, throwable.getClass().getSimpleName(), this.heartbeatCount, (Object)sessionHeartbeatController$HeartbeatType, throwable.getMessage(), throwable);
            return false;
        }
    }

    protected void futureDone(IoWriteFuture ioWriteFuture) {
        Throwable throwable = ioWriteFuture.getException();
        if (throwable != null) {
            AbstractSession abstractSession = this.getSession();
            abstractSession.exceptionCaught(throwable);
        }
    }

    protected synchronized void stopHeartBeat() {
        boolean bl2 = this.log.isDebugEnabled();
        AbstractSession abstractSession = this.getSession();
        if (this.heartBeat == null) {
            if (bl2) {
                this.log.debug("stopHeartBeat({}) no heartbeat to stop", (Object)abstractSession);
            }
            return;
        }
        if (bl2) {
            this.log.debug("stopHeartBeat({}) stopping", (Object)abstractSession);
        }
        try {
            this.heartBeat.cancel(true);
        }
        finally {
            this.heartBeat = null;
        }
        if (bl2) {
            this.log.debug("stopHeartBeat({}) stopped", (Object)abstractSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Forwarder getForwarder() {
        Forwarder forwarder;
        AbstractSession abstractSession = this.getSession();
        AtomicReference atomicReference = this.forwarderHolder;
        synchronized (atomicReference) {
            forwarder = (Forwarder)this.forwarderHolder.get();
            if (forwarder != null) {
                return forwarder;
            }
            forwarder = (Forwarder)ValidateUtils.checkNotNull((Object)this.createForwardingFilter(abstractSession), "No forwarder created for %s", (Object)abstractSession);
            this.forwarderHolder.set(forwarder);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getForwardingFilter({}) created instance", (Object)abstractSession);
        }
        return forwarder;
    }

    @Override
    protected void preClose() {
        this.stopHeartBeat();
        this.listeners.clear();
        this.managersHolder.clear();
        super.preClose();
    }

    protected Forwarder createForwardingFilter(Session session) {
        FactoryManager factoryManager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        ForwarderFactory forwarderFactory = Objects.requireNonNull(factoryManager.getForwarderFactory(), "No forwarder factory");
        Forwarder forwarder = forwarderFactory.create(this);
        forwarder.addPortForwardingEventListenerManager(this);
        return forwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X11ForwardSupport getX11ForwardSupport() {
        X11ForwardSupport x11ForwardSupport;
        AbstractSession abstractSession = this.getSession();
        AtomicReference atomicReference = this.x11ForwardHolder;
        synchronized (atomicReference) {
            x11ForwardSupport = (X11ForwardSupport)this.x11ForwardHolder.get();
            if (x11ForwardSupport != null) {
                return x11ForwardSupport;
            }
            x11ForwardSupport = (X11ForwardSupport)ValidateUtils.checkNotNull((Object)this.createX11ForwardSupport(abstractSession), "No X11 forwarder created for %s", (Object)abstractSession);
            this.x11ForwardHolder.set(x11ForwardSupport);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getX11ForwardSupport({}) created instance", (Object)abstractSession);
        }
        return x11ForwardSupport;
    }

    protected X11ForwardSupport createX11ForwardSupport(Session session) {
        return new DefaultX11ForwardSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentForwardSupport getAgentForwardSupport() {
        AgentForwardSupport agentForwardSupport;
        AbstractSession abstractSession = this.getSession();
        AtomicReference atomicReference = this.agentForwardHolder;
        synchronized (atomicReference) {
            agentForwardSupport = (AgentForwardSupport)this.agentForwardHolder.get();
            if (agentForwardSupport != null) {
                return agentForwardSupport;
            }
            agentForwardSupport = (AgentForwardSupport)ValidateUtils.checkNotNull((Object)this.createAgentForwardSupport(abstractSession), "No agent forward created for %s", (Object)abstractSession);
            this.agentForwardHolder.set(agentForwardSupport);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getAgentForwardSupport({}) created instance", (Object)abstractSession);
        }
        return agentForwardSupport;
    }

    protected AgentForwardSupport createAgentForwardSupport(Session session) {
        return new DefaultAgentForwardSupport(this);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential((Closeable)this.forwarderHolder.get(), (Closeable)this.agentForwardHolder.get(), (Closeable)this.x11ForwardHolder.get()).parallel(this.toString(), this.getChannels()).build();
    }

    protected long getNextChannelId() {
        return this.nextChannelId.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long registerChannel(Channel channel) {
        AbstractSession abstractSession = this.getSession();
        int n2 = (Integer)CoreModuleProperties.MAX_CONCURRENT_CHANNELS.getRequired(this);
        int n3 = this.channels.size();
        if (n3 > n2) {
            throw new IllegalStateException("Currently active channels (" + n3 + ") at max.: " + n2);
        }
        long l2 = this.getNextChannelId();
        channel.init(this, abstractSession, l2);
        boolean bl2 = false;
        Map map = this.channels;
        synchronized (map) {
            if (!this.isClosing()) {
                this.channels.put(l2, channel);
                bl2 = true;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("registerChannel({})[id={}, registered={}] {}", new Object[]{this, l2, bl2, channel});
        }
        channel.handleChannelRegistrationResult(this, abstractSession, l2, bl2);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterChannel(Channel channel) {
        Channel channel2;
        long l2 = channel.getChannelId();
        Map map = this.channels;
        synchronized (map) {
            channel2 = (Channel)this.channels.remove(l2);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("unregisterChannel({}) result={}", (Object)channel, (Object)channel2);
        }
        if (channel2 != null) {
            channel2.handleChannelUnregistration(this);
        }
    }

    @Override
    public void process(int n2, Buffer buffer) {
        switch (n2) {
            case 90: {
                this.channelOpen(buffer);
                break;
            }
            case 91: {
                this.channelOpenConfirmation(buffer);
                break;
            }
            case 92: {
                this.channelOpenFailure(buffer);
                break;
            }
            case 98: {
                this.channelRequest(buffer);
                break;
            }
            case 94: {
                this.channelData(buffer);
                break;
            }
            case 95: {
                this.channelExtendedData(buffer);
                break;
            }
            case 100: {
                this.channelFailure(buffer);
                break;
            }
            case 99: {
                this.channelSuccess(buffer);
                break;
            }
            case 93: {
                this.channelWindowAdjust(buffer);
                break;
            }
            case 96: {
                this.channelEof(buffer);
                break;
            }
            case 97: {
                this.channelClose(buffer);
                break;
            }
            case 80: {
                this.globalRequest(buffer);
                break;
            }
            case 81: {
                this.requestSuccess(buffer);
                break;
            }
            case 82: {
                this.requestFailure(buffer);
                break;
            }
            default: {
                AbstractSession abstractSession = this.getSession();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Unsupported command: {}", (Object)abstractSession, (Object)SshConstants.getCommandMessageName(n2));
                }
                abstractSession.notImplemented(n2, buffer);
            }
        }
    }

    @Override
    public boolean isAllowMoreSessions() {
        return this.allowMoreSessions.get();
    }

    @Override
    public void setAllowMoreSessions(boolean bl2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setAllowMoreSessions({}): {}", (Object)this, (Object)bl2);
        }
        this.allowMoreSessions.set(bl2);
    }

    public void channelOpenConfirmation(Buffer buffer) {
        Channel channel = this.getChannel((byte)91, buffer);
        if (channel == null) {
            return;
        }
        long l2 = buffer.getUInt();
        long l3 = buffer.getUInt();
        long l4 = buffer.getUInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("channelOpenConfirmation({}) SSH_MSG_CHANNEL_OPEN_CONFIRMATION sender={}, window-size={}, packet-size={}", new Object[]{channel, l2, l3, l4});
        }
        channel.handleOpenSuccess(l2, l3, l4, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelOpenFailure(Buffer buffer) {
        Channel channel;
        AbstractClientChannel abstractClientChannel = (AbstractClientChannel)this.getChannel((byte)92, buffer);
        if (abstractClientChannel == null) {
            return;
        }
        long l2 = abstractClientChannel.getChannelId();
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("channelOpenFailure({}) Received SSH_MSG_CHANNEL_OPEN_FAILURE", (Object)abstractClientChannel);
        }
        Map map = this.channels;
        synchronized (map) {
            channel = (Channel)this.channels.remove(l2);
        }
        if (bl2) {
            this.log.debug("channelOpenFailure({}) unregistered {}", (Object)abstractClientChannel, (Object)channel);
        }
        abstractClientChannel.handleOpenFailure(buffer);
    }

    public void channelData(Buffer buffer) {
        Channel channel = this.getChannel((byte)94, buffer);
        if (channel == null) {
            return;
        }
        channel.handleData(buffer);
    }

    public void channelExtendedData(Buffer buffer) {
        Channel channel = this.getChannel((byte)95, buffer);
        if (channel == null) {
            return;
        }
        channel.handleExtendedData(buffer);
    }

    public void channelWindowAdjust(Buffer buffer) {
        Channel channel = this.getChannel((byte)93, buffer);
        if (channel == null) {
            return;
        }
        channel.handleWindowAdjust(buffer);
    }

    public void channelEof(Buffer buffer) {
        Channel channel = this.getChannel((byte)96, buffer);
        if (channel == null) {
            return;
        }
        channel.handleEof();
    }

    public void channelClose(Buffer buffer) {
        Channel channel = this.getChannel((byte)97, buffer);
        if (channel == null) {
            return;
        }
        channel.handleClose();
    }

    public void channelRequest(Buffer buffer) {
        Channel channel = this.getChannel((byte)98, buffer);
        if (channel == null) {
            return;
        }
        channel.handleRequest(buffer);
    }

    public void channelFailure(Buffer buffer) {
        Channel channel = this.getChannel((byte)100, buffer);
        if (channel == null) {
            return;
        }
        channel.handleFailure();
    }

    public void channelSuccess(Buffer buffer) {
        Channel channel = this.getChannel((byte)99, buffer);
        if (channel == null) {
            return;
        }
        channel.handleSuccess();
    }

    protected Channel getChannel(byte by, Buffer buffer) {
        return this.getChannel(by, buffer.getUInt(), buffer);
    }

    protected Channel getChannel(byte by, long l2, Buffer buffer) {
        Channel channel = (Channel)this.channels.get(l2);
        if (channel != null) {
            return channel;
        }
        UnknownChannelReferenceHandler unknownChannelReferenceHandler = this.resolveUnknownChannelReferenceHandler();
        if (unknownChannelReferenceHandler == null) {
            throw new SshChannelNotFoundException(l2, "Received " + SshConstants.getCommandMessageName(by) + " on unknown channel " + l2);
        }
        channel = unknownChannelReferenceHandler.handleUnknownChannelCommand(this, by, l2, buffer);
        return channel;
    }

    @Override
    public UnknownChannelReferenceHandler resolveUnknownChannelReferenceHandler() {
        UnknownChannelReferenceHandler unknownChannelReferenceHandler = this.getUnknownChannelReferenceHandler();
        if (unknownChannelReferenceHandler != null) {
            return unknownChannelReferenceHandler;
        }
        AbstractSession abstractSession = this.getSession();
        return abstractSession == null ? null : abstractSession.resolveUnknownChannelReferenceHandler();
    }

    protected void channelOpen(Buffer buffer) {
        FactoryManager factoryManager;
        String string = buffer.getString();
        long l2 = buffer.getUInt();
        long l3 = buffer.getUInt();
        long l4 = buffer.getUInt();
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("channelOpen({}) SSH_MSG_CHANNEL_OPEN sender={}, type={}, window-size={}, packet-size={}", new Object[]{this, l2, string, l3, l4});
        }
        if (this.isClosing()) {
            this.sendChannelOpenFailure(buffer, l2, 2, "Server is shutting down while attempting to open channel type=" + string, "");
            return;
        }
        if (!this.isAllowMoreSessions()) {
            this.sendChannelOpenFailure(buffer, l2, 2, "additional sessions disabled", "");
            return;
        }
        AbstractSession abstractSession = this.getSession();
        Channel channel = ChannelFactory.createChannel(abstractSession, (factoryManager = Objects.requireNonNull(abstractSession.getFactoryManager(), "No factory manager")).getChannelFactories(), string);
        if (channel == null) {
            this.sendChannelOpenFailure(buffer, l2, 3, "Unsupported channel type: " + string, "");
            return;
        }
        long l5 = this.registerChannel(channel);
        channel.addChannelListener(new AbstractConnectionService$1(this, bl2, l2, l5, abstractSession));
        OpenFuture openFuture2 = channel.open(l2, l3, l4, buffer);
        openFuture2.addListener(openFuture -> {
            try {
                if (!openFuture.isOpened()) {
                    int n2 = 0;
                    String string = "Generic error while opening channel: " + l5;
                    Throwable throwable = openFuture.getException();
                    if (throwable != null) {
                        if (throwable instanceof SshChannelOpenException) {
                            n2 = ((SshChannelOpenException)throwable).getReasonCode();
                        } else {
                            string = throwable.getClass().getSimpleName() + " while opening channel: " + string;
                        }
                    } else {
                        this.log.warn("operationComplete({}) no exception on closed future={}", (Object)this, (Object)openFuture);
                    }
                    Buffer buffer = abstractSession.createBuffer((byte)92, string.length() + 64);
                    this.sendChannelOpenFailure(buffer, l2, n2, string, "");
                }
            }
            catch (IOException iOException) {
                this.warn("operationComplete({}) {}: {}", this, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
                abstractSession.exceptionCaught(iOException);
            }
        });
    }

    protected IoWriteFuture sendChannelOpenFailure(Buffer buffer, long l2, int n2, String string, String string2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendChannelOpenFailure({}) sender={}, reason={}, lang={}, message='{}'", new Object[]{this, l2, SshConstants.getOpenErrorCodeName(n2), string2, string});
        }
        AbstractSession abstractSession = this.getSession();
        Buffer buffer2 = abstractSession.createBuffer((byte)92, 64 + GenericUtils.length(string) + GenericUtils.length(string2));
        buffer2.putUInt(l2);
        buffer2.putUInt(n2);
        buffer2.putString(string);
        buffer2.putString(string2);
        return abstractSession.writePacket(buffer2);
    }

    protected IoWriteFuture globalRequest(Buffer buffer) {
        AbstractSession abstractSession;
        FactoryManager factoryManager;
        List list;
        String string = buffer.getString();
        boolean bl2 = buffer.getBoolean();
        boolean bl3 = this.log.isDebugEnabled();
        if (bl3) {
            this.log.debug("globalRequest({}) received SSH_MSG_GLOBAL_REQUEST {} want-reply={}", new Object[]{this, string, bl2});
        }
        if (GenericUtils.size(list = (factoryManager = Objects.requireNonNull((abstractSession = this.getSession()).getFactoryManager(), "No factory manager")).getGlobalRequestHandlers()) > 0) {
            boolean bl4 = this.log.isTraceEnabled();
            for (RequestHandler requestHandler : list) {
                RequestHandler$Result requestHandler$Result;
                try {
                    requestHandler$Result = requestHandler.process(this, string, bl2, buffer);
                }
                catch (Throwable throwable) {
                    this.warn("globalRequest({})[{}, want-reply={}] failed ({}) to process: {}", this, string, bl2, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
                    requestHandler$Result = RequestHandler$Result.ReplyFailure;
                }
                if (RequestHandler$Result.Unsupported.equals((Object)requestHandler$Result)) {
                    if (!bl4) continue;
                    this.log.trace("globalRequest({}) {}#process({})[want-reply={}] : {}", new Object[]{this, requestHandler.getClass().getSimpleName(), string, bl2, requestHandler$Result});
                    continue;
                }
                return this.sendGlobalResponse(buffer, string, requestHandler$Result, bl2);
            }
        }
        return this.handleUnknownRequest(buffer, string, bl2);
    }

    protected IoWriteFuture handleUnknownRequest(Buffer buffer, String string, boolean bl2) {
        this.log.warn("handleUnknownRequest({}) unknown global request: {}", (Object)this, (Object)string);
        return this.sendGlobalResponse(buffer, string, RequestHandler$Result.Unsupported, bl2);
    }

    protected IoWriteFuture sendGlobalResponse(Buffer buffer, String string, RequestHandler$Result requestHandler$Result, boolean bl2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendGlobalResponse({})[{}] result={}, want-reply={}", new Object[]{this, string, requestHandler$Result, bl2});
        }
        if (RequestHandler$Result.Replied.equals((Object)requestHandler$Result) || !bl2) {
            return AbstractIoWriteFuture.fulfilled(string, Boolean.TRUE);
        }
        byte by = RequestHandler$Result.ReplySuccess.equals((Object)requestHandler$Result) ? (byte)81 : 82;
        AbstractSession abstractSession = this.getSession();
        Buffer buffer2 = abstractSession.createBuffer(by, 2);
        return abstractSession.writePacket(buffer2);
    }

    protected void requestSuccess(Buffer buffer) {
        AbstractSession abstractSession = this.getSession();
        abstractSession.requestSuccess(buffer);
    }

    protected void requestFailure(Buffer buffer) {
        AbstractSession abstractSession = this.getSession();
        abstractSession.requestFailure(buffer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSession() + "]";
    }

    static /* synthetic */ Logger access$000(AbstractConnectionService abstractConnectionService) {
        return abstractConnectionService.log;
    }

    static /* synthetic */ void access$100(AbstractConnectionService abstractConnectionService, String string, Object object, Object object2, Object object3, Throwable throwable) {
        abstractConnectionService.warn(string, object, object2, object3, throwable);
    }
}

