/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.session.SessionHeartbeatController$HeartbeatType;

public interface SessionHeartbeatController
extends PropertyResolver {
    default public SessionHeartbeatController$HeartbeatType getSessionHeartbeatType() {
        return (SessionHeartbeatController$HeartbeatType)((Object)CommonModuleProperties.SESSION_HEARTBEAT_TYPE.getRequired(this));
    }

    default public Duration getSessionHeartbeatInterval() {
        return (Duration)CommonModuleProperties.SESSION_HEARTBEAT_INTERVAL.getRequired(this);
    }

    default public void disableSessionHeartbeat() {
        this.setSessionHeartbeat(SessionHeartbeatController$HeartbeatType.NONE, Duration.ZERO);
    }

    default public void setSessionHeartbeat(SessionHeartbeatController$HeartbeatType sessionHeartbeatController$HeartbeatType, TimeUnit timeUnit, long l2) {
        Objects.requireNonNull(timeUnit, "No heartbeat time unit provided");
        this.setSessionHeartbeat(sessionHeartbeatController$HeartbeatType, Duration.ofMillis(TimeUnit.MILLISECONDS.convert(l2, timeUnit)));
    }

    default public void setSessionHeartbeat(SessionHeartbeatController$HeartbeatType sessionHeartbeatController$HeartbeatType, Duration duration) {
        Objects.requireNonNull(sessionHeartbeatController$HeartbeatType, "No heartbeat type specified");
        Objects.requireNonNull(duration, "No heartbeat time interval provided");
        CommonModuleProperties.SESSION_HEARTBEAT_TYPE.set(this, (Object)sessionHeartbeatController$HeartbeatType);
        CommonModuleProperties.SESSION_HEARTBEAT_INTERVAL.set(this, duration);
    }
}

