/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.Map;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.auth.UsernameHolder;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.compression.CompressionInformation;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.net.ConnectionEndpointsIndicator;

public interface SessionContext
extends AttributeStore,
Closeable,
UsernameHolder,
SessionHeartbeatController,
ConnectionEndpointsIndicator {
    public static final String DEFAULT_SSH_VERSION_PREFIX = "SSH-2.0-";
    public static final String FALLBACK_SSH_VERSION_PREFIX = "SSH-1.99-";
    public static final int MAX_VERSION_LINE_LENGTH = 256;

    public byte[] getSessionId();

    public boolean isServerSession();

    public String getClientVersion();

    public Map getClientKexProposals();

    public String getServerVersion();

    public Map getServerKexProposals();

    public KexState getKexState();

    public Map getKexNegotiationResult();

    public String getNegotiatedKexParameter(KexProposalOption var1);

    public CipherInformation getCipherInformation(boolean var1);

    public CompressionInformation getCompressionInformation(boolean var1);

    public MacInformation getMacInformation(boolean var1);

    public boolean isAuthenticated();

    public static boolean isValidVersionPrefix(String string) {
        return GenericUtils.isNotEmpty(string) && (string.startsWith(DEFAULT_SSH_VERSION_PREFIX) || string.startsWith(FALLBACK_SSH_VERSION_PREFIX));
    }

    public static boolean isSecureSessionTransport(SessionContext sessionContext) {
        if (sessionContext == null) {
            return false;
        }
        for (KexProposalOption kexProposalOption : KexProposalOption.CIPHER_PROPOSALS) {
            String string = sessionContext.getNegotiatedKexParameter(kexProposalOption);
            if (!GenericUtils.isEmpty(string) && !"none".equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDataIntegrityTransport(SessionContext sessionContext) {
        if (sessionContext == null) {
            return false;
        }
        for (KexProposalOption kexProposalOption : KexProposalOption.MAC_PROPOSALS) {
            String string = sessionContext.getNegotiatedKexParameter(kexProposalOption);
            if (!GenericUtils.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidSessionPayloadSize(long l2) {
        return l2 >= 0L && l2 < 0x7FFFFFF2L;
    }

    public static long validateSessionPayloadSize(long l2, String string) {
        ValidateUtils.checkTrue(SessionContext.isValidSessionPayloadSize(l2), string, l2);
        return l2;
    }
}

