/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerHolder;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.auth.MutableUserHolder;
import org.apache.sshd.common.channel.ChannelListenerManager;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolverManager;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.forward.PortForwardingInformationProvider;
import org.apache.sshd.common.future.GlobalRequestFuture;
import org.apache.sshd.common.future.GlobalRequestFuture$ReplyHandler;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.session.ReservedSessionMessagesManager;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionDisconnectHandlerManager;
import org.apache.sshd.common.session.SessionListenerManager;
import org.apache.sshd.common.session.UnknownChannelReferenceHandlerManager;
import org.apache.sshd.common.session.helpers.TimeoutIndicator;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public interface Session
extends FactoryManagerHolder,
MutableUserHolder,
ChannelListenerManager,
ChannelStreamWriterResolverManager,
PortForwardingEventListenerManager,
PortForwardingInformationProvider,
KexFactoryManager,
ReservedSessionMessagesManager,
SessionContext,
SessionDisconnectHandlerManager,
SessionListenerManager,
UnknownChannelReferenceHandlerManager {
    default public Buffer createBuffer(byte by) {
        return this.createBuffer(by, 0);
    }

    public Buffer createBuffer(byte var1, int var2);

    public Buffer prepareBuffer(byte var1, Buffer var2);

    public IoWriteFuture sendDebugMessage(boolean var1, Object var2, String var3);

    public IoWriteFuture sendIgnoreMessage(byte ... var1);

    public IoWriteFuture writePacket(Buffer var1);

    default public IoWriteFuture writePacket(Buffer buffer, Duration duration) {
        Objects.requireNonNull(duration, "No timeout was specified");
        return this.writePacket(buffer, duration.toMillis());
    }

    default public IoWriteFuture writePacket(Buffer buffer, long l2) {
        return this.writePacket(buffer, l2, TimeUnit.MILLISECONDS);
    }

    public IoWriteFuture writePacket(Buffer var1, long var2, TimeUnit var4);

    default public Buffer request(String string, Buffer buffer, long l2, TimeUnit timeUnit) {
        ValidateUtils.checkTrue(l2 > 0L, "Non-positive timeout requested: %d", l2);
        return this.request(string, buffer, TimeUnit.MILLISECONDS.convert(l2, timeUnit));
    }

    default public Buffer request(String string, Buffer buffer, Duration duration) {
        Objects.requireNonNull(duration, "No timeout specified");
        return this.request(string, buffer, duration.toMillis());
    }

    public Buffer request(String var1, Buffer var2, long var3);

    public GlobalRequestFuture request(Buffer var1, String var2, GlobalRequestFuture$ReplyHandler var3);

    public void exceptionCaught(Throwable var1);

    public KeyExchangeFuture reExchangeKeys();

    public Service getService(Class var1);

    public IoSession getIoSession();

    @Override
    default public SocketAddress getLocalAddress() {
        IoSession ioSession = this.getIoSession();
        return ioSession == null ? null : ioSession.getLocalAddress();
    }

    @Override
    default public SocketAddress getRemoteAddress() {
        IoSession ioSession = this.getIoSession();
        return ioSession == null ? null : ioSession.getRemoteAddress();
    }

    public TimeoutIndicator getTimeoutStatus();

    public Duration getIdleTimeout();

    public Instant getIdleTimeoutStart();

    public Instant resetIdleTimeout();

    public Duration getAuthTimeout();

    public Instant getAuthTimeoutStart();

    public Instant resetAuthTimeout();

    public void setAuthenticated();

    public KeyExchange getKex();

    public void disconnect(int var1, String var2);

    public void startService(String var1, Buffer var2);

    @Override
    default public Object resolveAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        return Session.resolveAttribute(this, attributeRepository$AttributeKey);
    }

    public static Object resolveAttribute(Session session, AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        Objects.requireNonNull(attributeRepository$AttributeKey, "No key");
        if (session == null) {
            return null;
        }
        Object object = session.getAttribute(attributeRepository$AttributeKey);
        return object != null ? object : FactoryManager.resolveAttribute(session.getFactoryManager(), attributeRepository$AttributeKey);
    }
}

