/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractConnectionServiceFactory
extends AbstractLoggingBean
implements PortForwardingEventListenerManager {
    private final Collection listeners = new CopyOnWriteArraySet();
    private final PortForwardingEventListener listenerProxy = (PortForwardingEventListener)EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.listeners);

    protected AbstractConnectionServiceFactory() {
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        this.listeners.add(Objects.requireNonNull(portForwardingEventListener, "No listener to add"));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        if (portForwardingEventListener == null) {
            return;
        }
        this.listeners.remove(portForwardingEventListener);
    }
}

