/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.random;

import java.util.Objects;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.random.AbstractRandom;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.random.RandomFactory;

public class SingletonRandomFactory
extends AbstractRandom
implements RandomFactory {
    private final NamedFactory factory;
    private final Random random;

    public SingletonRandomFactory(NamedFactory namedFactory) {
        this.factory = Objects.requireNonNull(namedFactory, "No factory");
        this.random = (Random)Objects.requireNonNull(namedFactory.create(), "No random instance created");
    }

    @Override
    public boolean isSupported() {
        if (this.factory instanceof OptionalFeature) {
            return ((OptionalFeature)((Object)this.factory)).isSupported();
        }
        return true;
    }

    @Override
    public void fill(byte[] byArray, int n2, int n3) {
        this.random.fill(byArray, n2, n3);
    }

    @Override
    public int random(int n2) {
        return this.random.random(n2);
    }

    @Override
    public String getName() {
        return this.factory.getName();
    }

    @Override
    public Random create() {
        return this;
    }
}

