/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.mac;

import java.nio.BufferOverflowException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class Poly1305Mac
implements Mac {
    public static final int KEY_BYTES = 32;
    private static final int BLOCK_SIZE = 16;
    private int r0;
    private int r1;
    private int r2;
    private int r3;
    private int r4;
    private int s1;
    private int s2;
    private int s3;
    private int s4;
    private int k0;
    private int k1;
    private int k2;
    private int k3;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private final byte[] currentBlock = new byte[16];
    private int currentBlockOffset;

    @Override
    public String getAlgorithm() {
        return "Poly1305";
    }

    @Override
    public void init(byte[] byArray) {
        if (NumberUtils.length(byArray) != 32) {
            throw new InvalidKeyException("Poly1305 key must be 32 bytes");
        }
        int n2 = Poly1305Mac.unpackIntLE(byArray, 0);
        int n3 = Poly1305Mac.unpackIntLE(byArray, 4);
        int n4 = Poly1305Mac.unpackIntLE(byArray, 8);
        int n5 = Poly1305Mac.unpackIntLE(byArray, 12);
        this.r0 = n2 & 0x3FFFFFF;
        this.r1 = (n2 >>> 26 | n3 << 6) & 0x3FFFF03;
        this.r2 = (n3 >>> 20 | n4 << 12) & 0x3FFC0FF;
        this.r3 = (n4 >>> 14 | n5 << 18) & 0x3F03FFF;
        this.r4 = n5 >>> 8 & 0xFFFFF;
        this.s1 = this.r1 * 5;
        this.s2 = this.r2 * 5;
        this.s3 = this.r3 * 5;
        this.s4 = this.r4 * 5;
        this.k0 = Poly1305Mac.unpackIntLE(byArray, 16);
        this.k1 = Poly1305Mac.unpackIntLE(byArray, 20);
        this.k2 = Poly1305Mac.unpackIntLE(byArray, 24);
        this.k3 = Poly1305Mac.unpackIntLE(byArray, 28);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            if (this.currentBlockOffset == 16) {
                this.processBlock();
            }
            int n4 = Math.min(n3, 16 - this.currentBlockOffset);
            System.arraycopy(byArray, n2, this.currentBlock, this.currentBlockOffset, n4);
            n2 += n4;
            n3 -= n4;
            this.currentBlockOffset += n4;
        }
    }

    @Override
    public void updateUInt(long l2) {
        byte[] byArray = new byte[4];
        BufferUtils.putUInt(l2, byArray);
        this.update(byArray);
    }

    @Override
    public void doFinal(byte[] byArray, int n2) {
        if (n2 + 16 > NumberUtils.length(byArray)) {
            throw new BufferOverflowException();
        }
        if (this.currentBlockOffset > 0) {
            this.processBlock();
        }
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        this.h2 += this.h1 >>> 26;
        this.h1 &= 0x3FFFFFF;
        this.h3 += this.h2 >>> 26;
        this.h2 &= 0x3FFFFFF;
        this.h4 += this.h3 >>> 26;
        this.h3 &= 0x3FFFFFF;
        this.h0 += (this.h4 >>> 26) * 5;
        this.h4 &= 0x3FFFFFF;
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        int n3 = this.h0 + 5;
        int n4 = n3 >>> 26;
        n3 &= 0x3FFFFFF;
        int n5 = this.h1 + n4;
        n4 = n5 >>> 26;
        n5 &= 0x3FFFFFF;
        int n6 = this.h2 + n4;
        n4 = n6 >>> 26;
        n6 &= 0x3FFFFFF;
        int n7 = this.h3 + n4;
        n4 = n7 >>> 26;
        n7 &= 0x3FFFFFF;
        int n8 = this.h4 + n4 - 0x4000000;
        n4 = (n8 >>> 31) - 1;
        int n9 = ~n4;
        this.h0 = this.h0 & n9 | n3 & n4;
        this.h1 = this.h1 & n9 | n5 & n4;
        this.h2 = this.h2 & n9 | n6 & n4;
        this.h3 = this.h3 & n9 | n7 & n4;
        this.h4 = this.h4 & n9 | n8 & n4;
        long l2 = Integer.toUnsignedLong(this.h0 | this.h1 << 26) + Integer.toUnsignedLong(this.k0);
        long l3 = Integer.toUnsignedLong(this.h1 >>> 6 | this.h2 << 20) + Integer.toUnsignedLong(this.k1);
        long l4 = Integer.toUnsignedLong(this.h2 >>> 12 | this.h3 << 14) + Integer.toUnsignedLong(this.k2);
        long l5 = Integer.toUnsignedLong(this.h3 >>> 18 | this.h4 << 8) + Integer.toUnsignedLong(this.k3);
        Poly1305Mac.packIntLE((int)l2, byArray, n2);
        Poly1305Mac.packIntLE((int)(l3 += l2 >>> 32), byArray, n2 + 4);
        Poly1305Mac.packIntLE((int)(l4 += l3 >>> 32), byArray, n2 + 8);
        Poly1305Mac.packIntLE((int)(l5 += l4 >>> 32), byArray, n2 + 12);
        this.reset();
    }

    private void processBlock() {
        if (this.currentBlockOffset < 16) {
            this.currentBlock[this.currentBlockOffset] = 1;
            for (int i2 = this.currentBlockOffset + 1; i2 < 16; ++i2) {
                this.currentBlock[i2] = 0;
            }
        }
        long l2 = Integer.toUnsignedLong(Poly1305Mac.unpackIntLE(this.currentBlock, 0));
        long l3 = Integer.toUnsignedLong(Poly1305Mac.unpackIntLE(this.currentBlock, 4));
        long l4 = Integer.toUnsignedLong(Poly1305Mac.unpackIntLE(this.currentBlock, 8));
        long l5 = Integer.toUnsignedLong(Poly1305Mac.unpackIntLE(this.currentBlock, 12));
        this.h0 = (int)((long)this.h0 + (l2 & 0x3FFFFFFL));
        this.h1 = (int)((long)this.h1 + ((l3 << 32 | l2) >>> 26 & 0x3FFFFFFL));
        this.h2 = (int)((long)this.h2 + ((l4 << 32 | l3) >>> 20 & 0x3FFFFFFL));
        this.h3 = (int)((long)this.h3 + ((l5 << 32 | l4) >>> 14 & 0x3FFFFFFL));
        this.h4 = (int)((long)this.h4 + (l5 >>> 8));
        if (this.currentBlockOffset == 16) {
            this.h4 += 0x1000000;
        }
        long l6 = Poly1305Mac.unsignedProduct(this.h0, this.r0) + Poly1305Mac.unsignedProduct(this.h1, this.s4) + Poly1305Mac.unsignedProduct(this.h2, this.s3) + Poly1305Mac.unsignedProduct(this.h3, this.s2) + Poly1305Mac.unsignedProduct(this.h4, this.s1);
        long l7 = Poly1305Mac.unsignedProduct(this.h0, this.r1) + Poly1305Mac.unsignedProduct(this.h1, this.r0) + Poly1305Mac.unsignedProduct(this.h2, this.s4) + Poly1305Mac.unsignedProduct(this.h3, this.s3) + Poly1305Mac.unsignedProduct(this.h4, this.s2);
        long l8 = Poly1305Mac.unsignedProduct(this.h0, this.r2) + Poly1305Mac.unsignedProduct(this.h1, this.r1) + Poly1305Mac.unsignedProduct(this.h2, this.r0) + Poly1305Mac.unsignedProduct(this.h3, this.s4) + Poly1305Mac.unsignedProduct(this.h4, this.s3);
        long l9 = Poly1305Mac.unsignedProduct(this.h0, this.r3) + Poly1305Mac.unsignedProduct(this.h1, this.r2) + Poly1305Mac.unsignedProduct(this.h2, this.r1) + Poly1305Mac.unsignedProduct(this.h3, this.r0) + Poly1305Mac.unsignedProduct(this.h4, this.s4);
        long l10 = Poly1305Mac.unsignedProduct(this.h0, this.r4) + Poly1305Mac.unsignedProduct(this.h1, this.r3) + Poly1305Mac.unsignedProduct(this.h2, this.r2) + Poly1305Mac.unsignedProduct(this.h3, this.r1) + Poly1305Mac.unsignedProduct(this.h4, this.r0);
        this.h0 = (int)l6 & 0x3FFFFFF;
        this.h1 = (int)(l7 += l6 >>> 26) & 0x3FFFFFF;
        this.h2 = (int)(l8 += l7 >>> 26) & 0x3FFFFFF;
        this.h3 = (int)(l9 += l8 >>> 26) & 0x3FFFFFF;
        this.h4 = (int)(l10 += l9 >>> 26) & 0x3FFFFFF;
        this.h0 += (int)(l10 >>> 26) * 5;
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        this.currentBlockOffset = 0;
    }

    private void reset() {
        this.h0 = 0;
        this.h1 = 0;
        this.h2 = 0;
        this.h3 = 0;
        this.h4 = 0;
        this.currentBlockOffset = 0;
        Arrays.fill(this.currentBlock, (byte)0);
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int getDefaultBlockSize() {
        return 16;
    }

    private static int unpackIntLE(byte[] byArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n3 |= Byte.toUnsignedInt(byArray[n2 + i2]) << i2 * 8;
        }
        return n3;
    }

    private static void packIntLE(int n2, byte[] byArray, int n3) {
        for (int i2 = 0; i2 < 4; ++i2) {
            byArray[n3 + i2] = (byte)(n2 >>> i2 * 8);
        }
    }

    private static long unsignedProduct(int n2, int n3) {
        return Integer.toUnsignedLong(n2) * Integer.toUnsignedLong(n3);
    }
}

