/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.mac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.mac.BaseMac;
import org.apache.sshd.common.mac.BuiltinMacs$1;
import org.apache.sshd.common.mac.BuiltinMacs$2;
import org.apache.sshd.common.mac.BuiltinMacs$3;
import org.apache.sshd.common.mac.BuiltinMacs$ParseResult;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.mac.MacFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class BuiltinMacs
extends Enum
implements MacFactory {
    @Deprecated
    public static final /* enum */ BuiltinMacs hmacmd5 = new BuiltinMacs("hmacmd5", 0, "hmac-md5", "HmacMD5", 16, 16);
    @Deprecated
    public static final /* enum */ BuiltinMacs hmacmd596 = new BuiltinMacs("hmacmd596", 1, "hmac-md5-96", "HmacMD5", 12, 16);
    public static final /* enum */ BuiltinMacs hmacsha1 = new BuiltinMacs("hmacsha1", 2, "hmac-sha1", "HmacSHA1", 20, 20);
    public static final /* enum */ BuiltinMacs hmacsha1etm = new BuiltinMacs$1("hmac-sha1-etm@openssh.com", "HmacSHA1", 20, 20);
    @Deprecated
    public static final /* enum */ BuiltinMacs hmacsha196 = new BuiltinMacs("hmacsha196", 4, "hmac-sha1-96", "HmacSHA1", 12, 20);
    public static final /* enum */ BuiltinMacs hmacsha256 = new BuiltinMacs("hmacsha256", 5, "hmac-sha2-256", "HmacSHA256", 32, 32);
    public static final /* enum */ BuiltinMacs hmacsha256etm = new BuiltinMacs$2("hmac-sha2-256-etm@openssh.com", "HmacSHA256", 32, 32);
    public static final /* enum */ BuiltinMacs hmacsha512 = new BuiltinMacs("hmacsha512", 7, "hmac-sha2-512", "HmacSHA512", 64, 64);
    public static final /* enum */ BuiltinMacs hmacsha512etm = new BuiltinMacs$3("hmac-sha2-512-etm@openssh.com", "HmacSHA512", 64, 64);
    public static final Set VALUES;
    private static final Map EXTENSIONS;
    private final String factoryName;
    private final String algorithm;
    private final int defbsize;
    private final int bsize;
    private static final /* synthetic */ BuiltinMacs[] $VALUES;

    public static BuiltinMacs[] values() {
        return (BuiltinMacs[])$VALUES.clone();
    }

    public static BuiltinMacs valueOf(String string) {
        return Enum.valueOf(BuiltinMacs.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinMacs(int n2, int n3) {
        void var6_4;
        void var5_3;
        void var2_-1;
        void var1_-1;
        this.factoryName = (String)n2;
        this.algorithm = (String)n3;
        this.bsize = var5_3;
        this.defbsize = var6_4;
    }

    @Override
    public Mac create() {
        return new BaseMac(this.getAlgorithm(), this.getBlockSize(), this.getDefaultBlockSize(), this.isEncryptThenMac());
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public final int getBlockSize() {
        return this.bsize;
    }

    @Override
    public final int getDefaultBlockSize() {
        return this.defbsize;
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    public final String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(MacFactory macFactory) {
        String string = Objects.requireNonNull(macFactory, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinMacs.fromFactoryName(string) == null, "Extension overrides built-in: %s", (Object)string);
        Map map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(string), "Extension overrides existing: %s", (Object)string);
            EXTENSIONS.put(string, macFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet getRegisteredExtensions() {
        Map map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MacFactory unregisterExtension(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (MacFactory)EXTENSIONS.remove(string);
        }
    }

    public static BuiltinMacs fromString(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (BuiltinMacs builtinMacs : VALUES) {
            if (!string.equalsIgnoreCase(builtinMacs.name())) continue;
            return builtinMacs;
        }
        return null;
    }

    public static BuiltinMacs fromFactory(NamedFactory namedFactory) {
        if (namedFactory == null) {
            return null;
        }
        return BuiltinMacs.fromFactoryName(namedFactory.getName());
    }

    public static BuiltinMacs fromFactoryName(String string) {
        return (BuiltinMacs)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinMacs$ParseResult parseMacsList(String string) {
        return BuiltinMacs.parseMacsList(GenericUtils.split(string, ','));
    }

    public static BuiltinMacs$ParseResult parseMacsList(String ... stringArray) {
        return BuiltinMacs.parseMacsList(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public static BuiltinMacs$ParseResult parseMacsList(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return BuiltinMacs$ParseResult.EMPTY;
        }
        ArrayList<MacFactory> arrayList = new ArrayList<MacFactory>(collection.size());
        List list = Collections.emptyList();
        for (String string : collection) {
            MacFactory macFactory = BuiltinMacs.resolveFactory(string);
            if (macFactory != null) {
                arrayList.add(macFactory);
                continue;
            }
            if (list.isEmpty()) {
                list = new ArrayList();
            }
            list.add(string);
        }
        return new BuiltinMacs$ParseResult(arrayList, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MacFactory resolveFactory(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        BuiltinMacs builtinMacs = BuiltinMacs.fromFactoryName(string);
        if (builtinMacs != null) {
            return builtinMacs;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (MacFactory)EXTENSIONS.get(string);
        }
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ BuiltinMacs(String string, String string2, int n2, int n3, BuiltinMacs$1 builtinMacs$1) {
        this((String)var1_-1, (int)string2, (String)n2, (String)n3, (int)builtinMacs$1, (int)var6_5);
        void var6_5;
        void var1_-1;
    }

    static {
        $VALUES = new BuiltinMacs[]{hmacmd5, hmacmd596, hmacsha1, hmacsha1etm, hmacsha196, hmacsha256, hmacsha256etm, hmacsha512, hmacsha512etm};
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinMacs.class));
        EXTENSIONS = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }
}

