/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.mac;

import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BaseMac
implements Mac {
    private final String algorithm;
    private final int defbsize;
    private final int bsize;
    private final byte[] tmp;
    private final boolean etmMode;
    private javax.crypto.Mac mac;
    private String s;

    public BaseMac(String string, int n2, int n3, boolean bl2) {
        this.algorithm = string;
        this.bsize = n2;
        this.defbsize = n3;
        this.tmp = new byte[n3];
        this.etmMode = bl2;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public int getDefaultBlockSize() {
        return this.defbsize;
    }

    @Override
    public boolean isEncryptThenMac() {
        return this.etmMode;
    }

    @Override
    public void init(byte[] byArray) {
        Object object;
        if (byArray.length > this.defbsize) {
            object = new byte[this.defbsize];
            System.arraycopy(byArray, 0, object, 0, this.defbsize);
            byArray = object;
        }
        object = new SecretKeySpec(byArray, this.algorithm);
        this.mac = SecurityUtils.getMac(this.algorithm);
        this.mac.init((Key)object);
    }

    @Override
    public void updateUInt(long l2) {
        this.tmp[0] = (byte)(l2 >>> 24);
        this.tmp[1] = (byte)(l2 >>> 16);
        this.tmp[2] = (byte)(l2 >>> 8);
        this.tmp[3] = (byte)l2;
        this.update(this.tmp, 0, 4);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.mac.update(byArray, n2, n3);
    }

    @Override
    public void doFinal(byte[] byArray, int n2) {
        int n3;
        int n4 = this.getBlockSize();
        if (n4 != (n3 = this.getDefaultBlockSize())) {
            this.mac.doFinal(this.tmp, 0);
            System.arraycopy(this.tmp, 0, byArray, n2, n4);
        } else {
            this.mac.doFinal(byArray, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BaseMac baseMac = this;
        synchronized (baseMac) {
            if (this.s == null) {
                this.s = this.getClass().getSimpleName() + "[" + this.getAlgorithm() + "] -  block=" + this.getBlockSize() + "/" + this.getDefaultBlockSize() + " bytes, encrypt-then-mac=" + this.isEncryptThenMac();
            }
        }
        return this.s;
    }
}

