/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionContextHolder;

public class MultiKeyIdentityIterator
implements Iterator,
SessionContextHolder {
    protected Iterator currentProvider;
    protected boolean finished;
    private final SessionContext sessionContext;
    private final Iterator providers;

    public MultiKeyIdentityIterator(SessionContext sessionContext, Iterable iterable) {
        this.providers = iterable == null ? null : iterable.iterator();
        this.sessionContext = sessionContext;
    }

    public Iterator getProviders() {
        return this.providers;
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        Iterator iterator = this.getProviders();
        if (iterator == null) {
            this.finished = true;
            return false;
        }
        if (this.currentProvider != null && this.currentProvider.hasNext()) {
            return true;
        }
        SessionContext sessionContext = this.getSessionContext();
        while (iterator.hasNext()) {
            Iterable iterable;
            KeyIdentityProvider keyIdentityProvider = (KeyIdentityProvider)iterator.next();
            try {
                iterable = keyIdentityProvider == null ? null : keyIdentityProvider.loadKeys(sessionContext);
            }
            catch (IOException | GeneralSecurityException exception) {
                throw new IllegalArgumentException("Unexpected " + exception.getClass().getSimpleName() + ") keys loading exception: " + exception.getMessage(), exception);
            }
            Iterator iterator2 = this.currentProvider = iterable == null ? null : iterable.iterator();
            if (this.currentProvider == null || !this.currentProvider.hasNext()) continue;
            return true;
        }
        this.finished = false;
        return false;
    }

    public KeyPair next() {
        if (this.finished) {
            throw new NoSuchElementException("All identities have been exhausted");
        }
        if (this.currentProvider == null) {
            throw new IllegalStateException("'next()' called without asking 'hasNext()'");
        }
        return (KeyPair)this.currentProvider.next();
    }
}

